/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.scripting.ScriptPigContext;
import org.apache.pig.tools.pigstats.PigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptEngine {
    private static final Pattern shebangPattern = Pattern.compile("^#!.+");
    public static final String NAMESPACE_SEPARATOR = ".";
    private Map<String, List<PigStats>> statsMap = new HashMap<String, List<PigStats>>();

    private static boolean declaresShebang(String firstLine) {
        if (firstLine == null) {
            return false;
        }
        return shebangPattern.matcher(firstLine).matches();
    }

    public static InputStream getScriptAsStream(String scriptPath) {
        InputStream is = null;
        File file = new File(scriptPath);
        if (file.exists()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("could not find existing file " + scriptPath, e);
            }
        } else {
            is = file.isAbsolute() ? ScriptEngine.class.getResourceAsStream(scriptPath) : ScriptEngine.class.getResourceAsStream("/" + scriptPath);
        }
        if (is == null) {
            throw new IllegalStateException("Could not initialize interpreter (from file system or classpath) with " + scriptPath);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SupportedScriptLang getSupportedScriptLang(String file) throws IOException {
        String firstLine;
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            firstLine = br.readLine();
        }
        finally {
            br.close();
        }
        for (SupportedScriptLang supportedScriptLang : SupportedScriptLang.values()) {
            if (!supportedScriptLang.accepts(file, firstLine)) continue;
            return supportedScriptLang;
        }
        if (ScriptEngine.declaresShebang(firstLine)) {
            throw new IOException("Unsupported script type is specified: " + firstLine);
        }
        return null;
    }

    public abstract void registerFunctions(String var1, String var2, PigContext var3) throws IOException;

    protected abstract Map<String, List<PigStats>> main(PigContext var1, String var2) throws IOException;

    protected abstract String getScriptingLang();

    protected abstract Map<String, Object> getParamsFromVariables() throws IOException;

    public static String getJarPath(Class<?> clazz) throws FileNotFoundException {
        URL resource = clazz.getClassLoader().getResource(clazz.getCanonicalName().replace(NAMESPACE_SEPARATOR, "/") + ".class");
        if (resource.getProtocol().equals("jar")) {
            return resource.getPath().substring(resource.getPath().indexOf(58) + 1, resource.getPath().indexOf(33));
        }
        throw new FileNotFoundException("Jar for " + clazz.getName() + " class is not found");
    }

    public static ScriptEngine getInstance(String scriptingLang) throws IOException {
        String scriptingEngine = scriptingLang;
        try {
            if (SupportedScriptLang.contains(scriptingLang)) {
                SupportedScriptLang supportedScriptLang = SupportedScriptLang.valueOf(scriptingLang);
                scriptingEngine = supportedScriptLang.getEngineClassName();
            }
            return (ScriptEngine)Class.forName(scriptingEngine).newInstance();
        }
        catch (Exception e) {
            throw new IOException("Could not load ScriptEngine: " + scriptingEngine + " for " + scriptingLang + " (Supported langs: " + SupportedScriptLang.supportedScriptLangs + ") : " + e, e);
        }
    }

    public Map<String, List<PigStats>> run(PigContext pigContext, String scriptFile) throws ExecException, IOException {
        ScriptPigContext.set(pigContext, this);
        return this.main(pigContext, scriptFile);
    }

    protected Map<String, List<PigStats>> getPigStatsMap() {
        return this.statsMap;
    }

    void setPigStats(String key, PigStats stats) {
        List<PigStats> lst = this.statsMap.get(key);
        if (lst == null) {
            lst = new ArrayList<PigStats>();
            this.statsMap.put(key, lst);
        }
        lst.add(stats);
    }

    void setPigStats(String key, List<PigStats> stats) {
        this.statsMap.put(key, stats);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SupportedScriptLang {
        jruby(new String[]{"ruby", "jruby"}, new String[]{"rb"}, "org.apache.pig.scripting.jruby.JrubyScriptEngine"),
        jython(new String[]{"python", "jython"}, new String[]{"py"}, "org.apache.pig.scripting.jython.JythonScriptEngine"),
        javascript(new String[0], new String[]{"js"}, "org.apache.pig.scripting.js.JsScriptEngine");

        private static Set<String> supportedScriptLangs;
        private String[] shebangs;
        private String[] extensions;
        private String engineClassName;

        public static boolean contains(String supportedScriptLang) {
            return supportedScriptLangs.contains(supportedScriptLang);
        }

        private SupportedScriptLang(String[] shebangs, String[] extensions, String engineClassName) {
            this.shebangs = shebangs;
            this.extensions = extensions;
            this.engineClassName = engineClassName;
        }

        public boolean accepts(String file, String firstLine) {
            if (firstLine == null) {
                return false;
            }
            for (String shebang : this.shebangs) {
                Pattern p = Pattern.compile("^#!.*/" + shebang + "\\s*$");
                if (!p.matcher(firstLine).matches()) continue;
                return true;
            }
            for (String ext : this.extensions) {
                if (!file.endsWith(ScriptEngine.NAMESPACE_SEPARATOR + ext)) continue;
                return true;
            }
            return false;
        }

        public String getEngineClassName() {
            return this.engineClassName;
        }

        static {
            supportedScriptLangs = new HashSet<String>();
            for (SupportedScriptLang value : SupportedScriptLang.values()) {
                supportedScriptLangs.add(value.name());
            }
            supportedScriptLangs = Collections.unmodifiableSet(supportedScriptLangs);
        }
    }
}

