/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Schema"})
public class RubySchema
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final Pattern bmtPattern = Pattern.compile("(?:\\S+:)?(bag|map|tuple)\\s*(?:,|$)", 2);
    private Schema internalSchema;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySchema(runtime, klass);
        }
    };

    public static RubyClass define(Ruby runtime) {
        RubyClass result = runtime.defineClass("Schema", runtime.getObject(), ALLOCATOR);
        result.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubySchema;
            }
        };
        result.includeModule((IRubyObject)runtime.getEnumerable());
        result.defineAnnotatedMethods(RubySchema.class);
        return result;
    }

    protected RubySchema(Ruby ruby, RubyClass rc) {
        super(ruby, rc);
        this.internalSchema = new Schema();
    }

    protected RubySchema(Ruby ruby, RubyClass rc, Schema s, boolean copy) {
        super(ruby, rc);
        this.internalSchema = copy ? new Schema(s) : s;
    }

    protected RubySchema(Ruby ruby, RubyClass rc, Schema s) {
        this(ruby, rc, s, true);
    }

    protected RubySchema(Ruby ruby, RubyClass rc, String s) {
        super(ruby, rc);
        try {
            this.internalSchema = Utils.getSchemaFromString(s);
        }
        catch (ParserException e) {
            throw new RuntimeException("Error converting String to Schema: " + s, e);
        }
    }

    @JRubyMethod(rest=true)
    public RubySchema initialize(IRubyObject[] args) {
        this.internalSchema = new Schema();
        for (IRubyObject arg : args) {
            Schema rs = RubySchema.rubyArgToSchema(arg);
            for (Schema.FieldSchema i : rs.getFields()) {
                this.internalSchema.add(i);
            }
        }
        RubySchema.fixSchemaNames(this.internalSchema);
        return this;
    }

    @JRubyMethod(meta=true, name={"by", "bytearray"})
    public static RubySchema nullBytearray(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)50);
    }

    @JRubyMethod(meta=true, name={"bool", "boolean"})
    public static RubySchema nullBoolean(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)5);
    }

    @JRubyMethod(meta=true, name={"c", "chararray"})
    public static RubySchema nullChararray(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)55);
    }

    @JRubyMethod(meta=true, name={"l", "long"})
    public static RubySchema nullLong(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)15);
    }

    @JRubyMethod(meta=true, name={"i", "int"})
    public static RubySchema nullInt(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)10);
    }

    @JRubyMethod(meta=true, name={"d", "double"})
    public static RubySchema nullDouble(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)25);
    }

    @JRubyMethod(meta=true, name={"f", "float"})
    public static RubySchema nullFloate(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)20);
    }

    @JRubyMethod(meta=true, name={"t", "tuple"})
    public static RubySchema nullTuple(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)110);
    }

    @JRubyMethod(meta=true, name={"b", "bag"})
    public static RubySchema nullBag(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)120);
    }

    @JRubyMethod(meta=true, name={"m", "map"})
    public static RubySchema nullMap(ThreadContext context, IRubyObject self) {
        return RubySchema.makeNullAliasRubySchema(context, (byte)100);
    }

    private static RubySchema makeNullAliasRubySchema(ThreadContext context, byte type) {
        Ruby runtime = context.getRuntime();
        return new RubySchema(runtime, runtime.getClass("Schema"), new Schema(new Schema.FieldSchema(null, type)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Schema rubyArgToSchema(Object arg) {
        try {
            if (arg instanceof String || arg instanceof RubyString) {
                String s = arg.toString();
                Matcher m = bmtPattern.matcher(s);
                while (m.find()) {
                    String type = m.group(1);
                    String inter = s.substring(0, m.start(1));
                    if (type.equalsIgnoreCase("bag")) {
                        inter = inter + "{}";
                    } else if (type.equalsIgnoreCase("map")) {
                        inter = inter + "[]";
                    } else {
                        if (!type.equalsIgnoreCase("tuple")) throw new RuntimeException("Arriving here should be impossible");
                        inter = inter + "()";
                    }
                    s = inter + s.substring(m.end(1));
                    m = bmtPattern.matcher(s);
                }
                return Utils.getSchemaFromString(s);
            }
            if (arg instanceof RubySchema) {
                return ((RubySchema)((Object)arg)).getInternalSchema();
            }
            if (arg instanceof RubyArray) {
                RubyArray ary = (RubyArray)arg;
                Schema s = new Schema();
                for (Object o : ary) {
                    Schema ts = RubySchema.rubyArgToSchema(o);
                    for (Schema.FieldSchema fs : ts.getFields()) {
                        s.add(fs);
                    }
                }
                return new Schema(new Schema.FieldSchema("tuple_0", s, 110));
            }
            if (!(arg instanceof RubyHash)) throw new RuntimeException("Bad argument given to rubyToSchema: " + arg + (arg != null ? " class type " + arg.getClass().toString() : ""));
            RubyHash hash = (RubyHash)arg;
            Schema hashSchema = new Schema();
            for (Object o : hash.keySet()) {
                Schema s = RubySchema.rubyArgToSchema(o);
                if (s.size() != 1) {
                    throw new RuntimeException("Hash key must be singular");
                }
                Schema.FieldSchema fs = s.getField(0);
                Object v = hash.get(o);
                if (!(v instanceof RubyArray)) throw new RuntimeException("Hash value must be an Array");
                byte type = fs.type;
                if (type == 120) {
                    fs.schema = RubySchema.rubyArgToSchema(v);
                } else {
                    if (type != 110 && type != 100) throw new RuntimeException("Hash key must be tuple map or bag");
                    fs.schema = RubySchema.rubyArgToSchema((Object)v).getField((int)0).schema;
                }
                hashSchema.add(fs);
            }
            return hashSchema;
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting ruby to Schema: " + arg, e);
        }
    }

    @JRubyMethod(meta=true, name={"t", "tuple"})
    public static RubySchema tuple(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        RubySchema rs = RubySchema.tuple(context, self, arg2);
        rs.setNameIf(arg1);
        return rs;
    }

    @JRubyMethod(meta=true, name={"t", "tuple"})
    public static RubySchema tuple(ThreadContext context, IRubyObject self, IRubyObject arg) {
        if (arg instanceof RubyArray) {
            Schema s = RubySchema.rubyArgToSchema(arg);
            Ruby runtime = context.getRuntime();
            return new RubySchema(runtime, runtime.getClass("Schema"), s);
        }
        throw new RuntimeException("Bad argument given to Schema.tuple");
    }

    @JRubyMethod(meta=true, name={"m", "map"})
    public static RubySchema map(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        RubySchema rs = RubySchema.map(context, self, arg2);
        rs.setNameIf(arg1);
        return rs;
    }

    @JRubyMethod(meta=true, name={"m", "map"})
    public static RubySchema map(ThreadContext context, IRubyObject self, IRubyObject arg) {
        Schema s = RubySchema.tuple(context, self, arg).getInternalSchema();
        Ruby runtime = context.getRuntime();
        try {
            return new RubySchema(runtime, runtime.getClass("Schema"), new Schema(new Schema.FieldSchema("map_0", s.getField((int)0).schema, 100)));
        }
        catch (FrontendException e) {
            throw new RuntimeException("Error making map", e);
        }
    }

    @JRubyMethod(meta=true, name={"b", "bag"})
    public static RubySchema bag(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        RubySchema rs = RubySchema.bag(context, self, arg2);
        rs.setNameIf(arg1);
        return rs;
    }

    @JRubyMethod(meta=true, name={"b", "bag"})
    public static RubySchema bag(ThreadContext context, IRubyObject self, IRubyObject arg) {
        Schema s = RubySchema.tuple(context, self, arg).getInternalSchema();
        Ruby runtime = context.getRuntime();
        try {
            return new RubySchema(runtime, runtime.getClass("Schema"), new Schema(new Schema.FieldSchema("bag_0", s, 120)));
        }
        catch (FrontendException e) {
            throw new RuntimeException("Error making map", e);
        }
    }

    private static void fixSchemaNames(Schema s) {
        if (s == null) {
            return;
        }
        Pattern p = Pattern.compile("(bag_|tuple_|map_|val_)(\\d+)", 2);
        HashSet<String> names = new HashSet<String>(s.size(), 1.0f);
        for (Schema.FieldSchema fs : s.getFields()) {
            if (fs.alias == null) continue;
            Matcher m = p.matcher(fs.alias);
            if (m.matches() && names.contains(fs.alias)) {
                String prefix = m.group(1);
                int suffix = Integer.parseInt(m.group(2));
                while (names.contains(prefix + suffix)) {
                    ++suffix;
                }
                fs.alias = prefix + suffix;
            }
            names.add(fs.alias);
            if (fs.schema == null) continue;
            if (fs.type == 120) {
                try {
                    RubySchema.fixSchemaNames(fs.schema.getField((int)0).schema);
                    continue;
                }
                catch (FrontendException e) {
                    throw new RuntimeException("Error recursively fixing schema: " + s, e);
                }
            }
            RubySchema.fixSchemaNames(fs.schema);
        }
    }

    private void setNameIf(IRubyObject arg) {
        if (!(arg instanceof RubyString)) {
            throw new RuntimeException("Bad name given");
        }
        this.setName(arg.toString());
    }

    private void setName(String name) {
        Schema.FieldSchema fs;
        try {
            fs = this.internalSchema.getField(0);
        }
        catch (FrontendException e) {
            throw new RuntimeException("Error getting field from schema: " + this.internalSchema, e);
        }
        byte type = fs.type;
        if (type != 110 && type != 120 && type != 100) {
            throw new RuntimeException("setName cannot be set on Schema: " + this.internalSchema);
        }
        fs.alias = name;
    }

    @JRubyMethod(name={"to_s", "inspect"})
    public RubyString toString(ThreadContext context) {
        return RubyString.newString((Ruby)context.getRuntime(), (String)this.internalSchema.toString());
    }

    @JRubyMethod(name={"[]", "slice"})
    public RubySchema get(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        if (arg instanceof RubyFixnum) {
            Schema s;
            int index = (int)((RubyFixnum)arg).getLongValue();
            try {
                s = new Schema(this.internalSchema.getField(index));
            }
            catch (FrontendException e) {
                throw new RuntimeException("Invalid index given to get function: " + index, e);
            }
            return new RubySchema(runtime, runtime.getClass("Schema"), s, false);
        }
        if (arg instanceof RubyRange) {
            int min = (int)((RubyFixnum)((RubyRange)arg).min(context, Block.NULL_BLOCK)).getLongValue();
            int max = (int)((RubyFixnum)((RubyRange)arg).max(context, Block.NULL_BLOCK)).getLongValue();
            return new RubySchema(runtime, runtime.getClass("Schema"), new Schema(this.internalSchema.getFields().subList(min, max + 1)), false);
        }
        if (arg instanceof RubyString) {
            try {
                return new RubySchema(runtime, runtime.getClass("Schema"), new Schema(this.internalSchema.getField(arg.toString())), false);
            }
            catch (FrontendException e) {
                throw new RuntimeException("Unable to find field " + arg.toString() + " in schema " + this.internalSchema, e);
            }
        }
        throw new RuntimeException("Invalid argument given to get function: " + arg.toString());
    }

    @JRubyMethod(name={"[]", "slice"})
    public RubySchema get(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        if (arg1 instanceof RubyFixnum && arg2 instanceof RubyFixnum) {
            Ruby runtime = context.getRuntime();
            int min = (int)((RubyFixnum)arg1).getLongValue();
            int max = (int)((RubyFixnum)arg2).getLongValue() - 1;
            return new RubySchema(runtime, runtime.getClass("Schema"), new Schema(this.internalSchema.getFields().subList(min, max + 1)), false);
        }
        throw new RuntimeException("Bad arguments given to get function: ( " + arg1.toString() + " , " + arg2.toString() + " )");
    }

    @JRubyMethod(name={"[]=", "set"}, required=2, rest=true)
    public RubySchema set(ThreadContext context, IRubyObject[] args) {
        int max;
        int min;
        IRubyObject arg1 = args[0];
        IRubyObject arg2 = args[1];
        IRubyObject[] arg3 = Arrays.copyOfRange(args, 1, args.length);
        Schema s = this.internalSchema;
        Ruby runtime = context.getRuntime();
        List<Schema.FieldSchema> lfs = s.getFields();
        if (arg1 instanceof RubyFixnum && arg2 instanceof RubyFixnum) {
            min = (int)((RubyFixnum)arg1).getLongValue();
            max = (int)((RubyFixnum)arg2).getLongValue();
            arg3 = Arrays.copyOfRange(args, 2, args.length);
        } else if (arg1 instanceof RubyFixnum) {
            min = (int)((RubyFixnum)arg1).getLongValue();
            max = min + 1;
        } else if (arg1 instanceof RubyRange) {
            min = (int)((RubyFixnum)((RubyRange)arg1).min(context, Block.NULL_BLOCK)).getLongValue();
            max = (int)((RubyFixnum)((RubyRange)arg1).max(context, Block.NULL_BLOCK)).getLongValue() + 1;
        } else {
            throw new RuntimeException("Bad arguments given to get function: ( " + arg1.toString() + " , " + arg2.toString() + " )");
        }
        for (int i = min; i < max; ++i) {
            lfs.remove(min);
        }
        if (arg3 == null || arg3.length == 0) {
            throw new RuntimeException("Must have schema argument for []=");
        }
        RubySchema rs = new RubySchema(runtime, runtime.getClass("Schema")).initialize(arg3);
        for (Schema.FieldSchema fs : rs.getInternalSchema().getFields()) {
            lfs.add(min++, fs);
        }
        RubySchema.fixSchemaNames(this.internalSchema);
        return rs;
    }

    @JRubyMethod(name={"add", "+"}, rest=true)
    public RubySchema add(ThreadContext context, IRubyObject[] args) {
        RubySchema rsClone = this.clone(context);
        rsClone.addInPlace(context, args);
        return rsClone;
    }

    @JRubyMethod(name={"add!"}, rest=true)
    public void addInPlace(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        List<Schema.FieldSchema> lfs = this.internalSchema.getFields();
        RubySchema rs = new RubySchema(runtime, runtime.getClass("Schema")).initialize(args);
        for (Schema.FieldSchema fs : rs.getInternalSchema().getFields()) {
            lfs.add(fs);
        }
        RubySchema.fixSchemaNames(this.internalSchema);
    }

    @JRubyMethod
    public RubySchema clone(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        return new RubySchema(runtime, runtime.getClass("Schema"), this.internalSchema);
    }

    @JRubyMethod
    public RubySchema find(ThreadContext context, IRubyObject arg) {
        if (arg instanceof RubyString) {
            Ruby runtime = context.getRuntime();
            return new RubySchema(runtime, runtime.getClass("Schema"), RubySchema.find(this.internalSchema, arg.toString()), false);
        }
        throw new RuntimeException("Invalid arguement passed to find: " + arg);
    }

    private static Schema find(Schema s, String alias) {
        for (Schema.FieldSchema fs : s.getFields()) {
            if (!alias.equals(fs.alias)) continue;
            return new Schema(fs);
        }
        for (Schema.FieldSchema fs : s.getFields()) {
            Schema r;
            if (fs.schema == null || (r = RubySchema.find(fs.schema, alias)) == null) continue;
            return r;
        }
        return new Schema();
    }

    @JRubyMethod
    public RubyFixnum index(ThreadContext context, IRubyObject arg) {
        if (arg instanceof RubyString) {
            try {
                return new RubyFixnum(context.getRuntime(), (long)this.internalSchema.getPosition(arg.toString()));
            }
            catch (FrontendException e) {
                throw new RuntimeException("Unable to find position for argument: " + arg);
            }
        }
        throw new RuntimeException("Invalid arguement passed to index: " + arg);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size(ThreadContext context) {
        return new RubyFixnum(context.getRuntime(), (long)this.internalSchema.size());
    }

    public Schema getInternalSchema() {
        return this.internalSchema;
    }

    @JRubyMethod(name={"get", "inner", "in"})
    public RubySchema get(ThreadContext context) {
        if (this.internalSchema.size() != 1) {
            throw new RuntimeException("Can only return nested schema if there is one schema to get");
        }
        Ruby runtime = context.getRuntime();
        try {
            return new RubySchema(runtime, runtime.getClass("Schema"), this.internalSchema.getField((int)0).schema, false);
        }
        catch (FrontendException e) {
            throw new RuntimeException("Schema does not have a nested FieldScema", e);
        }
    }

    @JRubyMethod(name={"name"})
    public RubyString getName(ThreadContext context) {
        try {
            if (this.internalSchema.size() != 1) {
                throw new RuntimeException("Can only get name if there is one schema present");
            }
            return RubyString.newString((Ruby)context.getRuntime(), (String)this.internalSchema.getField((int)0).alias);
        }
        catch (FrontendException e) {
            throw new RuntimeException("Unable to get field from Schema", e);
        }
    }

    @JRubyMethod(name={"name="})
    public RubyString setName(IRubyObject arg) {
        if (arg instanceof RubyString) {
            if (this.internalSchema.size() != 1) {
                throw new RuntimeException("Can only set name if there is one schema present");
            }
            try {
                this.internalSchema.getField((int)0).alias = arg.toString();
                return (RubyString)arg;
            }
            catch (FrontendException e) {
                throw new RuntimeException("Unable to get field from Schema", e);
            }
        }
        throw new RuntimeException("Improper argument passed to 'name=':" + arg);
    }
}

