/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.VersionInfo;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigProgressNotificationListener;
import org.apache.pig.tools.pigstats.PigStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptState {
    public static final String INSERT_ENABLED = "pig.script.info.enabled";
    public static final int MAX_SCRIPT_SIZE = 10240;
    private static final Log LOG = LogFactory.getLog(ScriptState.class);
    private static ThreadLocal<ScriptState> tss = new ThreadLocal();
    private String id;
    private String script;
    private String commandLine;
    private String fileName;
    private String pigVersion;
    private String hodoopVersion;
    private long scriptFeatures;
    private PigContext pigContext;
    private Map<MapReduceOper, String> featureMap = null;
    private Map<MapReduceOper, String> aliasMap = null;
    private List<PigProgressNotificationListener> listeners = new ArrayList<PigProgressNotificationListener>();

    public static ScriptState start(String commandLine, PigContext pigContext) {
        ScriptState ss = new ScriptState(UUID.randomUUID().toString());
        ss.setCommandLine(commandLine);
        ss.setPigContext(pigContext);
        tss.set(ss);
        return ss;
    }

    private ScriptState(String id) {
        this.id = id;
        this.script = "";
    }

    public static ScriptState get() {
        if (tss.get() == null) {
            ScriptState.start("", null);
        }
        return tss.get();
    }

    public void registerListener(PigProgressNotificationListener listener) {
        this.listeners.add(listener);
    }

    public List<PigProgressNotificationListener> getAllListeners() {
        return this.listeners;
    }

    public void emitLaunchStartedNotification(int numJobsToLaunch) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.launchStartedNotification(this.id, numJobsToLaunch);
        }
    }

    public void emitJobsSubmittedNotification(int numJobsSubmitted) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobsSubmittedNotification(this.id, numJobsSubmitted);
        }
    }

    public void emitJobStartedNotification(String assignedJobId) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobStartedNotification(this.id, assignedJobId);
        }
    }

    public void emitjobFinishedNotification(JobStats jobStats) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobFinishedNotification(this.id, jobStats);
        }
    }

    public void emitJobFailedNotification(JobStats jobStats) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobFailedNotification(this.id, jobStats);
        }
    }

    public void emitOutputCompletedNotification(OutputStats outputStats) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.outputCompletedNotification(this.id, outputStats);
        }
    }

    public void emitProgressUpdatedNotification(int progress) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.progressUpdatedNotification(this.id, progress);
        }
    }

    public void emitLaunchCompletedNotification(int numJobsSucceeded) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.launchCompletedNotification(this.id, numJobsSucceeded);
        }
    }

    public void addSettingsToConf(MapReduceOper mro, Configuration conf) {
        ArrayList<String> outputDirs;
        LinkedList<POStore> stores;
        LOG.info((Object)"Pig script settings are added to the job");
        conf.set(PIG_PROPERTY.HADOOP_VERSION.toString(), this.getHadoopVersion());
        conf.set(PIG_PROPERTY.VERSION.toString(), this.getPigVersion());
        conf.set(PIG_PROPERTY.SCRIPT_ID.toString(), this.id);
        conf.set(PIG_PROPERTY.SCRIPT.toString(), this.getScript());
        conf.set(PIG_PROPERTY.COMMAND_LINE.toString(), this.getCommandLine());
        try {
            stores = PlanHelper.getStores(mro.mapPlan);
            outputDirs = new ArrayList<String>();
            for (POStore st : stores) {
                outputDirs.add(st.getSFile().getFileName());
            }
            conf.set(PIG_PROPERTY.MAP_OUTPUT_DIRS.toString(), LoadFunc.join(outputDirs, ","));
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get the map stores", (Throwable)e);
        }
        if (!mro.reducePlan.isEmpty()) {
            try {
                stores = PlanHelper.getStores(mro.reducePlan);
                outputDirs = new ArrayList();
                for (POStore st : stores) {
                    outputDirs.add(st.getSFile().getFileName());
                }
                conf.set(PIG_PROPERTY.REDUCE_OUTPUT_DIRS.toString(), LoadFunc.join(outputDirs, ","));
            }
            catch (VisitorException e) {
                LOG.warn((Object)"unable to get the reduce stores", (Throwable)e);
            }
        }
        try {
            LinkedList<POLoad> lds = PlanHelper.getLoads(mro.mapPlan);
            ArrayList<String> inputDirs = new ArrayList<String>();
            if (lds != null && lds.size() > 0) {
                for (POLoad ld : lds) {
                    inputDirs.add(ld.getLFile().getFileName());
                }
                conf.set(PIG_PROPERTY.INPUT_DIRS.toString(), LoadFunc.join(inputDirs, ","));
            }
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get the map loads", (Throwable)e);
        }
        this.setPigFeature(mro, conf);
        this.setJobParents(mro, conf);
    }

    public void setScript(File file) {
        try {
            this.setScript(new BufferedReader(new FileReader(file)));
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)"unable to find the file", (Throwable)e);
        }
    }

    public void setScript(String script) {
        if (script == null) {
            return;
        }
        script = script.length() > 10240 ? script.substring(0, 10240) : script;
        this.script = new String(Base64.encodeBase64((byte[])script.getBytes()));
    }

    public void setScriptFeatures(LogicalPlan plan) {
        BitSet bs = new BitSet();
        try {
            new LogicalPlanFeatureVisitor(plan, bs).visit();
        }
        catch (FrontendException e) {
            LOG.warn((Object)"unable to get script feature", (Throwable)e);
        }
        this.scriptFeatures = this.bitSetToLong(bs);
        LOG.info((Object)("Pig features used in the script: " + this.featureLongToString(this.scriptFeatures)));
    }

    public String getHadoopVersion() {
        if (this.hodoopVersion == null) {
            this.hodoopVersion = VersionInfo.getVersion();
        }
        return this.hodoopVersion == null ? "" : this.hodoopVersion;
    }

    public String getPigVersion() {
        if (this.pigVersion == null) {
            String findContainingJar = JarManager.findContainingJar(ScriptState.class);
            try {
                JarFile jar = new JarFile(findContainingJar);
                Manifest manifest = jar.getManifest();
                Map<String, Attributes> attrs = manifest.getEntries();
                Attributes attr = attrs.get("org/apache/pig");
                this.pigVersion = attr.getValue("Implementation-Version");
            }
            catch (Exception e) {
                LOG.warn((Object)"unable to read pigs manifest file");
            }
        }
        return this.pigVersion == null ? "" : this.pigVersion;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    String getId() {
        return this.id;
    }

    private String getCommandLine() {
        return this.commandLine == null ? "" : this.commandLine;
    }

    private void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    private String getScript() {
        return this.script == null ? "" : this.script;
    }

    private void setScript(BufferedReader reader) {
        StringBuilder sb = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    sb.append(line).append("\n");
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"unable to parse the script", (Throwable)e);
        }
        this.setScript(sb.toString());
    }

    private void setPigFeature(MapReduceOper mro, Configuration conf) {
        conf.set(PIG_PROPERTY.JOB_FEATURE.toString(), this.getPigFeature(mro));
        if (this.scriptFeatures != 0L) {
            conf.set(PIG_PROPERTY.SCRIPT_FEATURES.toString(), String.valueOf(this.scriptFeatures));
        }
        conf.set(PIG_PROPERTY.JOB_ALIAS.toString(), this.getAlias(mro));
    }

    private void setJobParents(MapReduceOper mro, Configuration conf) {
        List<Operator> preds;
        PigStats.JobGraph jg = PigStats.get().getJobGraph();
        JobStats js = null;
        for (JobStats job : jg) {
            if (!job.getName().equals(mro.getOperatorKey().toString())) continue;
            js = job;
            break;
        }
        if (js != null && (preds = jg.getPredecessors(js)) != null) {
            StringBuilder sb = new StringBuilder();
            for (Operator op : preds) {
                JobStats job = (JobStats)op;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(job.getJobId());
            }
            conf.set(PIG_PROPERTY.JOB_PARENTS.toString(), sb.toString());
        }
    }

    String getScriptFeatures() {
        return this.featureLongToString(this.scriptFeatures);
    }

    String getAlias(MapReduceOper mro) {
        String retStr;
        if (this.aliasMap == null) {
            this.aliasMap = new HashMap<MapReduceOper, String>();
        }
        if ((retStr = this.aliasMap.get(mro)) == null) {
            ArrayList<String> alias = new ArrayList<String>();
            try {
                new AliasVisitor(mro.mapPlan, alias).visit();
                new AliasVisitor(mro.reducePlan, alias).visit();
                if (!alias.isEmpty()) {
                    Collections.sort(alias);
                }
            }
            catch (VisitorException e) {
                LOG.warn((Object)"unable to get alias", (Throwable)e);
            }
            retStr = LoadFunc.join(alias, ",");
            this.aliasMap.put(mro, retStr);
        }
        return retStr;
    }

    String getPigFeature(MapReduceOper mro) {
        String retStr;
        if (this.featureMap == null) {
            this.featureMap = new HashMap<MapReduceOper, String>();
        }
        if ((retStr = this.featureMap.get(mro)) == null) {
            BitSet feature = new BitSet();
            feature.clear();
            if (mro.isSkewedJoin()) {
                feature.set(PIG_FEATURE.SKEWED_JOIN.ordinal());
            }
            if (mro.isGlobalSort()) {
                feature.set(PIG_FEATURE.ORDER_BY.ordinal());
            }
            if (mro.isSampler()) {
                feature.set(PIG_FEATURE.SAMPLER.ordinal());
            }
            if (mro.isIndexer()) {
                feature.set(PIG_FEATURE.INDEXER.ordinal());
            }
            if (mro.isCogroup()) {
                feature.set(PIG_FEATURE.COGROUP.ordinal());
            }
            if (mro.isGroupBy()) {
                feature.set(PIG_FEATURE.GROUP_BY.ordinal());
            }
            if (mro.isRegularJoin()) {
                feature.set(PIG_FEATURE.HASH_JOIN.ordinal());
            }
            if (mro.needsDistinctCombiner()) {
                feature.set(PIG_FEATURE.DISTINCT.ordinal());
            }
            if (!mro.combinePlan.isEmpty()) {
                feature.set(PIG_FEATURE.COMBINER.ordinal());
            }
            if (mro instanceof NativeMapReduceOper) {
                feature.set(PIG_FEATURE.NATIVE.ordinal());
            } else {
                try {
                    new FeatureVisitor(mro.mapPlan, feature).visit();
                    if (mro.reducePlan.isEmpty()) {
                        feature.set(PIG_FEATURE.MAP_ONLY.ordinal());
                    } else {
                        new FeatureVisitor(mro.reducePlan, feature).visit();
                    }
                }
                catch (VisitorException e) {
                    LOG.warn((Object)"Feature visitor failed", (Throwable)e);
                }
            }
            StringBuilder sb = new StringBuilder();
            int i = feature.nextSetBit(0);
            while (i >= 0) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(PIG_FEATURE.values()[i].name());
                i = feature.nextSetBit(i + 1);
            }
            retStr = sb.toString();
            this.featureMap.put(mro, retStr);
        }
        return retStr;
    }

    private long bitSetToLong(BitSet bs) {
        long ret = 0L;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            ret |= 1L << i;
            i = bs.nextSetBit(i + 1);
        }
        return ret;
    }

    private String featureLongToString(long l) {
        if (l == 0L) {
            return PIG_FEATURE.UNKNOWN.name();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < PIG_FEATURE.values().length; ++i) {
            if ((l >> i & 1L) == 0L) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(PIG_FEATURE.values()[i].name());
        }
        return sb.toString();
    }

    public void setPigContext(PigContext pigContext) {
        this.pigContext = pigContext;
    }

    public PigContext getPigContext() {
        return this.pigContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AliasVisitor
    extends PhyPlanVisitor {
        private HashSet<String> aliasSet;
        private List<String> alias;

        public AliasVisitor(PhysicalPlan plan, List<String> alias) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.alias = alias;
            this.aliasSet = new HashSet();
            if (!alias.isEmpty()) {
                for (String s : alias) {
                    this.aliasSet.add(s);
                }
            }
        }

        @Override
        public void visitLoad(POLoad load) throws VisitorException {
            this.setAlias(load);
        }

        @Override
        public void visitFRJoin(POFRJoin join) throws VisitorException {
            this.setAlias(join);
        }

        @Override
        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            this.setAlias(join);
        }

        @Override
        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            this.setAlias(mergeCoGrp);
        }

        @Override
        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            this.setAlias(mg);
        }

        @Override
        public void visitDistinct(PODistinct distinct) throws VisitorException {
            this.setAlias(distinct);
        }

        @Override
        public void visitStream(POStream stream) throws VisitorException {
            this.setAlias(stream);
        }

        @Override
        public void visitFilter(POFilter fl) throws VisitorException {
            this.setAlias(fl);
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lr) throws VisitorException {
            this.setAlias(lr);
        }

        @Override
        public void visitPOForEach(POForEach nfe) throws VisitorException {
            this.setAlias(nfe);
        }

        @Override
        public void visitUnion(POUnion un) throws VisitorException {
            this.setAlias(un);
        }

        @Override
        public void visitSort(POSort sort) throws VisitorException {
            this.setAlias(sort);
        }

        @Override
        public void visitLimit(POLimit lim) throws VisitorException {
            this.setAlias(lim);
        }

        @Override
        public void visitSkewedJoin(POSkewedJoin sk) throws VisitorException {
            this.setAlias(sk);
        }

        private void setAlias(PhysicalOperator op) {
            String s = op.getAlias();
            if (s != null && !this.aliasSet.contains(s)) {
                this.alias.add(s);
                this.aliasSet.add(s);
            }
        }
    }

    static class LogicalPlanFeatureVisitor
    extends LogicalRelationalNodesVisitor {
        private BitSet feature;

        protected LogicalPlanFeatureVisitor(LogicalPlan plan, BitSet feature) throws FrontendException {
            super(plan, new org.apache.pig.newplan.DepthFirstWalker(plan));
            this.feature = feature;
        }

        public void visit(LOCogroup op) {
            if (op.getGroupType() == LOCogroup.GROUPTYPE.COLLECTED) {
                this.feature.set(PIG_FEATURE.COLLECTED_GROUP.ordinal());
            } else if (op.getGroupType() == LOCogroup.GROUPTYPE.MERGE) {
                this.feature.set(PIG_FEATURE.MERGE_COGROUP.ordinal());
            } else if (op.getGroupType() == LOCogroup.GROUPTYPE.REGULAR) {
                if (op.getExpressionPlans().size() > 1) {
                    this.feature.set(PIG_FEATURE.COGROUP.ordinal());
                } else {
                    this.feature.set(PIG_FEATURE.GROUP_BY.ordinal());
                }
            }
        }

        public void visit(LOCross op) {
            this.feature.set(PIG_FEATURE.CROSS.ordinal());
        }

        public void visit(LODistinct op) {
            this.feature.set(PIG_FEATURE.DISTINCT.ordinal());
        }

        public void visit(LOFilter op) {
            this.feature.set(PIG_FEATURE.FILTER.ordinal());
        }

        public void visit(LOForEach op) {
        }

        public void visit(LOJoin op) {
            if (op.getJoinType() == LOJoin.JOINTYPE.HASH) {
                this.feature.set(PIG_FEATURE.HASH_JOIN.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.MERGE) {
                this.feature.set(PIG_FEATURE.MERGE_JION.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) {
                this.feature.set(PIG_FEATURE.MERGE_SPARSE_JION.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.REPLICATED) {
                this.feature.set(PIG_FEATURE.REPLICATED_JOIN.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.SKEWED) {
                this.feature.set(PIG_FEATURE.SKEWED_JOIN.ordinal());
            }
        }

        public void visit(LOLimit op) {
            this.feature.set(PIG_FEATURE.LIMIT.ordinal());
        }

        public void visit(LOSort op) {
            this.feature.set(PIG_FEATURE.ORDER_BY.ordinal());
        }

        public void visit(LOStream op) {
            this.feature.set(PIG_FEATURE.STREAMING.ordinal());
        }

        public void visit(LOSplit op) {
        }

        public void visit(LOUnion op) {
            this.feature.set(PIG_FEATURE.UNION.ordinal());
        }

        public void visit(LONative n) {
            this.feature.set(PIG_FEATURE.NATIVE.ordinal());
        }
    }

    private static class FeatureVisitor
    extends PhyPlanVisitor {
        private BitSet feature;

        public FeatureVisitor(PhysicalPlan plan, BitSet feature) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.feature = feature;
        }

        public void visitFRJoin(POFRJoin join) throws VisitorException {
            this.feature.set(PIG_FEATURE.REPLICATED_JOIN.ordinal());
        }

        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            if (join.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) {
                this.feature.set(PIG_FEATURE.MERGE_SPARSE_JION.ordinal());
            } else {
                this.feature.set(PIG_FEATURE.MERGE_JION.ordinal());
            }
        }

        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            this.feature.set(PIG_FEATURE.MERGE_COGROUP.ordinal());
        }

        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            this.feature.set(PIG_FEATURE.COLLECTED_GROUP.ordinal());
        }

        public void visitDistinct(PODistinct distinct) throws VisitorException {
            this.feature.set(PIG_FEATURE.DISTINCT.ordinal());
        }

        public void visitStream(POStream stream) throws VisitorException {
            this.feature.set(PIG_FEATURE.STREAMING.ordinal());
        }

        public void visitSplit(POSplit split) throws VisitorException {
            this.feature.set(PIG_FEATURE.MULTI_QUERY.ordinal());
        }

        public void visitDemux(PODemux demux) throws VisitorException {
            this.feature.set(PIG_FEATURE.MULTI_QUERY.ordinal());
        }

        public void visitPartialAgg(POPartialAgg partAgg) {
            this.feature.set(PIG_FEATURE.MAP_PARTIALAGG.ordinal());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PIG_FEATURE {
        UNKNOWN,
        MERGE_JION,
        MERGE_SPARSE_JION,
        REPLICATED_JOIN,
        SKEWED_JOIN,
        HASH_JOIN,
        COLLECTED_GROUP,
        MERGE_COGROUP,
        COGROUP,
        GROUP_BY,
        ORDER_BY,
        DISTINCT,
        STREAMING,
        SAMPLER,
        INDEXER,
        MULTI_QUERY,
        FILTER,
        MAP_ONLY,
        CROSS,
        LIMIT,
        UNION,
        COMBINER,
        NATIVE,
        MAP_PARTIALAGG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PIG_PROPERTY {
        SCRIPT_ID("pig.script.id"),
        SCRIPT("pig.script"),
        COMMAND_LINE("pig.command.line"),
        HADOOP_VERSION("pig.hadoop.version"),
        VERSION("pig.version"),
        INPUT_DIRS("pig.input.dirs"),
        MAP_OUTPUT_DIRS("pig.map.output.dirs"),
        REDUCE_OUTPUT_DIRS("pig.reduce.output.dirs"),
        JOB_PARENTS("pig.parent.jobid"),
        JOB_FEATURE("pig.job.feature"),
        SCRIPT_FEATURES("pig.script.features"),
        JOB_ALIAS("pig.alias");

        private String displayStr;

        private PIG_PROPERTY(String s) {
            this.displayStr = s;
        }

        public String toString() {
            return this.displayStr;
        }
    }
}

