/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.HashMap;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.server.FileRepository;
import mondrian.server.ImplicitRepository;
import mondrian.server.MondrianServerImpl;
import mondrian.server.Repository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.IdentityCatalogLocator;
import mondrian.util.LockBox;

public class MondrianServerRegistry {
    public static final MondrianServerRegistry INSTANCE = new MondrianServerRegistry();
    final LockBox lockBox = new LockBox();
    final MondrianServer staticServer = this.createWithRepository(null, null);
    private MondrianServer.MondrianVersion version = null;

    public MondrianServer serverForId(String instanceId) {
        if (instanceId != null) {
            LockBox.Entry entry = this.lockBox.get(instanceId);
            if (entry == null) {
                throw Util.newError("No server instance has id '" + instanceId + "'");
            }
            return (MondrianServer)entry.getValue();
        }
        return this.staticServer;
    }

    public synchronized MondrianServer.MondrianVersion getOrLoadVersion() {
        if (this.version == null) {
            String[] vendorTitleVersion = MondrianServerRegistry.loadVersionFile();
            String vendor = vendorTitleVersion[0];
            final String title = vendorTitleVersion[1];
            final String versionString = vendorTitleVersion[2];
            int dot1 = versionString.indexOf(46);
            final int majorVersion = dot1 < 0 ? 1 : Integer.valueOf(versionString.substring(0, dot1));
            int dot2 = versionString.indexOf(46, dot1 + 1);
            final int minorVersion = dot2 < 0 ? 0 : Integer.valueOf(versionString.substring(dot1 + 1, dot2));
            this.version = new MondrianServer.MondrianVersion(){

                public String getVersionString() {
                    return versionString;
                }

                public int getMajorVersion() {
                    return majorVersion;
                }

                public int getMinorVersion() {
                    return minorVersion;
                }

                public String getProductName() {
                    return title;
                }
            };
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] loadVersionFile() {
        Package pakkage = MondrianServerImpl.class.getPackage();
        String implementationVersion = pakkage.getImplementationVersion();
        String version = "Unknown Version";
        String title = "Unknown Database";
        String vendor = "Unknown Vendor";
        URL resource = Util.getClosestResource(MondrianServerImpl.class.getClassLoader(), "DefaultRules.xml");
        if (resource != null) {
            try {
                HashMap<String, String> map;
                block12: {
                    String path = resource.getPath();
                    String path2 = Util.replace(path, "DefaultRules.xml", "VERSION.txt");
                    URL resource2 = new URL(resource.getProtocol(), resource.getHost(), path2);
                    map = new HashMap<String, String>();
                    LineNumberReader r = new LineNumberReader(new InputStreamReader(resource2.openStream()));
                    try {
                        String line;
                        while ((line = r.readLine()) != null) {
                            int i = line.indexOf(": ");
                            if (i < 0) continue;
                            String key = line.substring(0, i);
                            String value = line.substring(i + ": ".length());
                            map.put(key, value);
                        }
                    }
                    finally {
                        r.close();
                    }
                    title = (String)map.get("Title");
                    version = (String)map.get("Version");
                    try {
                        Integer.parseInt(version);
                    }
                    catch (NumberFormatException e) {
                        String versionMajor = (String)map.get("VersionMajor");
                        String versionMinor = (String)map.get("VersionMinor");
                        if (versionMajor != null) {
                            version = versionMajor;
                        }
                        if (versionMinor == null) break block12;
                        version = version + "." + versionMinor;
                    }
                }
                vendor = (String)map.get("Vendor");
            }
            catch (IOException e) {
                Util.discard((Object)e);
            }
        }
        if (implementationVersion != null && !implementationVersion.endsWith("-SNAPSHOT")) {
            version = implementationVersion;
        }
        return new String[]{vendor, title, version};
    }

    public MondrianServer createWithRepository(RepositoryContentFinder contentFinder, CatalogLocator catalogLocator) {
        Repository repository;
        if (catalogLocator == null) {
            catalogLocator = new IdentityCatalogLocator();
        }
        if (contentFinder == null) {
            if (this.staticServer != null) {
                return this.staticServer;
            }
            repository = new ImplicitRepository();
        } else {
            repository = new FileRepository(contentFinder, catalogLocator);
        }
        return new MondrianServerImpl(this, repository, catalogLocator);
    }
}

