/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ByteRangeInputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.KerberosUgiAuthenticator;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.mortbay.util.ajax.JSON;

public class WebHdfsFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    public static final Log LOG = LogFactory.getLog(WebHdfsFileSystem.class);
    public static final String SCHEME = "webhdfs";
    public static final int VERSION = 1;
    public static final String PATH_PREFIX = "/webhdfs/v1";
    private static final KerberosUgiAuthenticator AUTH = new KerberosUgiAuthenticator();
    public static final Text TOKEN_KIND = new Text("WEBHDFS delegation");
    public static final WebHdfsDelegationTokenSelector DT_SELECTOR = new WebHdfsDelegationTokenSelector();
    private DelegationTokenRenewer dtRenewer = null;
    private final UserGroupInformation ugi;
    private InetSocketAddress nnAddr;
    private URI uri;
    private Token<?> delegationToken;
    private final AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
    private RetryPolicy retryPolicy = null;
    private Path workingDir;
    private static final String OFFSET_PARAM_PREFIX = "offset=";

    public WebHdfsFileSystem() {
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void addRenewAction(WebHdfsFileSystem webhdfs) {
        if (this.dtRenewer == null) {
            this.dtRenewer = DelegationTokenRenewer.getInstance();
        }
        this.dtRenewer.addRenewAction((FileSystem)webhdfs);
    }

    public static boolean isEnabled(Configuration conf, Log log) {
        boolean b = conf.getBoolean("dfs.webhdfs.enabled", false);
        log.info((Object)("dfs.webhdfs.enabled = " + b));
        return b;
    }

    public String getScheme() {
        return SCHEME;
    }

    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        try {
            this.uri = new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.nnAddr = NetUtils.createSocketAddr((String)uri.getAuthority(), (int)this.getDefaultPort());
        this.retryPolicy = NameNodeProxies.getDefaultRetryPolicy(conf);
        this.workingDir = this.getHomeDirectory();
        if (UserGroupInformation.isSecurityEnabled()) {
            this.initDelegationToken();
        }
    }

    protected void initDelegationToken() throws IOException {
        Token<DelegationTokenIdentifier> token = this.selectDelegationToken(this.ugi);
        boolean createdToken = false;
        if (token == null) {
            token = this.getDelegationToken(null);
            boolean bl = createdToken = token != null;
        }
        if (token != null) {
            this.setDelegationToken(token);
            if (createdToken) {
                this.addRenewAction(this);
                LOG.debug((Object)("Created new DT for " + token.getService()));
            } else {
                LOG.debug((Object)("Found existing DT for " + token.getService()));
            }
        }
    }

    protected Token<DelegationTokenIdentifier> selectDelegationToken(UserGroupInformation ugi) {
        return DT_SELECTOR.selectToken(this.getCanonicalUri(), ugi.getTokens(), this.getConf());
    }

    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    public URI getUri() {
        return this.uri;
    }

    public static String getHomeDirectoryString(UserGroupInformation ugi) {
        return "/user/" + ugi.getShortUserName();
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path(WebHdfsFileSystem.getHomeDirectoryString(this.ugi)));
    }

    public synchronized Path getWorkingDirectory() {
        return this.workingDir;
    }

    public synchronized void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    static Map<?, ?> jsonParse(HttpURLConnection c, boolean useErrorStream) throws IOException {
        MediaType parsed;
        InputStream in;
        if (c.getContentLength() == 0) {
            return null;
        }
        InputStream inputStream = in = useErrorStream ? c.getErrorStream() : c.getInputStream();
        if (in == null) {
            throw new IOException("The " + (useErrorStream ? "error" : "input") + " stream is null.");
        }
        String contentType = c.getContentType();
        if (contentType != null && !MediaType.APPLICATION_JSON_TYPE.isCompatible(parsed = MediaType.valueOf((String)contentType))) {
            throw new IOException("Content-Type \"" + contentType + "\" is incompatible with \"" + "application/json" + "\" (parsed=\"" + parsed + "\")");
        }
        return (Map)JSON.parse((Reader)new InputStreamReader(in));
    }

    private static Map<?, ?> validateResponse(HttpOpParam.Op op, HttpURLConnection conn, boolean unwrapException) throws IOException {
        int code = conn.getResponseCode();
        if (code != op.getExpectedHttpResponseCode()) {
            Map<?, ?> m;
            try {
                m = WebHdfsFileSystem.jsonParse(conn, true);
            }
            catch (Exception e) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage(), e);
            }
            if (m == null) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage());
            }
            if (m.get(RemoteException.class.getSimpleName()) == null) {
                return m;
            }
            RemoteException re = JsonUtil.toRemoteException(m);
            throw unwrapException ? WebHdfsFileSystem.toIOException((Exception)((Object)re)) : re;
        }
        return null;
    }

    private static IOException toIOException(Exception e) {
        if (!(e instanceof IOException)) {
            return new IOException(e);
        }
        IOException ioe = (IOException)e;
        if (!(ioe instanceof RemoteException)) {
            return ioe;
        }
        RemoteException re = (RemoteException)((Object)ioe);
        return re.unwrapRemoteException(new Class[]{AccessControlException.class, SecretManager.InvalidToken.class, AuthenticationException.class, AuthorizationException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, UnresolvedPathException.class, SafeModeException.class, DSQuotaExceededException.class, NSQuotaExceededException.class});
    }

    private URL getNamenodeURL(String path, String query) throws IOException {
        URL url = new URL("http", this.nnAddr.getHostName(), this.nnAddr.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addDt2Query(String query) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            WebHdfsFileSystem webHdfsFileSystem = this;
            synchronized (webHdfsFileSystem) {
                if (this.delegationToken != null) {
                    String encoded = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(encoded);
                }
            }
        }
        return query;
    }

    URL toUrl(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        String path = PATH_PREFIX + (fspath == null ? "/" : this.makeQualified(fspath).toUri().getPath());
        String query = op.toQueryString() + '&' + new UserParam(this.ugi) + Param.toSortedString("&", parameters);
        URL url = op == PutOpParam.Op.RENEWDELEGATIONTOKEN || op == GetOpParam.Op.GETDELEGATIONTOKEN ? this.getNamenodeURL(path, query) : this.getNamenodeURL(path, this.addDt2Query(query));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    private HttpURLConnection getHttpUrlConnection(URL url) throws IOException, AuthenticationException {
        HttpURLConnection conn = this.ugi.hasKerberosCredentials() ? new AuthenticatedURL((Authenticator)AUTH).openConnection(url, this.authToken) : (HttpURLConnection)url.openConnection();
        return conn;
    }

    private Map<?, ?> run(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        return new Runner(op, fspath, parameters).run().json;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask((Configuration)this.getConf()));
    }

    private HdfsFileStatus getHdfsFileStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        Map<?, ?> json = this.run(op, f, new Param[0]);
        HdfsFileStatus status = JsonUtil.toFileStatus(json, true);
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.makeQualified(this.getHdfsFileStatus(f), f);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(f.getSymlink()) : null, f.getFullPath(parent).makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        Map<?, ?> json = this.run(op, f, new PermissionParam(this.applyUMask(permission)));
        return (Boolean)json.get("boolean");
    }

    public void createSymlink(Path destination, Path f, boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATESYMLINK;
        this.run(op, f, new DestinationParam(this.makeQualified(destination).toUri().getPath()), new CreateParentParam(createParent));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        Map<?, ?> json = this.run(op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath()));
        return (Boolean)json.get("boolean");
    }

    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        this.run(op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath()), new RenameOptionSetParam(options));
    }

    public void setOwner(Path p, String owner, String group) throws IOException {
        if (owner == null && group == null) {
            throw new IOException("owner == null && group == null");
        }
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETOWNER;
        this.run(op, p, new OwnerParam(owner), new GroupParam(group));
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETPERMISSION;
        this.run(op, p, new PermissionParam(permission));
    }

    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        Map<?, ?> json = this.run(op, p, new ReplicationParam(replication));
        return (Boolean)json.get("boolean");
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETTIMES;
        this.run(op, p, new ModificationTimeParam(mtime), new AccessTimeParam(atime));
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("dfs.blocksize", 0x4000000L);
    }

    public short getDefaultReplication() {
        return (short)this.getConf().getInt("dfs.replication", 3);
    }

    FSDataOutputStream write(final HttpOpParam.Op op, final HttpURLConnection conn, int bufferSize) throws IOException {
        return new FSDataOutputStream(new BufferedOutputStream(conn.getOutputStream(), bufferSize), this.statistics){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    try {
                        WebHdfsFileSystem.validateResponse(op, conn, true);
                    }
                    finally {
                        conn.disconnect();
                    }
                }
            }
        };
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        return new Runner((HttpOpParam.Op)op, f, new PermissionParam(this.applyUMask(permission)), new OverwriteParam(overwrite), new BufferSizeParam(bufferSize), new ReplicationParam(replication), new BlockSizeParam(blockSize)).run().write(bufferSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.APPEND;
        return new Runner((HttpOpParam.Op)op, f, new BufferSizeParam(bufferSize)).run().write(bufferSize);
    }

    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETE;
        Map<?, ?> json = this.run(op, f, new RecursiveParam(recursive));
        return (Boolean)json.get("boolean");
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        URL url = this.toUrl(op, f, new BufferSizeParam(buffersize));
        return new FSDataInputStream((InputStream)((Object)new OffsetUrlInputStream(new OffsetUrlOpener(url), new OffsetUrlOpener(null))));
    }

    public void close() throws IOException {
        super.close();
        if (this.dtRenewer != null) {
            this.dtRenewer.removeRenewAction((FileSystem)this);
        }
    }

    static URL removeOffsetParam(URL url) throws MalformedURLException {
        String query = url.getQuery();
        if (query == null) {
            return url;
        }
        String lower = query.toLowerCase();
        if (!lower.startsWith(OFFSET_PARAM_PREFIX) && !lower.contains("&offset=")) {
            return url;
        }
        StringBuilder b = null;
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.toLowerCase().startsWith(OFFSET_PARAM_PREFIX)) continue;
            if (b == null) {
                b = new StringBuilder("?").append(token);
                continue;
            }
            b.append('&').append(token);
        }
        query = b == null ? "" : b.toString();
        String urlStr = url.toString();
        return new URL(urlStr.substring(0, urlStr.indexOf(63)) + query);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.LISTSTATUS;
        Map<?, ?> json = this.run(op, f, new Param[0]);
        Map rootmap = (Map)json.get(FileStatus.class.getSimpleName() + "es");
        Object[] array = (Object[])rootmap.get(FileStatus.class.getSimpleName());
        FileStatus[] statuses = new FileStatus[array.length];
        for (int i = 0; i < array.length; ++i) {
            Map m = (Map)array[i];
            statuses[i] = this.makeQualified(JsonUtil.toFileStatus(m, false), f);
        }
        return statuses;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
        Map<?, ?> m = this.run(op, null, new RenewerParam(renewer));
        Token<DelegationTokenIdentifier> token = JsonUtil.toDelegationToken(m);
        SecurityUtil.setTokenService(token, (InetSocketAddress)this.nnAddr);
        return token;
    }

    public Token<?> getRenewToken() {
        return this.delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        WebHdfsFileSystem webHdfsFileSystem = this;
        synchronized (webHdfsFileSystem) {
            this.delegationToken = token;
        }
    }

    private synchronized long renewDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.RENEWDELEGATIONTOKEN;
        TokenArgumentParam dtargParam = new TokenArgumentParam(token.encodeToUrlString());
        Map<?, ?> m = this.run(op, null, dtargParam);
        return (Long)m.get("long");
    }

    private synchronized void cancelDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.CANCELDELEGATIONTOKEN;
        TokenArgumentParam dtargParam = new TokenArgumentParam(token.encodeToUrlString());
        this.run(op, null, dtargParam);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        return this.getFileBlockLocations(status.getPath(), offset, length);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long offset, long length) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GET_BLOCK_LOCATIONS;
        Map<?, ?> m = this.run(op, p, new OffsetParam(offset), new LengthParam(length));
        return DFSUtil.locatedBlocks2Locations(JsonUtil.toLocatedBlocks(m));
    }

    public ContentSummary getContentSummary(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETCONTENTSUMMARY;
        Map<?, ?> m = this.run(op, p, new Param[0]);
        return JsonUtil.toContentSummary(m);
    }

    public MD5MD5CRC32FileChecksum getFileChecksum(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETFILECHECKSUM;
        Map<?, ?> m = this.run(op, p, new Param[0]);
        return JsonUtil.toMD5MD5CRC32FileChecksum(m);
    }

    private static class WebHdfsDelegationTokenSelector
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        private static final DelegationTokenSelector hdfsTokenSelector = new DelegationTokenSelector();

        public WebHdfsDelegationTokenSelector() {
            super(TOKEN_KIND);
        }

        Token<DelegationTokenIdentifier> selectToken(URI nnUri, Collection<Token<?>> tokens, Configuration conf) {
            Token<DelegationTokenIdentifier> token = this.selectToken(SecurityUtil.buildTokenService((URI)nnUri), tokens);
            if (token == null) {
                token = hdfsTokenSelector.selectToken(nnUri, tokens, conf);
            }
            return token;
        }
    }

    public static class DtRenewer
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return kind.equals((Object)TOKEN_KIND);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        private static WebHdfsFileSystem getWebHdfs(Token<?> token, Configuration conf) throws IOException {
            InetSocketAddress nnAddr = SecurityUtil.getTokenServiceAddr(token);
            URI uri = DFSUtil.createUri(WebHdfsFileSystem.SCHEME, nnAddr);
            return (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        }

        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.reloginFromKeytab();
            return DtRenewer.getWebHdfs(token, conf).renewDelegationToken(token);
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.checkTGTAndReloginFromKeytab();
            DtRenewer.getWebHdfs(token, conf).cancelDelegationToken(token);
        }
    }

    static class OffsetUrlInputStream
    extends ByteRangeInputStream {
        OffsetUrlInputStream(OffsetUrlOpener o, OffsetUrlOpener r) {
            super(o, r);
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) throws MalformedURLException {
            return WebHdfsFileSystem.removeOffsetParam(connection.getURL());
        }
    }

    class OffsetUrlOpener
    extends ByteRangeInputStream.URLOpener {
        OffsetUrlOpener(URL url) {
            super(url);
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            URL offsetUrl = offset == 0L ? this.url : new URL(this.url + "&" + new OffsetParam(offset));
            return new Runner((HttpOpParam.Op)GetOpParam.Op.OPEN, offsetUrl, resolved).run().conn;
        }
    }

    class Runner {
        private final HttpOpParam.Op op;
        private final URL url;
        private final boolean redirected;
        private boolean checkRetry;
        private HttpURLConnection conn = null;
        private Map<?, ?> json = null;

        Runner(HttpOpParam.Op op, URL url, boolean redirected) {
            this.op = op;
            this.url = url;
            this.redirected = redirected;
        }

        Runner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
            this(op, webHdfsFileSystem.toUrl(op, fspath, parameters), false);
        }

        Runner(HttpOpParam.Op op, HttpURLConnection conn) {
            this(op, null, false);
            this.conn = conn;
        }

        private void init() throws IOException {
            this.checkRetry = !this.redirected;
            try {
                this.conn = WebHdfsFileSystem.this.getHttpUrlConnection(this.url);
            }
            catch (AuthenticationException ae) {
                this.checkRetry = false;
                throw new IOException("Authentication failed, url=" + this.url, ae);
            }
        }

        private void connect() throws IOException {
            this.connect(this.op.getDoOutput());
        }

        private void connect(boolean doOutput) throws IOException {
            this.conn.setRequestMethod(this.op.getType().toString());
            this.conn.setDoOutput(doOutput);
            this.conn.setInstanceFollowRedirects(false);
            this.conn.connect();
        }

        private void disconnect() {
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }

        Runner run() throws IOException {
            int retry = 0;
            while (true) {
                try {
                    this.init();
                    if (this.op.getDoOutput()) {
                        this.twoStepWrite();
                    } else {
                        this.getResponse(this.op != GetOpParam.Op.OPEN);
                    }
                    return this;
                }
                catch (IOException ioe) {
                    this.shouldRetry(ioe, retry);
                    ++retry;
                    continue;
                }
                break;
            }
        }

        private void shouldRetry(IOException ioe, int retry) throws IOException {
            if (this.checkRetry) {
                try {
                    RetryPolicy.RetryAction a = WebHdfsFileSystem.this.retryPolicy.shouldRetry((Exception)ioe, retry, 0, true);
                    if (a.action == RetryPolicy.RetryAction.RetryDecision.RETRY) {
                        LOG.info((Object)("Retrying connect to namenode: " + WebHdfsFileSystem.this.nnAddr + ". Already tried " + retry + " time(s); retry policy is " + WebHdfsFileSystem.this.retryPolicy + ", delay " + a.delayMillis + "ms."));
                        Thread.sleep(a.delayMillis);
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Original exception is ", (Throwable)ioe);
                    throw WebHdfsFileSystem.toIOException(e);
                }
            }
            throw WebHdfsFileSystem.toIOException(ioe);
        }

        HttpURLConnection twoStepWrite() throws IOException {
            this.connect(false);
            WebHdfsFileSystem.validateResponse(HttpOpParam.TemporaryRedirectOp.valueOf(this.op), this.conn, false);
            String redirect = this.conn.getHeaderField("Location");
            this.disconnect();
            this.checkRetry = false;
            this.conn = (HttpURLConnection)new URL(redirect).openConnection();
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
            this.conn.setChunkedStreamingMode(32768);
            this.connect();
            return this.conn;
        }

        FSDataOutputStream write(int bufferSize) throws IOException {
            return WebHdfsFileSystem.this.write(this.op, this.conn, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getResponse(boolean getJsonAndDisconnect) throws IOException {
            try {
                this.connect();
                int code = this.conn.getResponseCode();
                if (!this.redirected && this.op.getRedirect() && code != this.op.getExpectedHttpResponseCode()) {
                    String redirect = this.conn.getHeaderField("Location");
                    this.json = WebHdfsFileSystem.validateResponse(HttpOpParam.TemporaryRedirectOp.valueOf(this.op), this.conn, false);
                    this.disconnect();
                    this.checkRetry = false;
                    this.conn = (HttpURLConnection)new URL(redirect).openConnection();
                    this.connect();
                }
                this.json = WebHdfsFileSystem.validateResponse(this.op, this.conn, false);
                if (this.json == null && getJsonAndDisconnect) {
                    this.json = WebHdfsFileSystem.jsonParse(this.conn, false);
                }
            }
            finally {
                if (getJsonAndDisconnect) {
                    this.disconnect();
                }
            }
        }
    }
}

