/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class KettleTransFromFileProducer
extends AbstractKettleTransformationProducer {
    private static final long serialVersionUID = -7222333765312572612L;
    private static Log logger = LogFactory.getLog(KettleTransFromFileProducer.class);
    private String transformationFile;

    public KettleTransFromFileProducer(String repositoryName, String transformationFile, String stepName, String username, String password, String[] definedArgumentNames, ParameterMapping[] definedVariableNames) {
        super(repositoryName, stepName, username, password, definedArgumentNames, definedVariableNames);
        this.transformationFile = transformationFile;
    }

    public KettleTransFromFileProducer(String transformationFile, String stepName, String[] definedArgumentNames, ParameterMapping[] definedVariableNames) {
        this("", transformationFile, stepName, null, null, definedArgumentNames, definedVariableNames);
    }

    @Override
    public String getTransformationFile() {
        return this.transformationFile;
    }

    private ResourceKey createKey(ResourceManager resourceManager, ResourceKey contextKey) throws ResourceKeyCreationException {
        try {
            return resourceManager.deriveKey(contextKey, this.transformationFile);
        }
        catch (ResourceKeyCreationException resourceKeyCreationException) {
            return resourceManager.createKey((Object)new File(this.transformationFile));
        }
    }

    protected String computeFullFilename(ResourceKey key) {
        while (key != null) {
            Object identifier = key.getIdentifier();
            if (identifier instanceof File) {
                File file = (File)identifier;
                return file.getAbsolutePath();
            }
            key = key.getParent();
        }
        return null;
    }

    @Override
    protected TransMeta loadTransformation(Repository repository, ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException, KettleException {
        if (this.transformationFile == null) {
            throw new ReportDataFactoryException("No Transformation file given");
        }
        if (resourceManager == null || contextKey == null) {
            return new TransMeta(this.transformationFile, repository);
        }
        try {
            ResourceKey resourceKey = this.createKey(resourceManager, contextKey);
            Resource resource = resourceManager.create(resourceKey, contextKey, Document.class);
            Document document = (Document)resource.getResource();
            Node node = XMLHandler.getSubNode((Node)document, (String)"transformation");
            TransMeta meta = new TransMeta();
            meta.loadXML(node, repository, true, null, null);
            String filename = this.computeFullFilename(resourceKey);
            if (filename != null) {
                logger.debug((Object)("Computed Transformation Location: " + filename));
                meta.setFilename(filename);
            } else {
                logger.debug((Object)("No Computed Transformation Location, using raw name: " + this.transformationFile));
                meta.setFilename(this.transformationFile);
            }
            return meta;
        }
        catch (ResourceException re) {
            throw new ReportDataFactoryException("Unable to load Kettle-Transformation", (Throwable)re);
        }
    }

    @Override
    public Object getQueryHash(ResourceManager resourceManager, ResourceKey resourceKey) {
        ArrayList<Object> retval = this.internalGetQueryHash();
        String fullName = this.computeFullFilename(resourceKey);
        if (fullName != null) {
            retval.add(fullName);
        } else {
            retval.add(resourceKey);
        }
        retval.add(this.transformationFile);
        return retval;
    }
}

