/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.parser.ArgumentReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.parser.KettleTransformationProducerReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.parser.VariableReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractKettleTransformationProducerReadHandler
extends AbstractXmlReadHandler
implements KettleTransformationProducerReadHandler {
    private String name;
    private String stepName;
    private String username;
    private String password;
    private String repositoryName;
    private String[] definedArgumentNames;
    private ParameterMapping[] definedVariableNames;
    private ArrayList<ArgumentReadHandler> argumentHandlers = new ArrayList();
    private ArrayList<VariableReadHandler> variablesHandlers = new ArrayList();

    @Override
    public String getName() {
        return this.name;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Required attribute 'name' is not defined");
        }
        this.repositoryName = attrs.getValue(this.getUri(), "repository");
        if (this.repositoryName == null) {
            throw new ParseException("Required attribute 'repository' is not defined");
        }
        this.username = attrs.getValue(this.getUri(), "username");
        this.password = PasswordEncryptionService.getInstance().decrypt(this.getRootHandler(), attrs.getValue(this.getUri(), "password"));
        this.stepName = attrs.getValue(this.getUri(), "step");
        if (this.stepName == null) {
            throw new ParseException("Required attribute 'step' is not defined");
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("argument".equals(tagName)) {
            ArgumentReadHandler readHandler = new ArgumentReadHandler();
            this.argumentHandlers.add(readHandler);
            return readHandler;
        }
        if ("variable".equals(tagName)) {
            VariableReadHandler readHandler = new VariableReadHandler();
            this.variablesHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        int i;
        this.definedArgumentNames = new String[this.argumentHandlers.size()];
        for (i = 0; i < this.definedArgumentNames.length; ++i) {
            ArgumentReadHandler o = this.argumentHandlers.get(i);
            this.definedArgumentNames[i] = o.getDataRowName();
        }
        this.definedVariableNames = new ParameterMapping[this.variablesHandlers.size()];
        for (i = 0; i < this.definedVariableNames.length; ++i) {
            VariableReadHandler readHandler = this.variablesHandlers.get(i);
            this.definedVariableNames[i] = (ParameterMapping)readHandler.getObject();
        }
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String[] getDefinedArgumentNames() {
        return this.definedArgumentNames;
    }

    @Override
    public ParameterMapping[] getDefinedVariableNames() {
        return this.definedVariableNames;
    }

    @Override
    public KettleTransformationProducer getTransformationProducer() throws SAXException {
        return this.getObject();
    }

    public abstract KettleTransformationProducer getObject() throws SAXException;
}

