/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.util.StringUtils;

public class HiveHistory {
    PrintWriter histStream;
    String histFileName;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.HiveHistory");
    private SessionState.LogHelper console;
    private Map<String, String> idToTableMap = null;
    private final HashMap<String, QueryInfo> queryInfoMap = new HashMap();
    private final HashMap<String, TaskInfo> taskInfoMap = new HashMap();
    private static final String DELIMITER = " ";
    private static final String KEY = "(\\w+)";
    private static final String VALUE = "[[^\"]?]+";
    private static final String ROW_COUNT_PATTERN = "TABLE_ID_(\\d+)_ROWCOUNT";
    private static final Pattern pattern = Pattern.compile("(\\w+)=\"[[^\"]?]+\"");
    private static final Pattern rowCountPattern = Pattern.compile("TABLE_ID_(\\d+)_ROWCOUNT");
    private static Map<String, String> parseBuffer = new HashMap<String, String>();
    static Map<String, String> ctrmap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseHiveHistory(String path, Listener l) throws IOException {
        FileInputStream fi = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fi));
        try {
            String line = null;
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                if (!line.trim().endsWith("\"")) continue;
                HiveHistory.parseLine(buf.toString(), l);
                buf = new StringBuilder();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void parseLine(String line, Listener l) throws IOException {
        int idx = line.indexOf(32);
        String recType = line.substring(0, idx);
        String data = line.substring(idx + 1, line.length());
        Matcher matcher = pattern.matcher(data);
        while (matcher.find()) {
            String tuple = matcher.group(0);
            String[] parts = tuple.split("=");
            parseBuffer.put(parts[0], parts[1].substring(1, parts[1].length() - 1));
        }
        l.handle(RecordTypes.valueOf(recType), parseBuffer);
        parseBuffer.clear();
    }

    public HiveHistory(SessionState ss) {
        try {
            this.console = new SessionState.LogHelper(LOG);
            String conf_file_loc = ss.getConf().getVar(HiveConf.ConfVars.HIVEHISTORYFILELOC);
            if (conf_file_loc == null || conf_file_loc.length() == 0) {
                this.console.printError("No history file location given");
                return;
            }
            File f = new File(conf_file_loc);
            if (!f.exists() && !f.mkdir()) {
                this.console.printError("Unable to create log directory " + conf_file_loc);
                return;
            }
            Random randGen = new Random();
            do {
                this.histFileName = conf_file_loc + "/hive_job_log_" + ss.getSessionId() + "_" + Math.abs(randGen.nextInt()) + ".txt";
            } while (new File(this.histFileName).exists());
            this.console.printInfo("Hive history file=" + this.histFileName);
            this.histStream = new PrintWriter(this.histFileName);
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put(Keys.SESSION_ID.name(), ss.getSessionId());
            this.log(RecordTypes.SessionStart, hm);
        }
        catch (FileNotFoundException e) {
            this.console.printError("FAILED: Failed to open Query Log : " + this.histFileName + DELIMITER + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    public String getHistFileName() {
        return this.histFileName;
    }

    void log(RecordTypes rt, Map<String, String> keyValMap) {
        if (this.histStream == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rt.name());
        for (Map.Entry<String, String> ent : keyValMap.entrySet()) {
            sb.append(DELIMITER);
            String key = ent.getKey();
            String val = ent.getValue();
            if (val != null) {
                val = val.replace('\n', ' ');
            }
            sb.append(key + "=\"" + val + "\"");
        }
        sb.append(DELIMITER);
        sb.append(Keys.TIME.name() + "=\"" + System.currentTimeMillis() + "\"");
        this.histStream.println(sb);
        this.histStream.flush();
    }

    public void startQuery(String cmd, String id) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return;
        }
        QueryInfo ji = new QueryInfo();
        ji.hm.put(Keys.QUERY_ID.name(), id);
        ji.hm.put(Keys.QUERY_STRING.name(), cmd);
        this.queryInfoMap.put(id, ji);
        this.log(RecordTypes.QueryStart, ji.hm);
    }

    public void setQueryProperty(String queryId, Keys propName, String propValue) {
        QueryInfo ji = this.queryInfoMap.get(queryId);
        if (ji == null) {
            return;
        }
        ji.hm.put(propName.name(), propValue);
    }

    public void setTaskProperty(String queryId, String taskId, Keys propName, String propValue) {
        String id = queryId + ":" + taskId;
        TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null) {
            return;
        }
        ti.hm.put(propName.name(), propValue);
    }

    public void setTaskCounters(String queryId, String taskId, Counters ctrs) {
        String id = queryId + ":" + taskId;
        QueryInfo ji = this.queryInfoMap.get(queryId);
        StringBuilder sb1 = new StringBuilder("");
        TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null || ctrs == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("");
        try {
            boolean first = true;
            for (Counters.Group group : ctrs) {
                for (Counters.Counter counter : group) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(group.getDisplayName());
                    sb.append('.');
                    sb.append(counter.getDisplayName());
                    sb.append(':');
                    sb.append(counter.getCounter());
                    String tab = this.getRowCountTableName(counter.getDisplayName());
                    if (tab == null) continue;
                    if (sb1.length() > 0) {
                        sb1.append(",");
                    }
                    sb1.append(tab);
                    sb1.append('~');
                    sb1.append(counter.getCounter());
                    ji.rowCountMap.put(tab, counter.getCounter());
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
        }
        if (sb1.length() > 0) {
            this.taskInfoMap.get((Object)id).hm.put(Keys.ROWS_INSERTED.name(), sb1.toString());
            this.queryInfoMap.get((Object)queryId).hm.put(Keys.ROWS_INSERTED.name(), sb1.toString());
        }
        if (sb.length() > 0) {
            this.taskInfoMap.get((Object)id).hm.put(Keys.TASK_COUNTERS.name(), sb.toString());
        }
    }

    public void printRowCount(String queryId) {
        QueryInfo ji = this.queryInfoMap.get(queryId);
        for (String tab : ji.rowCountMap.keySet()) {
            this.console.printInfo(ji.rowCountMap.get(tab) + " Rows loaded to " + tab);
        }
    }

    public void endQuery(String queryId) {
        QueryInfo ji = this.queryInfoMap.get(queryId);
        if (ji == null) {
            return;
        }
        this.log(RecordTypes.QueryEnd, ji.hm);
    }

    public void startTask(String queryId, Task<? extends Serializable> task, String taskName) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return;
        }
        TaskInfo ti = new TaskInfo();
        ti.hm.put(Keys.QUERY_ID.name(), ss.getQueryId());
        ti.hm.put(Keys.TASK_ID.name(), task.getId());
        ti.hm.put(Keys.TASK_NAME.name(), taskName);
        String id = queryId + ":" + task.getId();
        this.taskInfoMap.put(id, ti);
        this.log(RecordTypes.TaskStart, ti.hm);
    }

    public void endTask(String queryId, Task<? extends Serializable> task) {
        String id = queryId + ":" + task.getId();
        TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null) {
            return;
        }
        this.log(RecordTypes.TaskEnd, ti.hm);
    }

    public void progressTask(String queryId, Task<? extends Serializable> task) {
        String id = queryId + ":" + task.getId();
        TaskInfo ti = this.taskInfoMap.get(id);
        if (ti == null) {
            return;
        }
        this.log(RecordTypes.TaskProgress, ti.hm);
    }

    public void logPlanProgress(QueryPlan plan) throws IOException {
        if (ctrmap == null) {
            ctrmap = new HashMap<String, String>();
        }
        ctrmap.put("plan", plan.toString());
        this.log(RecordTypes.Counters, ctrmap);
    }

    public void setIdToTableMap(Map<String, String> map) {
        this.idToTableMap = map;
    }

    String getRowCountTableName(String name) {
        if (this.idToTableMap == null) {
            return null;
        }
        Matcher m = rowCountPattern.matcher(name);
        if (m.find()) {
            String tuple = m.group(1);
            return this.idToTableMap.get(tuple);
        }
        return null;
    }

    public void finalize() throws Throwable {
        if (this.histStream != null) {
            this.histStream.close();
        }
        super.finalize();
    }

    public static class TaskInfo
    extends Info {
        public Map<String, String> hm = new HashMap<String, String>();
    }

    public static class QueryInfo
    extends Info {
        public Map<String, String> hm = new HashMap<String, String>();
        public Map<String, Long> rowCountMap = new HashMap<String, Long>();
    }

    public static class SessionInfo
    extends Info {
        public String sessionId;
    }

    public static class Info {
    }

    public static interface Listener {
        public void handle(RecordTypes var1, Map<String, String> var2) throws IOException;
    }

    public static enum Keys {
        SESSION_ID,
        QUERY_ID,
        TASK_ID,
        QUERY_RET_CODE,
        QUERY_NUM_TASKS,
        QUERY_STRING,
        TIME,
        TASK_RET_CODE,
        TASK_NAME,
        TASK_HADOOP_ID,
        TASK_HADOOP_PROGRESS,
        TASK_COUNTERS,
        TASK_NUM_REDUCERS,
        ROWS_INSERTED;

    }

    public static enum RecordTypes {
        QueryStart,
        QueryEnd,
        TaskStart,
        TaskEnd,
        TaskProgress,
        SessionStart,
        SessionEnd,
        Counters;

    }
}

