/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;

public class JDBCStatsAggregator
implements StatsAggregator {
    private Connection conn;
    private String connectionString;
    private Configuration hiveconf;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private int timeout = 30;

    @Override
    public boolean connect(Configuration hiveconf) {
        try {
            this.hiveconf = hiveconf;
            this.timeout = HiveConf.getIntVar(hiveconf, HiveConf.ConfVars.HIVE_STATS_JDBC_TIMEOUT);
            this.connectionString = HiveConf.getVar(hiveconf, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING);
            String driver = HiveConf.getVar(hiveconf, HiveConf.ConfVars.HIVESTATSJDBCDRIVER);
            Class.forName(driver).newInstance();
            DriverManager.setLoginTimeout(this.timeout);
            this.conn = DriverManager.getConnection(this.connectionString);
            return true;
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error during JDBC connection. " + e));
            return false;
        }
    }

    @Override
    public String aggregateStats(String fileID, String statType) {
        this.LOG.info((Object)("Stats Aggregator for key " + fileID));
        if (statType != "numRows") {
            this.LOG.warn((Object)"Warning. Invalid statistic. Currently row count is the only supported statistic");
            return null;
        }
        try {
            long retval = 0L;
            Statement stmt = this.conn.createStatement();
            stmt.setQueryTimeout(this.timeout);
            String select = "SELECT SUM(ROW_COUNT) FROM PARTITION_STAT_TBL WHERE ID LIKE '" + fileID + "%'";
            ResultSet result = stmt.executeQuery(select);
            if (!result.next()) {
                this.LOG.warn((Object)"Warning. Nothing published. Nothing aggregated.");
                return "";
            }
            retval = result.getLong(1);
            stmt.clearBatch();
            String delete = "DELETE FROM PARTITION_STAT_TBL WHERE ID LIKE '" + fileID + "%'";
            stmt.executeUpdate(delete);
            stmt.close();
            this.LOG.info((Object)("Stats aggregator got " + retval));
            return Long.toString(retval);
        }
        catch (SQLException e) {
            this.LOG.error((Object)("Error during publishing aggregation. " + e));
            return null;
        }
    }

    @Override
    public boolean closeConnection() {
        if (this.conn == null) {
            return true;
        }
        try {
            this.conn.close();
            if (HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase("jdbc:derby")) {
                try {
                    DriverManager.getConnection(this.connectionString + ";shutdown=true");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            this.LOG.error((Object)("Error during JDBC termination. " + e));
            return false;
        }
    }

    @Override
    public boolean cleanUp(String rowID) {
        try {
            Statement stmt = this.conn.createStatement();
            String delete = "DELETE FROM PARTITION_STAT_TBL WHERE ID LIKE '" + rowID + "%'";
            stmt.executeUpdate(delete);
            stmt.close();
            return this.closeConnection();
        }
        catch (SQLException e) {
            this.LOG.error((Object)("Error during publishing aggregation. " + e));
            return false;
        }
    }
}

