/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.File;
import java.util.ArrayList;
import mondrian.spi.CatalogLocator;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.SchemaResolver;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultCubeFileProvider
implements CubeFileProvider {
    private String mondrianCubeFile;
    private String cubeConnectionName;

    public DefaultCubeFileProvider() {
    }

    public DefaultCubeFileProvider(String mondrianCubeFile) {
        this(mondrianCubeFile, null);
    }

    public DefaultCubeFileProvider(String mondrianCubeFile, String cubeConnectionName) {
        this.mondrianCubeFile = mondrianCubeFile;
        this.cubeConnectionName = cubeConnectionName;
    }

    @Override
    public String getDesignTimeFile() {
        return this.getMondrianCubeFile();
    }

    @Override
    public void setDesignTimeFile(String name) {
        this.setMondrianCubeFile(name);
    }

    public String getMondrianCubeFile() {
        return this.mondrianCubeFile;
    }

    public void setMondrianCubeFile(String mondrianCubeFile) {
        this.mondrianCubeFile = mondrianCubeFile;
    }

    @Override
    public String getCubeFile(ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException {
        String mappedCatalog;
        if (this.mondrianCubeFile == null) {
            throw new ReportDataFactoryException("No schema file defined.");
        }
        CatalogLocator locator = (CatalogLocator)ClassicEngineBoot.getInstance().getObjectFactory().get(CatalogLocator.class);
        if (locator != null && !StringUtils.isEmpty((String)(mappedCatalog = locator.locate(this.mondrianCubeFile)))) {
            return mappedCatalog;
        }
        File cubeAsFile = new File(this.mondrianCubeFile);
        if (cubeAsFile.isFile()) {
            return this.mondrianCubeFile;
        }
        try {
            return SchemaResolver.resolveSchema(resourceManager, contextKey, this.mondrianCubeFile);
        }
        catch (FileSystemException e) {
            return this.mondrianCubeFile;
        }
    }

    @Override
    public String getCubeConnectionName() {
        return this.cubeConnectionName;
    }

    @Override
    public void setCubeConnectionName(String cubeConnectionName) {
        this.cubeConnectionName = cubeConnectionName;
    }

    @Override
    public Object getConnectionHash() {
        ArrayList<String> hash = new ArrayList<String>();
        hash.add(this.getClass().getName());
        hash.add(this.getMondrianCubeFile());
        hash.add(this.getCubeConnectionName());
        return hash;
    }
}

