/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.LoggingErrorHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParserEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MondrianUtil {
    private static final Log logger = LogFactory.getLog(MondrianUtil.class);

    private MondrianUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseSchemaName(ResourceManager resourceManager, ResourceKey contextKey, String designTimeFile) {
        String string;
        CubeFileProvider cubeFileProvider = (CubeFileProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(CubeFileProvider.class);
        cubeFileProvider.setDesignTimeFile(designTimeFile);
        InputStream inputStream = Util.readVirtualFile((String)cubeFileProvider.getCubeFile(resourceManager, contextKey));
        try {
            string = MondrianUtil.parseXmlDocument(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to parse mondrian schema file at " + designTimeFile), (Throwable)e);
                return null;
            }
        }
        inputStream.close();
        return string;
    }

    private static String parseXmlDocument(InputStream stream) throws ResourceCreationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((EntityResolver)ParserEntityResolver.getDefaultResolver());
            db.setErrorHandler((ErrorHandler)new LoggingErrorHandler());
            InputSource input = new InputSource(stream);
            Document document = db.parse(input);
            Element documentElement = document.getDocumentElement();
            if ("Schema".equals(documentElement.getTagName())) {
                return documentElement.getAttribute("name");
            }
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new ResourceCreationException("Unable to parse the document.", (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceCreationException("Unable to parse the document.", (Exception)e);
        }
    }

    public static String getUniqueMemberName(Member member) {
        String memberValue = Util.quoteMdxIdentifier((String)member.getName());
        while (member.getParentMember() != null) {
            memberValue = Util.quoteMdxIdentifier((String)member.getParentMember().getName()) + "." + memberValue;
            member = member.getParentMember();
        }
        Hierarchy hierarchy = member.getHierarchy();
        Dimension dimension = hierarchy.getDimension();
        if (hierarchy.getName().equals(dimension.getName())) {
            return Util.quoteMdxIdentifier((String)hierarchy.getName()) + "." + memberValue;
        }
        return Util.quoteMdxIdentifier((String)dimension.getName()) + "." + Util.quoteMdxIdentifier((String)hierarchy.getName()) + "." + memberValue;
    }
}

