/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.compat;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.compat.AbstractCompatibilityConverter;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianUtil;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class MondrianDataSource_50_CompatibilityConverter
extends AbstractCompatibilityConverter {
    public int getTargetVersion() {
        return ClassicEngineBoot.computeVersionId((int)5, (int)0, (int)0);
    }

    public void inspectDataSource(AbstractReportDefinition report, DataFactory dataFactory) {
        if (!(dataFactory instanceof AbstractMDXDataFactory)) {
            return;
        }
        AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)dataFactory;
        CubeFileProvider cubeFileProvider = mdxDataFactory.getCubeFileProvider();
        if (!StringUtils.isEmpty((String)cubeFileProvider.getCubeConnectionName())) {
            return;
        }
        ResourceManager mgr = report.getResourceManager();
        ResourceKey reportContentBase = report.getContentBase();
        String cubeName = this.calculateCubeNameFromProvider(mgr, reportContentBase, cubeFileProvider);
        cubeFileProvider.setCubeConnectionName(cubeName);
    }

    private String calculateCubeNameFromProvider(ResourceManager mgr, ResourceKey reportContentBase, CubeFileProvider defaultCubeFileProvider) {
        String designTimeFile = defaultCubeFileProvider.getDesignTimeFile();
        if (StringUtils.isEmpty((String)designTimeFile)) {
            return null;
        }
        return MondrianUtil.parseSchemaName(mgr, reportContentBase, designTimeFile);
    }
}

