/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.ObjectFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.DefaultResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;
import org.pentaho.reporting.libraries.resourceloader.cache.BundleCacheResourceWrapper;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.NullResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHCacheModule;

public final class ResourceManager {
    private static final Log logger = LogFactory.getLog(ResourceManager.class);
    private ResourceManagerBackend backend;
    public static final String BUNDLE_LOADER_PREFIX = "org.pentaho.reporting.libraries.resourceloader.bundle.loader.";
    public static final String LOADER_PREFIX = "org.pentaho.reporting.libraries.resourceloader.loader.";
    public static final String FACTORY_TYPE_PREFIX = "org.pentaho.reporting.libraries.resourceloader.factory.type.";
    private ResourceDataCache dataCache;
    private ResourceBundleDataCache bundleCache;
    private ResourceFactoryCache factoryCache;
    private static final Set<Class> failedModules = new HashSet<Class>();

    public ResourceManager() {
        this(new DefaultResourceManagerBackend());
    }

    public ResourceManager(ResourceManagerBackend resourceManagerBackend) {
        if (resourceManagerBackend == null) {
            throw new NullPointerException();
        }
        this.backend = resourceManagerBackend;
        this.bundleCache = new NullResourceBundleDataCache();
        this.dataCache = new NullResourceDataCache();
        this.factoryCache = new NullResourceFactoryCache();
        this.registerDefaults();
    }

    public ResourceManager(ResourceManager parent, ResourceManagerBackend backend) {
        if (backend == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.backend = backend;
        this.bundleCache = parent.getBundleCache();
        this.dataCache = parent.getDataCache();
        this.factoryCache = parent.getFactoryCache();
        this.registerDefaults();
    }

    public ResourceManagerBackend getBackend() {
        return this.backend;
    }

    public ResourceKey createKey(Object data) throws ResourceKeyCreationException {
        return this.createKey(data, null);
    }

    public ResourceKey createKey(Object data, Map<? extends ParameterKey, ? extends Object> parameters) throws ResourceKeyCreationException {
        return this.backend.createKey(data, parameters);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path) throws ResourceKeyCreationException {
        return this.deriveKey(parent, path, null);
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map<? extends ParameterKey, ? extends Object> parameters) throws ResourceKeyCreationException {
        return this.backend.deriveKey(parent, path, parameters);
    }

    public URL toURL(ResourceKey key) {
        return this.backend.toURL(key);
    }

    public Resource createDirectly(Object keyValue, Class target) throws ResourceLoadingException, ResourceCreationException, ResourceKeyCreationException {
        ResourceKey key = this.createKey(keyValue);
        return this.create(key, null, target);
    }

    public synchronized ResourceBundleData loadResourceBundle(ResourceKey key) throws ResourceLoadingException {
        ResourceBundleData data;
        ResourceBundleDataCache bundleCache = this.getBundleCache();
        ResourceBundleDataCacheEntry cached = bundleCache.get(key);
        if (cached != null) {
            data = cached.getData();
            long version = data.getVersion(this);
            if (cached.getStoredVersion() < 0L || version >= 0L && cached.getStoredVersion() == version) {
                ResourceKey bundleKey = data.getBundleKey();
                int counter = 1;
                while (bundleKey != null) {
                    ResourceData bundleRawData;
                    ResourceDataCacheEntry bundleRawDataCacheEntry = this.getDataCache().get(bundleKey);
                    if (bundleRawDataCacheEntry != null && (bundleRawData = bundleRawDataCacheEntry.getData()) != null) {
                        if (this.isValidData(bundleRawDataCacheEntry, bundleRawData)) {
                            logger.debug((Object)("Returning cached entry [" + counter + "]"));
                            return data;
                        }
                        this.getDataCache().remove(bundleRawData);
                    }
                    bundleKey = bundleKey.getParent();
                    ++counter;
                }
            }
            bundleCache.remove(data);
        }
        if ((data = this.backend.loadResourceBundle(this, key)) != null && this.isResourceDataCacheable(data)) {
            bundleCache.put(this, data);
        }
        return data;
    }

    private boolean isResourceDataCacheable(ResourceData data) {
        try {
            return data.getVersion(this) != -1L;
        }
        catch (ResourceLoadingException e) {
            return false;
        }
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        ResourceBundleData parentData;
        ResourceBundleData bundle = this.loadResourceBundle(key);
        if (bundle != null) {
            logger.debug((Object)("Loaded bundle for key " + key));
            return bundle;
        }
        ResourceKey parent = key.getParent();
        if (parent != null && (parentData = this.loadResourceBundle(parent)) != null) {
            logger.debug((Object)("Loaded bundle for key (derivate) " + key));
            return parentData.deriveData(key);
        }
        return this.loadRawData(key);
    }

    private boolean isValidData(ResourceDataCacheEntry cached, ResourceData data) throws ResourceLoadingException {
        if (cached.getStoredVersion() < 0L) {
            return true;
        }
        long version = data.getVersion(this);
        if (version < 0L) {
            return false;
        }
        return cached.getStoredVersion() == version;
    }

    public synchronized ResourceData loadRawData(ResourceKey key) throws UnrecognizedLoaderException, ResourceLoadingException {
        ResourceData data;
        ResourceDataCache dataCache = this.getDataCache();
        ResourceDataCacheEntry cached = dataCache.get(key);
        if (cached != null && (data = cached.getData()) != null) {
            if (this.isValidData(cached, data)) {
                return data;
            }
            dataCache.remove(data);
        }
        if ((data = this.backend.loadRawData(this, key)) != null && this.isResourceDataCacheable(data)) {
            dataCache.put(this, data);
        }
        return data;
    }

    public Resource create(ResourceKey key, ResourceKey context, Class target) throws ResourceLoadingException, ResourceCreationException {
        if (target == null) {
            throw new NullPointerException("Target must not be null");
        }
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        return this.create(key, context, new Class[]{target});
    }

    public Resource create(ResourceKey key, ResourceKey context) throws ResourceLoadingException, ResourceCreationException {
        return this.create(key, context, (Class[])null);
    }

    public Resource create(ResourceKey key, ResourceKey context, Class[] target) throws ResourceLoadingException, ResourceCreationException {
        Resource newResource;
        ResourceData loadedData;
        if (key == null) {
            throw new NullPointerException();
        }
        ResourceFactoryCache factoryCache = this.getFactoryCache();
        Resource resource = factoryCache.get(key, target);
        if (resource != null) {
            if (this.backend.isResourceUnchanged(this, resource)) {
                return resource;
            }
            factoryCache.remove(resource);
        }
        if ((loadedData = this.load(key)) instanceof ResourceBundleData) {
            ResourceBundleData resourceBundleData = (ResourceBundleData)loadedData;
            ResourceManager derivedManager = resourceBundleData.deriveManager(this);
            newResource = this.backend.create(derivedManager, resourceBundleData, context, target);
            if (this.isResourceCacheable(newResource)) {
                if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                    EHCacheModule.CACHE_MONITOR.debug((Object)("Storing created bundle-resource for key: " + key));
                }
                factoryCache.put(newResource);
                if (key != newResource.getSource()) {
                    factoryCache.put(new BundleCacheResourceWrapper(newResource, key));
                }
            } else if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                EHCacheModule.CACHE_MONITOR.debug((Object)("Created bundle-resource is not cacheable for " + key));
            }
        } else {
            newResource = this.backend.create(this, loadedData, context, target);
            if (this.isResourceCacheable(newResource)) {
                if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                    EHCacheModule.CACHE_MONITOR.debug((Object)("Storing created resource for key: " + key));
                }
                factoryCache.put(newResource);
            } else if (EHCacheModule.CACHE_MONITOR.isDebugEnabled()) {
                EHCacheModule.CACHE_MONITOR.debug((Object)("Created resource is not cacheable for " + key));
            }
        }
        return newResource;
    }

    private boolean isResourceCacheable(Resource newResource) {
        ResourceKey source = newResource.getSource();
        if (newResource.isTemporaryResult()) {
            return false;
        }
        if (newResource.getVersion(source) == -1L) {
            return false;
        }
        ResourceKey[] keys = newResource.getDependencies();
        for (int i = 0; i < keys.length; ++i) {
            if (newResource.getVersion(keys[i]) != -1L) continue;
            return false;
        }
        return true;
    }

    public ResourceDataCache getDataCache() {
        return this.dataCache;
    }

    public void setDataCache(ResourceDataCache dataCache) {
        if (dataCache == null) {
            throw new NullPointerException();
        }
        this.dataCache = dataCache;
    }

    public ResourceFactoryCache getFactoryCache() {
        return this.factoryCache;
    }

    public void setFactoryCache(ResourceFactoryCache factoryCache) {
        if (factoryCache == null) {
            throw new NullPointerException();
        }
        this.factoryCache = factoryCache;
    }

    public ResourceBundleDataCache getBundleCache() {
        return this.bundleCache;
    }

    public void setBundleCache(ResourceBundleDataCache bundleCache) {
        if (bundleCache == null) {
            throw new NullPointerException();
        }
        this.bundleCache = bundleCache;
    }

    public void registerDefaults() {
        this.registerDefaultLoaders();
        this.registerDefaultFactories();
        this.registerDataCache();
        this.registerBundleDataCache();
        this.registerFactoryCache();
    }

    public void registerDefaultFactories() {
        this.backend.registerDefaultFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleDataCache() {
        try {
            ObjectFactory objectFactory = LibLoaderBoot.getInstance().getObjectFactory();
            ResourceBundleDataCacheProvider maybeDataCacheProvider = (ResourceBundleDataCacheProvider)objectFactory.get(ResourceBundleDataCacheProvider.class);
            if (maybeDataCacheProvider == null) {
                return;
            }
            ResourceBundleDataCache cache = maybeDataCacheProvider.createBundleDataCache();
            if (cache != null) {
                this.setBundleCache(cache);
            }
        }
        catch (Throwable e) {
            Set<Class> set = failedModules;
            synchronized (set) {
                if (!failedModules.contains(ResourceBundleDataCacheProvider.class)) {
                    logger.warn((Object)("Failed to create data cache: " + e.getLocalizedMessage()));
                    failedModules.add(ResourceBundleDataCacheProvider.class);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataCache() {
        try {
            ObjectFactory objectFactory = LibLoaderBoot.getInstance().getObjectFactory();
            ResourceDataCacheProvider maybeDataCacheProvider = (ResourceDataCacheProvider)objectFactory.get(ResourceDataCacheProvider.class);
            if (maybeDataCacheProvider == null) {
                return;
            }
            ResourceDataCache cache = maybeDataCacheProvider.createDataCache();
            if (cache != null) {
                this.setDataCache(cache);
            }
        }
        catch (Throwable e) {
            Set<Class> set = failedModules;
            synchronized (set) {
                if (!failedModules.contains(ResourceDataCacheProvider.class)) {
                    logger.warn((Object)("Failed to create data cache: " + e.getLocalizedMessage()));
                    failedModules.add(ResourceDataCacheProvider.class);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactoryCache() {
        try {
            ObjectFactory objectFactory = LibLoaderBoot.getInstance().getObjectFactory();
            ResourceFactoryCacheProvider maybeDataCacheProvider = (ResourceFactoryCacheProvider)objectFactory.get(ResourceFactoryCacheProvider.class);
            if (maybeDataCacheProvider == null) {
                return;
            }
            ResourceFactoryCache cache = maybeDataCacheProvider.createFactoryCache();
            if (cache != null) {
                this.setFactoryCache(cache);
            }
        }
        catch (Throwable e) {
            Set<Class> set = failedModules;
            synchronized (set) {
                if (!failedModules.contains(ResourceFactoryCacheProvider.class)) {
                    logger.warn((Object)("Failed to create factory cache: " + e.getLocalizedMessage()));
                    failedModules.add(ResourceFactoryCacheProvider.class);
                }
            }
        }
    }

    public void registerDefaultLoaders() {
        this.backend.registerDefaultLoaders();
    }

    public void registerBundleLoader(ResourceBundleLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this.backend.registerBundleLoader(loader);
    }

    public void registerLoader(ResourceLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this.backend.registerLoader(loader);
    }

    public void registerFactory(ResourceFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.backend.registerFactory(factory);
    }

    public void shutDown() {
        this.factoryCache.shutdown();
        this.dataCache.shutdown();
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        return this.backend.serialize(bundleKey, key);
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String serializedKey) throws ResourceKeyCreationException {
        return this.backend.deserialize(bundleKey, serializedKey);
    }

    public ResourceKey createOrDeriveKey(ResourceKey context, Object value, Object baseURL) throws ResourceKeyCreationException {
        ResourceKey key;
        if (value == null) {
            throw new ResourceKeyCreationException("Empty key is invalid");
        }
        if (value instanceof ResourceKey) {
            key = (ResourceKey)value;
        } else {
            if (value instanceof Blob) {
                try {
                    Blob b = (Blob)value;
                    byte[] data = IOUtils.getInstance().readBlob(b);
                    key = this.createKey(data);
                }
                catch (IOException ioe) {
                    throw new ResourceKeyCreationException("Failed to load data from blob", ioe);
                }
                catch (SQLException e) {
                    throw new ResourceKeyCreationException("Failed to load data from blob", e);
                }
            }
            if (value instanceof String) {
                String source = (String)value;
                if (StringUtils.isEmpty((String)source)) {
                    throw new ResourceKeyCreationException("Empty key is invalid");
                }
                try {
                    if (baseURL instanceof String) {
                        ResourceKey baseKey = this.createKeyFromString(null, (String)baseURL);
                        return this.createKeyFromString(baseKey, source);
                    }
                    if (baseURL instanceof ResourceKey) {
                        ResourceKey baseKey = (ResourceKey)baseURL;
                        return this.createKeyFromString(baseKey, source);
                    }
                    if (baseURL != null) {
                        ResourceKey baseKey = this.createKey(baseURL);
                        return this.createKeyFromString(baseKey, source);
                    }
                }
                catch (ResourceException rke) {
                    logger.debug((Object)"Failed to resolve key via given base-url. Try to treat resource as absolute resource instead", (Throwable)rke);
                }
                key = this.createKeyFromString(context, source);
            } else {
                key = this.createKey(value);
            }
        }
        return key;
    }

    private ResourceKey createKeyFromString(ResourceKey contextKey, String file) throws ResourceKeyCreationException {
        try {
            if (contextKey != null) {
                return this.deriveKey(contextKey, file);
            }
        }
        catch (ResourceException re) {
            logger.debug((Object)"Failed to load datasource as derived path: ", (Throwable)re);
        }
        try {
            return this.createKey(new URL(file));
        }
        catch (ResourceException re) {
            logger.debug((Object)"Failed to load datasource as URL: ", (Throwable)re);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            return this.createKey(new File(file));
        }
        catch (ResourceException re) {
            logger.debug((Object)"Failed to load datasource as file: ", (Throwable)re);
            return this.createKey(file);
        }
    }
}

