/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hive.jdbc;

import java.lang.reflect.Method;

public class HadoopConfigurationUtil {
    private static final String HADOOP_CONFIGURATION_BOOTSTRAP = "HadoopConfigurationBootstrap";
    private static final String CLASS_PLUGIN_REGISTRY = "org.pentaho.di.core.plugins.PluginRegistry";
    private static final String CLASS_PLUGIN_INTERFACE = "org.pentaho.di.core.plugins.PluginInterface";
    private static final String CLASS_KETTLE_LIFECYCLE_PLUGIN_TYPE = "org.pentaho.di.core.plugins.KettleLifecyclePluginType";
    private static final String CLASS_HADOOP_CONFIGURATION_BOOTSTRAP = "org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap";
    private static final String CLASS_HADOOP_CONFIGURATION = "org.pentaho.hadoop.shim.HadoopConfiguration";
    private static final String METHOD_GET_INSTANCE = "getInstance";
    private static final String METHOD_FIND_PLUGIN_WITH_ID = "findPluginWithId";
    private static final String METHOD_GET_CLASS_LOADER = "getClassLoader";
    private static final String METHOD_GET_HADOOP_CONFIGURATION_PROVIDER = "getHadoopConfigurationProvider";
    private static final String METHOD_GET_ACTIVE_CONFIGURATION = "getActiveConfiguration";
    private static final String METHOD_GET_HADOOP_SHIM = "getHadoopShim";
    private Object provider;
    private Method getActiveConfiguration;
    private Method getHadoopShim;

    ClassLoader findBigDataPluginClassLoader() throws Exception {
        Method findPluginById = null;
        Object pluginRegistry = null;
        Method getClassLoader = null;
        try {
            Class<?> pluginRegistryClass = Class.forName(CLASS_PLUGIN_REGISTRY);
            Class<?> pluginInterfaceClass = Class.forName(CLASS_PLUGIN_INTERFACE);
            Method getInstance = pluginRegistryClass.getMethod(METHOD_GET_INSTANCE, new Class[0]);
            getClassLoader = pluginRegistryClass.getMethod(METHOD_GET_CLASS_LOADER, pluginInterfaceClass);
            findPluginById = pluginRegistryClass.getMethod(METHOD_FIND_PLUGIN_WITH_ID, Class.class, String.class);
            pluginRegistry = getInstance.invoke(pluginRegistryClass, new Object[0]);
        }
        catch (Exception ex) {
            throw new Exception("Unable to locate Kettle Plugin registry", ex);
        }
        try {
            Class<?> kettleLifecyclePluginTypeClass = Class.forName(CLASS_KETTLE_LIFECYCLE_PLUGIN_TYPE);
            Object hadoopConfigurationBootstrap = findPluginById.invoke(pluginRegistry, kettleLifecyclePluginTypeClass, HADOOP_CONFIGURATION_BOOTSTRAP);
            return (ClassLoader)getClassLoader.invoke(pluginRegistry, hadoopConfigurationBootstrap);
        }
        catch (Exception ex) {
            throw new Exception("Unable to locate Big Data Plugin", ex);
        }
    }

    private Object findHadoopConfigurationProvider() throws Exception {
        try {
            ClassLoader bigDataPluginCL = this.findBigDataPluginClassLoader();
            Class<?> registryClass = Class.forName(CLASS_HADOOP_CONFIGURATION_BOOTSTRAP, true, bigDataPluginCL);
            Method getHadoopConfigurationProvider = registryClass.getMethod(METHOD_GET_HADOOP_CONFIGURATION_PROVIDER, new Class[0]);
            Object provider = getHadoopConfigurationProvider.invoke(null, new Object[0]);
            this.getActiveConfiguration = provider.getClass().getMethod(METHOD_GET_ACTIVE_CONFIGURATION, new Class[0]);
            this.getHadoopShim = Class.forName(CLASS_HADOOP_CONFIGURATION, true, bigDataPluginCL).getMethod(METHOD_GET_HADOOP_SHIM, new Class[0]);
            return provider;
        }
        catch (Exception ex) {
            throw new Exception("Unable to locate Hadoop Configuration Registry", ex);
        }
    }

    private synchronized Object getProvider() throws Exception {
        if (this.provider == null) {
            this.provider = this.findHadoopConfigurationProvider();
        }
        return this.provider;
    }

    public Object getActiveConfiguration() throws Exception {
        Object provider = this.getProvider();
        return this.getActiveConfiguration.invoke(provider, new Object[0]);
    }

    public Object getActiveHadoopShim() throws Exception {
        Object activeConfig = this.getActiveConfiguration();
        return this.getHadoopShim.invoke(activeConfig, new Object[0]);
    }
}

