/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;

public final class HConstants {
    public static final Long ZERO_L = 0L;
    public static final String NINES = "99999999999999";
    public static final String ZEROES = "00000000000000";
    public static final String VERSION_FILE_NAME = "hbase.version";
    public static final String FILE_SYSTEM_VERSION = "7";
    public static final String CLUSTER_DISTRIBUTED = "hbase.cluster.distributed";
    public static final String HBASE_MASTER_LOADBALANCER_CLASS = "hbase.master.loadbalancer.class";
    public static final boolean CLUSTER_IS_LOCAL = false;
    public static final boolean CLUSTER_IS_DISTRIBUTED = true;
    public static final boolean DEFAULT_CLUSTER_DISTRIBUTED = false;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final String MASTER_PORT = "hbase.master.port";
    public static final int DEFAULT_MASTER_PORT = 60000;
    public static final int DEFAULT_MASTER_INFOPORT = 60010;
    public static final String MASTER_TYPE_BACKUP = "hbase.master.backup";
    public static final boolean DEFAULT_MASTER_TYPE_BACKUP = false;
    public static final String ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
    public static final String ZOOKEEPER_CONFIG_NAME = "zoo.cfg";
    public static final String ZK_CFG_PROPERTY_PREFIX = "hbase.zookeeper.property.";
    public static final int ZK_CFG_PROPERTY_PREFIX_LEN = "hbase.zookeeper.property.".length();
    public static final String CLIENT_PORT_STR = "clientPort";
    public static final String ZOOKEEPER_CLIENT_PORT = "hbase.zookeeper.property.clientPort";
    public static final int DEFAULT_ZOOKEPER_CLIENT_PORT = 2181;
    public static final String ZOOKEEPER_RECOVERABLE_WAITTIME = "hbase.zookeeper.recoverable.waittime";
    public static final long DEFAULT_ZOOKEPER_RECOVERABLE_WAITIME = 10000L;
    public static final String ZOOKEEPER_ZNODE_PARENT = "zookeeper.znode.parent";
    public static final String DEFAULT_ZOOKEEPER_ZNODE_PARENT = "/hbase";
    public static final String ZOOKEEPER_MAX_CLIENT_CNXNS = "hbase.zookeeper.property.maxClientCnxns";
    public static final String ZOOKEEPER_DATA_DIR = "hbase.zookeeper.property.dataDir";
    public static final int DEFAULT_ZOOKEPER_MAX_CLIENT_CNXNS = 300;
    public static final String ZK_SESSION_TIMEOUT = "zookeeper.session.timeout";
    public static final int DEFAULT_ZK_SESSION_TIMEOUT = 180000;
    public static final String ZOOKEEPER_USEMULTI = "hbase.zookeeper.useMulti";
    public static final String REGIONSERVER_PORT = "hbase.regionserver.port";
    public static final int DEFAULT_REGIONSERVER_PORT = 60020;
    public static final int DEFAULT_REGIONSERVER_INFOPORT = 60030;
    public static final String REGIONSERVER_INFO_PORT_AUTO = "hbase.regionserver.info.port.auto";
    public static final String REGION_SERVER_CLASS = "hbase.regionserver.class";
    public static final String REGION_SERVER_IMPL = "hbase.regionserver.impl";
    public static final String DEFAULT_REGION_SERVER_CLASS = HRegionInterface.class.getName();
    public static final String MASTER_IMPL = "hbase.master.impl";
    public static final String THREAD_WAKE_FREQUENCY = "hbase.server.thread.wakefrequency";
    public static final int DEFAULT_THREAD_WAKE_FREQUENCY = 10000;
    public static final String VERSION_FILE_WRITE_ATTEMPTS = "hbase.server.versionfile.writeattempts";
    public static final int DEFAULT_VERSION_FILE_WRITE_ATTEMPTS = 3;
    public static final String MAJOR_COMPACTION_PERIOD = "hbase.hregion.majorcompaction";
    public static final String COMPACTION_KV_MAX = "hbase.hstore.compaction.kv.max";
    public static final String HBASE_DIR = "hbase.rootdir";
    public static final String HBASE_CLIENT_IPC_POOL_TYPE = "hbase.client.ipc.pool.type";
    public static final String HBASE_CLIENT_IPC_POOL_SIZE = "hbase.client.ipc.pool.size";
    public static final String HBASE_CLIENT_OPERATION_TIMEOUT = "hbase.client.operation.timeout";
    public static final int DEFAULT_HBASE_CLIENT_OPERATION_TIMEOUT = Integer.MAX_VALUE;
    public static final String HREGION_LOGDIR_NAME = ".logs";
    public static final String SPLIT_LOGDIR_NAME = "splitlog";
    public static final String CORRUPT_DIR_NAME = ".corrupt";
    public static final String HREGION_OLDLOGDIR_NAME = ".oldlogs";
    public static final String HBCK_SIDELINEDIR_NAME = ".hbck";
    public static final String HREGION_COMPACTIONDIR_NAME = "compaction.dir";
    public static final String HREGION_MAX_FILESIZE = "hbase.hregion.max.filesize";
    public static final long DEFAULT_MAX_FILE_SIZE = 0x280000000L;
    public static final String HSTORE_OPEN_AND_CLOSE_THREADS_MAX = "hbase.hstore.open.and.close.threads.max";
    public static final int DEFAULT_HSTORE_OPEN_AND_CLOSE_THREADS_MAX = 1;
    public static final String HBASE_HREGION_OPEN_AND_INIT_THREADS_MAX = "hbase.hregion.open.and.init.threads.max";
    public static final int DEFAULT_HBASE_HREGION_OPEN_AND_INIT_THREADS_MAX = 10;
    public static final String HREGION_MEMSTORE_FLUSH_SIZE = "hbase.hregion.memstore.flush.size";
    public static final int DEFAULT_SIZE_RESERVATION_BLOCK = 0x500000;
    public static final int MAXIMUM_VALUE_LENGTH = Integer.MAX_VALUE;
    public static final String CLUSTER_ID_FILE_NAME = "hbase.id";
    public static final String CLUSTER_ID = "hbase.cluster.id";
    public static final byte[] ROOT_TABLE_NAME = Bytes.toBytes("-ROOT-");
    public static final byte[] META_TABLE_NAME = Bytes.toBytes(".META.");
    public static final int META_ROW_DELIMITER = 44;
    public static final String CATALOG_FAMILY_STR = "info";
    public static final byte[] CATALOG_FAMILY = Bytes.toBytes("info");
    public static final byte[] REGIONINFO_QUALIFIER = Bytes.toBytes("regioninfo");
    public static final byte[] SERVER_QUALIFIER = Bytes.toBytes("server");
    public static final byte[] STARTCODE_QUALIFIER = Bytes.toBytes("serverstartcode");
    public static final byte[] SPLITA_QUALIFIER = Bytes.toBytes("splitA");
    public static final byte[] SPLITB_QUALIFIER = Bytes.toBytes("splitB");
    public static final byte[] META_VERSION_QUALIFIER = Bytes.toBytes("v");
    public static final short META_VERSION = 0;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final byte[] EMPTY_START_ROW = EMPTY_BYTE_ARRAY;
    public static final byte[] EMPTY_END_ROW = EMPTY_START_ROW;
    public static final byte[] LAST_ROW = EMPTY_BYTE_ARRAY;
    public static final int MAX_ROW_LENGTH = Short.MAX_VALUE;
    public static final String UTF8_ENCODING = "UTF-8";
    public static final long LATEST_TIMESTAMP = Long.MAX_VALUE;
    public static final long OLDEST_TIMESTAMP = Long.MIN_VALUE;
    public static final byte[] LATEST_TIMESTAMP_BYTES = Bytes.toBytes(Long.MAX_VALUE);
    public static final int ALL_VERSIONS = Integer.MAX_VALUE;
    public static final int FOREVER = Integer.MAX_VALUE;
    public static final int WEEK_IN_SECONDS = 604800;
    public static final String NAME = "NAME";
    public static final String VERSIONS = "VERSIONS";
    public static final String IN_MEMORY = "IN_MEMORY";
    public static int[] RETRY_BACKOFF = new int[]{1, 1, 1, 2, 2, 4, 4, 8, 16, 32};
    public static final String REGION_IMPL = "hbase.hregion.impl";
    public static final int REPLICATION_SCOPE_LOCAL = 0;
    public static final int REPLICATION_SCOPE_GLOBAL = 1;
    public static final UUID DEFAULT_CLUSTER_ID = new UUID(0L, 0L);
    public static String HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY = "hbase.client.scanner.max.result.size";
    public static long DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE = Long.MAX_VALUE;
    public static String HBASE_CLIENT_PAUSE = "hbase.client.pause";
    public static long DEFAULT_HBASE_CLIENT_PAUSE = 1000L;
    public static String HBASE_CLIENT_RETRIES_NUMBER = "hbase.client.retries.number";
    public static int DEFAULT_HBASE_CLIENT_RETRIES_NUMBER = 10;
    public static String HBASE_CLIENT_RPC_MAXATTEMPTS = "hbase.client.rpc.maxattempts";
    public static int DEFAULT_HBASE_CLIENT_RPC_MAXATTEMPTS = 1;
    public static String HBASE_CLIENT_PREFETCH_LIMIT = "hbase.client.prefetch.limit";
    public static int DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT = 10;
    public static String HBASE_META_SCANNER_CACHING = "hbase.meta.scanner.caching";
    public static int DEFAULT_HBASE_META_SCANNER_CACHING = 100;
    public static String HBASE_CLIENT_INSTANCE_ID = "hbase.client.instance.id";
    public static String HBASE_REGIONSERVER_LEASE_PERIOD_KEY = "hbase.regionserver.lease.period";
    public static long DEFAULT_HBASE_REGIONSERVER_LEASE_PERIOD = 60000L;
    public static String HBASE_RPC_TIMEOUT_KEY = "hbase.rpc.timeout";
    public static int DEFAULT_HBASE_RPC_TIMEOUT = 60000;
    public static final String REPLICATION_ENABLE_KEY = "hbase.replication";
    public static final String REPLICATION_SOURCE_SERVICE_CLASSNAME = "hbase.replication.source.service";
    public static final String REPLICATION_SINK_SERVICE_CLASSNAME = "hbase.replication.sink.service";
    public static final String REPLICATION_SERVICE_CLASSNAME_DEFAULT = "org.apache.hadoop.hbase.replication.regionserver.Replication";
    public static final String HBCK_CODE_NAME = "HBCKServerName";
    public static final ServerName HBCK_CODE_SERVERNAME = new ServerName("HBCKServerName", -1, -1L);
    public static final String KEY_FOR_HOSTNAME_SEEN_BY_MASTER = "hbase.regionserver.hostname.seen.by.master";
    public static final String HBASE_MASTER_LOGCLEANER_PLUGINS = "hbase.master.logcleaner.plugins";
    public static final String HBASE_REGION_SPLIT_POLICY_KEY = "hbase.regionserver.region.split.policy";
    public static final String HFILE_BLOCK_CACHE_SIZE_KEY = "hfile.block.cache.size";
    public static final float HFILE_BLOCK_CACHE_SIZE_DEFAULT = 0.25f;
    public static final float HBASE_CLUSTER_MINIMUM_MEMORY_THRESHOLD = 0.2f;
    public static final Pattern CP_HTD_ATTR_KEY_PATTERN = Pattern.compile("^coprocessor\\$([0-9]+)$", 2);
    public static final Pattern CP_HTD_ATTR_VALUE_PATTERN = Pattern.compile("(^[^\\|]*)\\|([^\\|]+)\\|[\\s]*([\\d]*)[\\s]*(\\|.*)?$");
    public static final String CP_HTD_ATTR_VALUE_PARAM_KEY_PATTERN = "[^=,]+";
    public static final String CP_HTD_ATTR_VALUE_PARAM_VALUE_PATTERN = "[^,]+";
    public static final Pattern CP_HTD_ATTR_VALUE_PARAM_PATTERN = Pattern.compile("([^=,]+)=([^,]+),?");
    public static final int SOCKET_RETRY_WAIT_MS = 200;
    public static final String LOCALHOST = "localhost";
    public static final String ENABLE_DATA_FILE_UMASK = "hbase.data.umask.enable";
    public static final String DATA_FILE_UMASK_KEY = "hbase.data.umask";
    public static final String HBASE_CHECKSUM_VERIFICATION = "hbase.regionserver.checksum.verify";
    public static final String BYTES_PER_CHECKSUM = "hbase.hstore.bytes.per.checksum";
    public static final String CHECKSUM_TYPE_NAME = "hbase.hstore.checksum.algorithm";
    public static final String ENABLE_WAL_COMPRESSION = "hbase.regionserver.wal.enablecompression";
    public static final byte[] NO_NEXT_INDEXED_KEY = Bytes.toBytes("NO_NEXT_INDEXED_KEY");
    public static final int NORMAL_QOS = 0;
    public static final int QOS_THRESHOLD = 10;
    public static final int HIGH_QOS = 100;
    public static final int REPLICATION_QOS = 5;
    public static final String HFILE_ARCHIVE_DIRECTORY = ".archive";
    public static final String SNAPSHOT_DIR_NAME = ".snapshot";
    public static final String HBASE_TEMP_DIRECTORY = ".tmp";
    public static final List<String> HBASE_NON_TABLE_DIRS = Collections.unmodifiableList(Arrays.asList(".logs", ".oldlogs", ".corrupt", "splitlog", ".hbck", ".archive", ".snapshot", ".tmp"));
    public static final List<String> HBASE_NON_USER_TABLE_DIRS = Collections.unmodifiableList(Arrays.asList((String[])ArrayUtils.addAll((Object[])new String[]{Bytes.toString(META_TABLE_NAME), Bytes.toString(ROOT_TABLE_NAME)}, (Object[])HBASE_NON_TABLE_DIRS.toArray())));

    private HConstants() {
    }

    public static enum Modify {
        CLOSE_REGION,
        TABLE_COMPACT,
        TABLE_FLUSH,
        TABLE_MAJOR_COMPACT,
        TABLE_SET_HTD,
        TABLE_SPLIT;

    }

    public static enum OperationStatusCode {
        NOT_RUN,
        SUCCESS,
        BAD_FAMILY,
        SANITY_CHECK_FAILURE,
        FAILURE;

    }
}

