/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class HServerLoad
extends VersionedWritable
implements WritableComparable<HServerLoad> {
    private static final byte VERSION = 2;
    public static final HServerLoad EMPTY_HSERVERLOAD = new HServerLoad();
    private int numberOfRequests = 0;
    private int totalNumberOfRequests = 0;
    private int usedHeapMB = 0;
    private int maxHeapMB = 0;
    private Set<String> coprocessors = new TreeSet<String>();
    private Map<byte[], RegionLoad> regionLoad = new TreeMap<byte[], RegionLoad>(Bytes.BYTES_COMPARATOR);

    public String[] getCoprocessors() {
        TreeSet<String> returnValue = new TreeSet<String>(this.coprocessors);
        for (Map.Entry<byte[], RegionLoad> rls : this.getRegionsLoad().entrySet()) {
            for (String coprocessor : rls.getValue().getCoprocessors()) {
                returnValue.add(coprocessor);
            }
        }
        return returnValue.toArray(new String[0]);
    }

    public byte getVersion() {
        return 2;
    }

    public HServerLoad() {
    }

    public HServerLoad(int totalNumberOfRequests, int numberOfRequests, int usedHeapMB, int maxHeapMB, Map<byte[], RegionLoad> regionLoad, Set<String> coprocessors) {
        this.numberOfRequests = numberOfRequests;
        this.usedHeapMB = usedHeapMB;
        this.maxHeapMB = maxHeapMB;
        this.regionLoad = regionLoad;
        this.totalNumberOfRequests = totalNumberOfRequests;
        this.coprocessors = coprocessors;
    }

    public HServerLoad(HServerLoad hsl) {
        this(hsl.totalNumberOfRequests, hsl.numberOfRequests, hsl.usedHeapMB, hsl.maxHeapMB, hsl.getRegionsLoad(), hsl.coprocessors);
        for (Map.Entry<byte[], RegionLoad> e : hsl.regionLoad.entrySet()) {
            this.regionLoad.put(e.getKey(), e.getValue());
        }
    }

    public int getLoad() {
        return this.regionLoad.size();
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int msgInterval) {
        int numberOfRegions = this.regionLoad.size();
        StringBuilder sb = new StringBuilder();
        sb = Strings.appendKeyValue(sb, "requestsPerSecond", this.numberOfRequests / msgInterval);
        sb = Strings.appendKeyValue(sb, "numberOfOnlineRegions", numberOfRegions);
        sb = Strings.appendKeyValue(sb, "usedHeapMB", this.usedHeapMB);
        sb = Strings.appendKeyValue(sb, "maxHeapMB", this.maxHeapMB);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((HServerLoad)((Object)o)) == 0;
    }

    public int getNumberOfRegions() {
        return this.regionLoad.size();
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public int getTotalNumberOfRequests() {
        return this.totalNumberOfRequests;
    }

    public int getUsedHeapMB() {
        return this.usedHeapMB;
    }

    public int getMaxHeapMB() {
        return this.maxHeapMB;
    }

    public Map<byte[], RegionLoad> getRegionsLoad() {
        return Collections.unmodifiableMap(this.regionLoad);
    }

    public int getStorefiles() {
        int count = 0;
        for (RegionLoad info : this.regionLoad.values()) {
            count += info.getStorefiles();
        }
        return count;
    }

    public int getStorefileSizeInMB() {
        int count = 0;
        for (RegionLoad info : this.regionLoad.values()) {
            count += info.getStorefileSizeMB();
        }
        return count;
    }

    public int getMemStoreSizeInMB() {
        int count = 0;
        for (RegionLoad info : this.regionLoad.values()) {
            count += info.getMemStoreSizeMB();
        }
        return count;
    }

    public int getStorefileIndexSizeInMB() {
        int count = 0;
        for (RegionLoad info : this.regionLoad.values()) {
            count += info.getStorefileIndexSizeMB();
        }
        return count;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte version = in.readByte();
        if (version > 2) {
            throw new IOException("Version mismatch; " + version);
        }
        this.numberOfRequests = in.readInt();
        this.usedHeapMB = in.readInt();
        this.maxHeapMB = in.readInt();
        int numberOfRegions = in.readInt();
        for (int i = 0; i < numberOfRegions; ++i) {
            RegionLoad rl = new RegionLoad();
            rl.readFields(in);
            this.regionLoad.put(rl.getName(), rl);
        }
        this.totalNumberOfRequests = in.readInt();
        int coprocessorsSize = in.readInt();
        for (int i = 0; i < coprocessorsSize; ++i) {
            this.coprocessors.add(in.readUTF());
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeByte(2);
        out.writeInt(this.numberOfRequests);
        out.writeInt(this.usedHeapMB);
        out.writeInt(this.maxHeapMB);
        out.writeInt(this.regionLoad.size());
        for (RegionLoad rl : this.regionLoad.values()) {
            rl.write(out);
        }
        out.writeInt(this.totalNumberOfRequests);
        out.writeInt(this.coprocessors.size());
        for (String coprocessor : this.coprocessors) {
            out.writeUTF(coprocessor);
        }
    }

    public int compareTo(HServerLoad o) {
        return this.getLoad() - o.getLoad();
    }

    public static class RegionLoad
    extends VersionedWritable {
        private static final byte VERSION = 2;
        private byte[] name;
        private int stores;
        private int storefiles;
        private int storeUncompressedSizeMB;
        private int storefileSizeMB;
        private int memstoreSizeMB;
        private int storefileIndexSizeMB;
        private long readRequestsCount;
        private long writeRequestsCount;
        private long totalCompactingKVs;
        private long currentCompactedKVs;
        private int rootIndexSizeKB;
        private int totalStaticIndexSizeKB;
        private int totalStaticBloomSizeKB;
        Set<String> coprocessors = new TreeSet<String>();

        public byte getVersion() {
            return 2;
        }

        public RegionLoad() {
        }

        public RegionLoad(byte[] name, int stores, int storefiles, int storeUncompressedSizeMB, int storefileSizeMB, int memstoreSizeMB, int storefileIndexSizeMB, int rootIndexSizeKB, int totalStaticIndexSizeKB, int totalStaticBloomSizeKB, long readRequestsCount, long writeRequestsCount, long totalCompactingKVs, long currentCompactedKVs, Set<String> coprocessors) {
            this.name = name;
            this.stores = stores;
            this.storefiles = storefiles;
            this.storeUncompressedSizeMB = storeUncompressedSizeMB;
            this.storefileSizeMB = storefileSizeMB;
            this.memstoreSizeMB = memstoreSizeMB;
            this.storefileIndexSizeMB = storefileIndexSizeMB;
            this.rootIndexSizeKB = rootIndexSizeKB;
            this.totalStaticIndexSizeKB = totalStaticIndexSizeKB;
            this.totalStaticBloomSizeKB = totalStaticBloomSizeKB;
            this.readRequestsCount = readRequestsCount;
            this.writeRequestsCount = writeRequestsCount;
            this.totalCompactingKVs = totalCompactingKVs;
            this.currentCompactedKVs = currentCompactedKVs;
            this.coprocessors = coprocessors;
        }

        private String[] getCoprocessors() {
            return this.coprocessors.toArray(new String[0]);
        }

        public byte[] getName() {
            return this.name;
        }

        public String getNameAsString() {
            return Bytes.toString(this.name);
        }

        public int getStores() {
            return this.stores;
        }

        public int getStorefiles() {
            return this.storefiles;
        }

        public int getStorefileSizeMB() {
            return this.storefileSizeMB;
        }

        public int getMemStoreSizeMB() {
            return this.memstoreSizeMB;
        }

        public int getStorefileIndexSizeMB() {
            return this.storefileIndexSizeMB;
        }

        public long getRequestsCount() {
            return this.readRequestsCount + this.writeRequestsCount;
        }

        public long getReadRequestsCount() {
            return this.readRequestsCount;
        }

        public long getWriteRequestsCount() {
            return this.writeRequestsCount;
        }

        public int getRootIndexSizeKB() {
            return this.rootIndexSizeKB;
        }

        public int getTotalStaticIndexSizeKB() {
            return this.totalStaticIndexSizeKB;
        }

        public int getTotalStaticBloomSizeKB() {
            return this.totalStaticBloomSizeKB;
        }

        public long getTotalCompactingKVs() {
            return this.totalCompactingKVs;
        }

        public long getCurrentCompactedKVs() {
            return this.currentCompactedKVs;
        }

        public void setName(byte[] name) {
            this.name = name;
        }

        public void setStores(int stores) {
            this.stores = stores;
        }

        public void setStorefiles(int storefiles) {
            this.storefiles = storefiles;
        }

        public void setMemStoreSizeMB(int memstoreSizeMB) {
            this.memstoreSizeMB = memstoreSizeMB;
        }

        public void setStorefileIndexSizeMB(int storefileIndexSizeMB) {
            this.storefileIndexSizeMB = storefileIndexSizeMB;
        }

        public void setReadRequestsCount(int requestsCount) {
            this.readRequestsCount = requestsCount;
        }

        public void setWriteRequestsCount(int requestsCount) {
            this.writeRequestsCount = requestsCount;
        }

        public void setTotalCompactingKVs(long totalCompactingKVs) {
            this.totalCompactingKVs = totalCompactingKVs;
        }

        public void setCurrentCompactedKVs(long currentCompactedKVs) {
            this.currentCompactedKVs = currentCompactedKVs;
        }

        private void readFields92(DataInput in) throws IOException {
            byte version = in.readByte();
            int namelen = in.readInt();
            this.name = new byte[namelen];
            in.readFully(this.name);
            this.stores = in.readInt();
            this.storefiles = in.readInt();
            this.storeUncompressedSizeMB = in.readInt();
            this.storefileSizeMB = in.readInt();
            this.memstoreSizeMB = in.readInt();
            this.storefileIndexSizeMB = in.readInt();
            this.readRequestsCount = in.readInt();
            this.writeRequestsCount = in.readInt();
            this.rootIndexSizeKB = in.readInt();
            this.totalStaticIndexSizeKB = in.readInt();
            this.totalStaticBloomSizeKB = in.readInt();
            this.totalCompactingKVs = in.readLong();
            this.currentCompactedKVs = in.readLong();
            int coprocessorsSize = in.readInt();
            this.coprocessors = new TreeSet<String>();
            for (int i = 0; i < coprocessorsSize; ++i) {
                this.coprocessors.add(in.readUTF());
            }
        }

        public void readFields(DataInput in) throws IOException {
            byte version = in.readByte();
            if (version > 2) {
                throw new IOException("Version mismatch; " + version);
            }
            if (version == 1) {
                this.readFields92(in);
                return;
            }
            int namelen = WritableUtils.readVInt((DataInput)in);
            this.name = new byte[namelen];
            in.readFully(this.name);
            this.stores = WritableUtils.readVInt((DataInput)in);
            this.storefiles = WritableUtils.readVInt((DataInput)in);
            this.storeUncompressedSizeMB = WritableUtils.readVInt((DataInput)in);
            this.storefileSizeMB = WritableUtils.readVInt((DataInput)in);
            this.memstoreSizeMB = WritableUtils.readVInt((DataInput)in);
            this.storefileIndexSizeMB = WritableUtils.readVInt((DataInput)in);
            this.readRequestsCount = WritableUtils.readVLong((DataInput)in);
            this.writeRequestsCount = WritableUtils.readVLong((DataInput)in);
            this.rootIndexSizeKB = WritableUtils.readVInt((DataInput)in);
            this.totalStaticIndexSizeKB = WritableUtils.readVInt((DataInput)in);
            this.totalStaticBloomSizeKB = WritableUtils.readVInt((DataInput)in);
            this.totalCompactingKVs = WritableUtils.readVLong((DataInput)in);
            this.currentCompactedKVs = WritableUtils.readVLong((DataInput)in);
            int coprocessorsSize = WritableUtils.readVInt((DataInput)in);
            this.coprocessors = new TreeSet<String>();
            for (int i = 0; i < coprocessorsSize; ++i) {
                this.coprocessors.add(in.readUTF());
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeByte(1);
            out.writeByte(1);
            out.writeInt(this.name.length);
            out.write(this.name);
            out.writeInt(this.stores);
            out.writeInt(this.storefiles);
            out.writeInt(this.storeUncompressedSizeMB);
            out.writeInt(this.storefileSizeMB);
            out.writeInt(this.memstoreSizeMB);
            out.writeInt(this.storefileIndexSizeMB);
            out.writeInt((int)this.readRequestsCount);
            out.writeInt((int)this.writeRequestsCount);
            out.writeInt(this.rootIndexSizeKB);
            out.writeInt(this.totalStaticIndexSizeKB);
            out.writeInt(this.totalStaticBloomSizeKB);
            out.writeLong(this.totalCompactingKVs);
            out.writeLong(this.currentCompactedKVs);
            out.writeInt(this.coprocessors.size());
            for (String coprocessor : this.coprocessors) {
                out.writeUTF(coprocessor);
            }
        }

        public String toString() {
            StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "numberOfStores", this.stores);
            sb = Strings.appendKeyValue(sb, "numberOfStorefiles", this.storefiles);
            sb = Strings.appendKeyValue(sb, "storefileUncompressedSizeMB", this.storeUncompressedSizeMB);
            sb = Strings.appendKeyValue(sb, "storefileSizeMB", this.storefileSizeMB);
            if (this.storeUncompressedSizeMB != 0) {
                sb = Strings.appendKeyValue(sb, "compressionRatio", String.format("%.4f", Float.valueOf((float)this.storefileSizeMB / (float)this.storeUncompressedSizeMB)));
            }
            sb = Strings.appendKeyValue(sb, "memstoreSizeMB", this.memstoreSizeMB);
            sb = Strings.appendKeyValue(sb, "storefileIndexSizeMB", this.storefileIndexSizeMB);
            sb = Strings.appendKeyValue(sb, "readRequestsCount", this.readRequestsCount);
            sb = Strings.appendKeyValue(sb, "writeRequestsCount", this.writeRequestsCount);
            sb = Strings.appendKeyValue(sb, "rootIndexSizeKB", this.rootIndexSizeKB);
            sb = Strings.appendKeyValue(sb, "totalStaticIndexSizeKB", this.totalStaticIndexSizeKB);
            sb = Strings.appendKeyValue(sb, "totalStaticBloomSizeKB", this.totalStaticBloomSizeKB);
            sb = Strings.appendKeyValue(sb, "totalCompactingKVs", this.totalCompactingKVs);
            sb = Strings.appendKeyValue(sb, "currentCompactedKVs", this.currentCompactedKVs);
            float compactionProgressPct = Float.NaN;
            if (this.totalCompactingKVs > 0L) {
                compactionProgressPct = Float.valueOf(this.currentCompactedKVs / this.totalCompactingKVs).floatValue();
            }
            sb = Strings.appendKeyValue(sb, "compactionProgressPct", Float.valueOf(compactionProgressPct));
            String coprocessors = Arrays.toString(this.getCoprocessors());
            if (coprocessors != null) {
                sb = Strings.appendKeyValue(sb, "coprocessors", Arrays.toString(this.getCoprocessors()));
            }
            return sb.toString();
        }
    }
}

