/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class Scan
extends OperationWithAttributes
implements Writable {
    private static final String RAW_ATTR = "_raw_";
    private static final String ISOLATION_LEVEL = "_isolationlevel_";
    private static final byte SCAN_VERSION = 2;
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] stopRow = HConstants.EMPTY_END_ROW;
    private int maxVersions = 1;
    private int batch = -1;
    public static String SCAN_ATTRIBUTES_METRICS_ENABLE = "scan.attributes.metrics.enable";
    public static String SCAN_ATTRIBUTES_METRICS_DATA = "scan.attributes.metrics.data";
    private int caching = -1;
    private boolean cacheBlocks = true;
    private Filter filter = null;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Scan() {
    }

    public Scan(byte[] startRow, Filter filter) {
        this(startRow);
        this.filter = filter;
    }

    public Scan(byte[] startRow) {
        this.startRow = startRow;
    }

    public Scan(byte[] startRow, byte[] stopRow) {
        this.startRow = startRow;
        this.stopRow = stopRow;
    }

    public Scan(Scan scan) throws IOException {
        this.startRow = scan.getStartRow();
        this.stopRow = scan.getStopRow();
        this.maxVersions = scan.getMaxVersions();
        this.batch = scan.getBatch();
        this.caching = scan.getCaching();
        this.cacheBlocks = scan.getCacheBlocks();
        this.filter = scan.getFilter();
        TimeRange ctr = scan.getTimeRange();
        this.tr = new TimeRange(ctr.getMin(), ctr.getMax());
        Map<byte[], NavigableSet<byte[]>> fams = scan.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : scan.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    public Scan(Get get2) {
        this.startRow = get2.getRow();
        this.stopRow = get2.getRow();
        this.filter = get2.getFilter();
        this.cacheBlocks = get2.getCacheBlocks();
        this.maxVersions = get2.getMaxVersions();
        this.tr = get2.getTimeRange();
        this.familyMap = get2.getFamilyMap();
    }

    public boolean isGetScan() {
        return this.startRow != null && this.startRow.length > 0 && Bytes.equals(this.startRow, this.stopRow);
    }

    public Scan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Scan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Scan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Scan setTimeStamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Scan setStartRow(byte[] startRow) {
        this.startRow = startRow;
        return this;
    }

    public Scan setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
        return this;
    }

    public Scan setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Scan setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    public void setBatch(int batch) {
        if (this.hasFilter() && this.filter.hasFilterRow()) {
            throw new IncompatibleFilterException("Cannot set batch on a scan using a filter that returns true for filter.hasFilterRow");
        }
        this.batch = batch;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public Scan setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Scan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getCaching() {
        return this.caching;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        if (this.familyMap.size() == 0) {
            map.put("families", "ALL");
            return map;
        }
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap familyColumns = new HashMap();
        map.put("families", familyColumns);
        map.put("startRow", Bytes.toStringBinary(this.startRow));
        map.put("stopRow", Bytes.toStringBinary(this.stopRow));
        map.put("maxVersions", this.maxVersions);
        map.put("batch", this.batch);
        map.put("caching", this.caching);
        map.put("cacheBlocks", this.cacheBlocks);
        ArrayList<Long> timeRange = new ArrayList<Long>();
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> columns = new ArrayList<String>();
            familyColumns.put(Bytes.toStringBinary(entry.getKey()), columns);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                columns.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                columns.add(Bytes.toStringBinary(column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    private Writable createForName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return WritableFactories.newInstance(clazz, (Configuration)new Configuration());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 2) {
            throw new IOException("version not supported");
        }
        this.startRow = Bytes.readByteArray(in);
        this.stopRow = Bytes.readByteArray(in);
        this.maxVersions = in.readInt();
        this.batch = in.readInt();
        this.caching = in.readInt();
        this.cacheBlocks = in.readBoolean();
        if (in.readBoolean()) {
            this.filter = (Filter)this.createForName(Bytes.toString(Bytes.readByteArray(in)));
            this.filter.readFields(in);
        }
        this.tr = new TimeRange();
        this.tr.readFields(in);
        int numFamilies = in.readInt();
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = in.readInt();
            TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (int j = 0; j < numColumns; ++j) {
                byte[] qualifier = Bytes.readByteArray(in);
                set.add(qualifier);
            }
            this.familyMap.put(family, set);
        }
        if (version > 1) {
            this.readAttributes(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        Bytes.writeByteArray(out, this.startRow);
        Bytes.writeByteArray(out, this.stopRow);
        out.writeInt(this.maxVersions);
        out.writeInt(this.batch);
        out.writeInt(this.caching);
        out.writeBoolean(this.cacheBlocks);
        if (this.filter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, Bytes.toBytes(this.filter.getClass().getName()));
            this.filter.write(out);
        }
        this.tr.write(out);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet != null) {
                out.writeInt(columnSet.size());
                for (byte[] qualifier : columnSet) {
                    Bytes.writeByteArray(out, qualifier);
                }
                continue;
            }
            out.writeInt(0);
        }
        this.writeAttributes(out);
    }

    public void setRaw(boolean raw) {
        this.setAttribute(RAW_ATTR, Bytes.toBytes(raw));
    }

    public boolean isRaw() {
        byte[] attr = this.getAttribute(RAW_ATTR);
        return attr == null ? false : Bytes.toBoolean(attr);
    }

    public void setIsolationLevel(IsolationLevel level) {
        this.setAttribute(ISOLATION_LEVEL, level.toBytes());
    }

    public IsolationLevel getIsolationLevel() {
        byte[] attr = this.getAttribute(ISOLATION_LEVEL);
        return attr == null ? IsolationLevel.READ_COMMITTED : IsolationLevel.fromBytes(attr);
    }
}

