/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoprocessorClassLoader
extends URLClassLoader {
    private static final Log LOG = LogFactory.getLog(CoprocessorClassLoader.class);
    private static final String[] CLASS_PREFIX_EXEMPTIONS = new String[]{"com.sun.", "launcher.", "java.", "javax.", "org.ietf", "org.omg", "org.w3c", "org.xml", "sunw.", "org.apache.hadoop"};
    private static final Pattern[] RESOURCE_LOAD_PARENT_FIRST_PATTERNS = new Pattern[]{Pattern.compile("^[^-]+-default\\.xml$")};

    public CoprocessorClassLoader(List<URL> paths, ClassLoader parent) {
        super(paths.toArray(new URL[0]), parent);
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isClassExempt(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping exempt class " + name + " - delegating directly to parent"));
            }
            return super.loadClass(name);
        }
        Class<?> clasz = this.findLoadedClass(name);
        if (clasz != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Class " + name + " already loaded"));
            }
        } else {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finding class: " + name));
                }
                clasz = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Class " + name + " not found - delegating to parent"));
                }
                try {
                    clasz = super.loadClass(name);
                }
                catch (ClassNotFoundException e2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Class " + name + " not found in parent loader"));
                    }
                    throw e2;
                }
            }
        }
        return clasz;
    }

    @Override
    public synchronized URL getResource(String name) {
        URL resource = null;
        boolean parentLoaded = false;
        if (this.loadResourceUsingParentFirst(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking parent first for resource " + name));
            }
            resource = super.getResource(name);
            parentLoaded = true;
        }
        if (resource == null && (resource = this.findResource(name)) == null && !parentLoaded) {
            resource = super.getResource(name);
        }
        return resource;
    }

    protected boolean isClassExempt(String name) {
        for (String exemptPrefix : CLASS_PREFIX_EXEMPTIONS) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadResourceUsingParentFirst(String name) {
        for (Pattern resourcePattern : RESOURCE_LOAD_PARENT_FIRST_PATTERNS) {
            if (!resourcePattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

