/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.io.Writable;

public class FilterList
implements Filter {
    private static final Configuration conf = HBaseConfiguration.create();
    private static final int MAX_LOG_FILTERS = 5;
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter> filters = new ArrayList<Filter>();

    public FilterList() {
    }

    public FilterList(List<Filter> rowFilters) {
        this.filters = rowFilters;
    }

    public FilterList(Filter ... rowFilters) {
        this.filters = Arrays.asList(rowFilters);
    }

    public FilterList(Operator operator) {
        this.operator = operator;
    }

    public FilterList(Operator operator, List<Filter> rowFilters) {
        this.filters = rowFilters;
        this.operator = operator;
    }

    public FilterList(Operator operator, Filter ... rowFilters) {
        this.filters = Arrays.asList(rowFilters);
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public void reset() {
        for (Filter filter : this.filters) {
            filter.reset();
        }
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public boolean filterAllRemaining() {
        for (Filter filter : this.filters) {
            if (filter.filterAllRemaining()) {
                if (this.operator != Operator.MUST_PASS_ALL) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public KeyValue transform(KeyValue v) {
        KeyValue current = v;
        for (Filter filter : this.filters) {
            current = filter.transform(current);
        }
        return current;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        Filter.ReturnCode rc = this.operator == Operator.MUST_PASS_ONE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        block8: for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (filter.filterAllRemaining()) {
                    return Filter.ReturnCode.NEXT_ROW;
                }
                Filter.ReturnCode code = filter.filterKeyValue(v);
                switch (code) {
                    case INCLUDE_AND_NEXT_COL: {
                        rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    }
                    case INCLUDE: {
                        continue block8;
                    }
                }
                return code;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining()) continue;
            switch (filter.filterKeyValue(v)) {
                case INCLUDE: {
                    if (rc == Filter.ReturnCode.INCLUDE_AND_NEXT_COL) break;
                    rc = Filter.ReturnCode.INCLUDE;
                    break;
                }
                case INCLUDE_AND_NEXT_COL: {
                    rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                }
            }
        }
        return rc;
    }

    @Override
    public void filterRow(List<KeyValue> kvs) {
        for (Filter filter : this.filters) {
            filter.filterRow(kvs);
        }
    }

    @Override
    public boolean hasFilterRow() {
        for (Filter filter : this.filters) {
            if (!filter.hasFilterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow() {
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRow()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRow()) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    public void readFields(DataInput in) throws IOException {
        byte opByte = in.readByte();
        this.operator = Operator.values()[opByte];
        int size = in.readInt();
        if (size > 0) {
            this.filters = new ArrayList<Filter>(size);
            for (int i = 0; i < size; ++i) {
                Filter filter = (Filter)HbaseObjectWritable.readObject(in, conf);
                this.filters.add(filter);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.operator.ordinal());
        out.writeInt(this.filters.size());
        for (Filter filter : this.filters) {
            HbaseObjectWritable.writeObject(out, filter, Writable.class, conf);
        }
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue currentKV) {
        KeyValue keyHint = null;
        for (Filter filter : this.filters) {
            KeyValue curKeyHint = filter.getNextKeyHint(currentKV);
            if (curKeyHint == null && this.operator == Operator.MUST_PASS_ONE) {
                return null;
            }
            if (curKeyHint == null) continue;
            if (keyHint == null) {
                keyHint = curKeyHint;
                continue;
            }
            if (this.operator == Operator.MUST_PASS_ALL && KeyValue.COMPARATOR.compare(keyHint, curKeyHint) < 0) {
                keyHint = curKeyHint;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || KeyValue.COMPARATOR.compare(keyHint, curKeyHint) <= 0) continue;
            keyHint = curKeyHint;
        }
        return keyHint;
    }

    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxFilters) {
        int endIndex = this.filters.size() < maxFilters ? this.filters.size() : maxFilters;
        return String.format("%s %s (%d/%d): %s", this.getClass().getSimpleName(), this.operator == Operator.MUST_PASS_ALL ? "AND" : "OR", endIndex, this.filters.size(), this.filters.subList(0, endIndex).toString());
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

