/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class WhileMatchFilter
extends FilterBase {
    private boolean filterAllRemaining = false;
    private Filter filter;

    public WhileMatchFilter() {
    }

    public WhileMatchFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void reset() {
        this.filter.reset();
    }

    private void changeFAR(boolean value) {
        this.filterAllRemaining = this.filterAllRemaining || value;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.filterAllRemaining || this.filter.filterAllRemaining();
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        boolean value = this.filter.filterRowKey(buffer, offset, length);
        this.changeFAR(value);
        return value;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        Filter.ReturnCode c = this.filter.filterKeyValue(v);
        this.changeFAR(c != Filter.ReturnCode.INCLUDE);
        return c;
    }

    @Override
    public KeyValue transform(KeyValue v) {
        return this.filter.transform(v);
    }

    @Override
    public boolean filterRow() {
        boolean filterRow = this.filter.filterRow();
        this.changeFAR(filterRow);
        return filterRow;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.filter.getClass().getName());
        this.filter.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        String className = in.readUTF();
        try {
            this.filter = (Filter)Class.forName(className).newInstance();
            this.filter.readFields(in);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed deserialize.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed deserialize.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed deserialize.", e);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.filter.toString();
    }
}

