/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.ipc.WritableRpcEngine;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class HBaseRPC {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseRPC");
    public static final String RPC_ENGINE_PROP = "hbase.rpc.engine";
    private static final Map<Class, RpcEngine> PROTOCOL_ENGINES = new HashMap<Class, RpcEngine>();
    private static final Map<Class, RpcEngine> PROXY_ENGINES = new HashMap<Class, RpcEngine>();
    private static ThreadLocal<Integer> rpcTimeout = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return Integer.MAX_VALUE;
        }
    };

    private HBaseRPC() {
    }

    static void setProtocolEngine(Configuration conf, Class protocol, Class engine) {
        conf.setClass("hbase.rpc.engine." + protocol.getName(), engine, RpcEngine.class);
    }

    private static synchronized RpcEngine getProtocolEngine(Class protocol, Configuration conf) {
        RpcEngine engine = PROTOCOL_ENGINES.get(protocol);
        if (engine == null) {
            Class defaultEngine = conf.getClass(RPC_ENGINE_PROP, WritableRpcEngine.class);
            Class impl = conf.getClass("hbase.rpc.engine." + protocol.getName(), defaultEngine);
            LOG.debug((Object)("Using " + impl.getName() + " for " + protocol.getName()));
            engine = (RpcEngine)ReflectionUtils.newInstance((Class)impl, (Configuration)conf);
            if (protocol.isInterface()) {
                PROXY_ENGINES.put(Proxy.getProxyClass(protocol.getClassLoader(), protocol), engine);
            }
            PROTOCOL_ENGINES.put(protocol, engine);
        }
        return engine;
    }

    private static synchronized RpcEngine getProxyEngine(Object proxy) {
        return PROXY_ENGINES.get(proxy.getClass());
    }

    public static VersionedProtocol waitForProxy(Class protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int maxAttempts, int rpcTimeout, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        int reconnectAttempts = 0;
        while (true) {
            IOException ioe;
            block7: {
                try {
                    return HBaseRPC.getProxy(protocol, clientVersion, addr, conf, rpcTimeout);
                }
                catch (SocketTimeoutException te) {
                    LOG.info((Object)("Problem connecting to server: " + addr));
                    ioe = te;
                }
                catch (IOException ioex) {
                    ConnectException ce = null;
                    ioe = ioex instanceof ConnectException ? (ce = (ConnectException)ioex) : (ioex.getCause() != null && ioex.getCause() instanceof ConnectException ? (ce = (ConnectException)ioex.getCause()) : (ioex.getMessage().toLowerCase().contains("connection refused") ? (ce = new ConnectException(ioex.getMessage())) : ioex));
                    if (ce == null) break block7;
                    HBaseRPC.handleConnectionException(++reconnectAttempts, maxAttempts, protocol, addr, ce);
                }
            }
            if (System.currentTimeMillis() - timeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    private static void handleConnectionException(int retries, int maxAttmpts, Class<?> protocol, InetSocketAddress addr, ConnectException ce) throws RetriesExhaustedException {
        if (maxAttmpts >= 0 && retries >= maxAttmpts) {
            LOG.info((Object)("Server at " + addr + " could not be reached after " + maxAttmpts + " tries, giving up."));
            throw new RetriesExhaustedException("Failed setting up proxy " + protocol + " to " + addr.toString() + " after attempts=" + maxAttmpts, ce);
        }
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return HBaseRPC.getProxy(protocol, clientVersion, addr, User.getCurrent(), conf, factory, rpcTimeout);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, User ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        VersionedProtocol proxy = HBaseRPC.getProtocolEngine(protocol, conf).getProxy(protocol, clientVersion, addr, ticket, conf, factory, Math.min(rpcTimeout, HBaseRPC.getRpcTimeout()));
        long serverVersion = proxy.getProtocolVersion(protocol.getName(), clientVersion);
        if (serverVersion == clientVersion) {
            return proxy;
        }
        throw new VersionMismatch(protocol.getName(), clientVersion, serverVersion);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout) throws IOException {
        return HBaseRPC.getProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory((Configuration)conf), rpcTimeout);
    }

    public static void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            HBaseRPC.getProxyEngine(proxy).stopProxy(proxy);
        }
    }

    @Deprecated
    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Class<? extends VersionedProtocol> protocol, User ticket, Configuration conf) throws IOException, InterruptedException {
        return HBaseRPC.getProtocolEngine(protocol, conf).call(method, params, addrs, protocol, ticket, conf);
    }

    public static RpcServer getServer(Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        return HBaseRPC.getServer(instance.getClass(), instance, ifaces, bindAddress, port, numHandlers, metaHandlerCount, verbose, conf, highPriorityLevel);
    }

    public static RpcServer getServer(Class protocol, Object instance, Class<?>[] ifaces, String bindAddress, int port, int numHandlers, int metaHandlerCount, boolean verbose, Configuration conf, int highPriorityLevel) throws IOException {
        return HBaseRPC.getProtocolEngine(protocol, conf).getServer(protocol, instance, ifaces, bindAddress, port, numHandlers, metaHandlerCount, verbose, conf, highPriorityLevel);
    }

    public static void setRpcTimeout(int rpcTimeout) {
        HBaseRPC.rpcTimeout.set(rpcTimeout);
    }

    public static int getRpcTimeout() {
        return rpcTimeout.get();
    }

    public static void resetRpcTimeout() {
        rpcTimeout.remove();
    }

    public static class UnknownProtocolException
    extends DoNotRetryIOException {
        private Class<?> protocol;

        public UnknownProtocolException(String mesg) {
            super(mesg);
        }

        public UnknownProtocolException(Class<?> protocol) {
            this(protocol, "Server is not handling protocol " + protocol.getName());
        }

        public UnknownProtocolException(Class<?> protocol, String mesg) {
            super(mesg);
            this.protocol = protocol;
        }

        public Class getProtocol() {
            return this.protocol;
        }
    }

    public static class VersionMismatch
    extends IOException {
        private static final long serialVersionUID = 0L;
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }
    }
}

