/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.Set;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.io.WritableWithSize;
import org.apache.hadoop.hbase.ipc.ConnectionHeader;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.SecureConnectionHeader;
import org.apache.hadoop.hbase.ipc.Status;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteBufferOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public abstract class SecureServer
extends HBaseServer {
    private final boolean authorize;
    private boolean isSecurityEnabled;
    public static final ByteBuffer HEADER = ByteBuffer.wrap("srpc".getBytes());
    public static final byte CURRENT_VERSION = 4;
    public static final Set<Byte> INSECURE_VERSIONS = ImmutableSet.of((Object)3);
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.SecureServer");
    private static final Log AUDITLOG = LogFactory.getLog((String)"SecurityLogger.org.apache.hadoop.ipc.SecureServer");
    private static final String AUTH_FAILED_FOR = "Auth failed for ";
    private static final String AUTH_SUCCESSFUL_FOR = "Auth successful for ";
    protected SecretManager<TokenIdentifier> secretManager;
    protected ServiceAuthorizationManager authManager;

    protected SecureServer(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, int priorityHandlerCount, Configuration conf, String serverName, int highPriorityLevel) throws IOException {
        super(bindAddress, port, paramClass, handlerCount, priorityHandlerCount, conf, serverName, highPriorityLevel);
        this.authorize = conf.getBoolean("hadoop.security.authorization", false);
        this.isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        LOG.debug((Object)("security enabled=" + this.isSecurityEnabled));
        if (this.isSecurityEnabled) {
            HBaseSaslRpcServer.init(conf);
        }
    }

    @Override
    protected HBaseServer.Connection getConnection(SocketChannel channel, long time) {
        return new SecureConnection(channel, time);
    }

    Configuration getConf() {
        return this.conf;
    }

    void disableSecurity() {
        this.isSecurityEnabled = false;
    }

    void enableSecurity() {
        this.isSecurityEnabled = true;
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    public SecretManager<? extends TokenIdentifier> getSecretManager() {
        return this.secretManager;
    }

    public void setSecretManager(SecretManager<? extends TokenIdentifier> secretManager) {
        this.secretManager = secretManager;
    }

    public void authorize(User user, ConnectionHeader connection, InetAddress addr) throws AuthorizationException {
        if (this.authorize) {
            Class<? extends VersionedProtocol> protocol = null;
            try {
                protocol = SecureServer.getProtocolClass(connection.getProtocol(), this.getConf());
            }
            catch (ClassNotFoundException cfne) {
                throw new AuthorizationException("Unknown protocol: " + connection.getProtocol());
            }
            this.authManager.authorize(user != null ? user.getUGI() : null, protocol, this.getConf(), addr);
        }
    }

    public class SecureConnection
    extends HBaseServer.Connection {
        private boolean rpcHeaderRead;
        private boolean headerRead;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        protected final LinkedList<SecureCall> responseQueue;
        private int dataLength;
        private InetAddress addr;
        boolean useSasl;
        SaslServer saslServer;
        private HBaseSaslRpcServer.AuthMethod authMethod;
        private boolean saslContextEstablished;
        private boolean skipInitialSaslHandshake;
        private ByteBuffer rpcHeaderBuffer;
        private ByteBuffer unwrappedData;
        private ByteBuffer unwrappedDataLengthBuffer;
        public UserGroupInformation attemptingUser;
        private final int AUTHORIZATION_FAILED_CALLID = -1;
        private static final int SASL_CALLID = -33;
        private final SecureCall saslCall;
        private boolean useWrap;

        public SecureConnection(SocketChannel channel, long lastContact) {
            super(SecureServer.this, channel, lastContact);
            this.rpcHeaderRead = false;
            this.headerRead = false;
            this.attemptingUser = null;
            this.AUTHORIZATION_FAILED_CALLID = -1;
            this.saslCall = new SecureCall(-33, null, (HBaseServer.Connection)this, null, 0L);
            this.useWrap = false;
            this.header = new SecureConnectionHeader();
            this.channel = channel;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.unwrappedData = null;
            this.unwrappedDataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            this.addr = this.socket.getInetAddress();
            this.responseQueue = new LinkedList();
        }

        @Override
        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        @Override
        public String getHostAddress() {
            return this.hostAddress;
        }

        public InetAddress getHostInetAddress() {
            return this.addr;
        }

        private User getAuthorizedUgi(String authorizedId) throws IOException {
            if (this.authMethod == HBaseSaslRpcServer.AuthMethod.DIGEST) {
                TokenIdentifier tokenId = HBaseSaslRpcServer.getIdentifier(authorizedId, SecureServer.this.secretManager);
                UserGroupInformation ugi = tokenId.getUser();
                if (ugi == null) {
                    throw new AccessControlException("Can't retrieve username from tokenIdentifier.");
                }
                ugi.addTokenIdentifier(tokenId);
                return User.create(ugi);
            }
            return User.create(UserGroupInformation.createRemoteUser((String)authorizedId));
        }

        private void saslReadAndProcess(byte[] saslToken) throws IOException, InterruptedException {
            if (!this.saslContextEstablished) {
                byte[] replyToken = null;
                try {
                    if (this.saslServer == null) {
                        switch (this.authMethod) {
                            case DIGEST: {
                                if (SecureServer.this.secretManager == null) {
                                    throw new AccessControlException("Server is not configured to do DIGEST authentication.");
                                }
                                this.saslServer = Sasl.createSaslServer(HBaseSaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", HBaseSaslRpcServer.SASL_PROPS, new HBaseSaslRpcServer.SaslDigestCallbackHandler(SecureServer.this.secretManager, this));
                                break;
                            }
                            default: {
                                String[] names;
                                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                                String fullName = current.getUserName();
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Kerberos principal name is " + fullName));
                                }
                                if ((names = HBaseSaslRpcServer.splitKerberosName(fullName)).length != 3) {
                                    throw new AccessControlException("Kerberos principal name does NOT have the expected hostname part: " + fullName);
                                }
                                current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws SaslException {
                                        SecureConnection.this.saslServer = Sasl.createSaslServer(HBaseSaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], HBaseSaslRpcServer.SASL_PROPS, new HBaseSaslRpcServer.SaslGssCallbackHandler());
                                        return null;
                                    }
                                });
                            }
                        }
                        if (this.saslServer == null) {
                            throw new AccessControlException("Unable to find SASL server implementation for " + this.authMethod.getMechanismName());
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Created SASL server with mechanism = " + this.authMethod.getMechanismName()));
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.evaluateResponse()"));
                    }
                    replyToken = this.saslServer.evaluateResponse(saslToken);
                }
                catch (IOException e) {
                    IOException sendToClient = e;
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof SecretManager.InvalidToken)) continue;
                        sendToClient = (SecretManager.InvalidToken)cause;
                        break;
                    }
                    this.doSaslReply(HBaseSaslRpcServer.SaslStatus.ERROR, null, sendToClient.getClass().getName(), sendToClient.getLocalizedMessage());
                    SecureServer.this.rpcMetrics.authenticationFailures.inc();
                    String clientIP = this.toString();
                    AUDITLOG.warn((Object)(SecureServer.AUTH_FAILED_FOR + clientIP + ":" + this.attemptingUser));
                    throw e;
                }
                if (replyToken != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Will send token of size " + replyToken.length + " from saslServer."));
                    }
                    this.doSaslReply(HBaseSaslRpcServer.SaslStatus.SUCCESS, (Writable)new BytesWritable(replyToken), null, null);
                }
                if (this.saslServer.isComplete()) {
                    LOG.debug((Object)("SASL server context established. Negotiated QoP is " + this.saslServer.getNegotiatedProperty("javax.security.sasl.qop")));
                    String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                    this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
                    this.ticket = this.getAuthorizedUgi(this.saslServer.getAuthorizationID());
                    LOG.debug((Object)("SASL server successfully authenticated client: " + this.ticket));
                    SecureServer.this.rpcMetrics.authenticationSuccesses.inc();
                    AUDITLOG.info((Object)(SecureServer.AUTH_SUCCESSFUL_FOR + this.ticket));
                    this.saslContextEstablished = true;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.unwrap()"));
                }
                if (!this.useWrap) {
                    this.processOneRpc(saslToken);
                } else {
                    byte[] plaintextData = this.saslServer.unwrap(saslToken, 0, saslToken.length);
                    this.processUnwrappedData(plaintextData);
                }
            }
        }

        private void doSaslReply(HBaseSaslRpcServer.SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
            this.saslCall.setResponse(rv, status == HBaseSaslRpcServer.SaslStatus.SUCCESS ? Status.SUCCESS : Status.ERROR, errorClass, error);
            this.saslCall.responder = SecureServer.this.responder;
            this.saslCall.sendResponseIfReady();
        }

        private void disposeSasl() {
            if (this.saslServer != null) {
                try {
                    this.saslServer.dispose();
                }
                catch (SaslException saslException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                count = -1;
                if (this.dataLengthBuffer.remaining() > 0 && ((count = SecureServer.this.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.rpcHeaderRead) {
                    if (this.rpcHeaderBuffer == null) {
                        this.rpcHeaderBuffer = ByteBuffer.allocate(2);
                    }
                    if ((count = SecureServer.this.channelRead(this.channel, this.rpcHeaderBuffer)) < 0 || this.rpcHeaderBuffer.remaining() > 0) {
                        return count;
                    }
                    byte version = this.rpcHeaderBuffer.get(0);
                    byte[] method = new byte[]{this.rpcHeaderBuffer.get(1)};
                    this.authMethod = HBaseSaslRpcServer.AuthMethod.read(new DataInputStream(new ByteArrayInputStream(method)));
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer) || version != 4) {
                        if (INSECURE_VERSIONS.contains(version)) {
                            LOG.warn((Object)("An insecure client (version '" + version + "') is attempting to connect " + " to this version '" + 4 + "' secure server from " + this.hostAddress + ":" + this.remotePort));
                        } else {
                            LOG.warn((Object)("Incorrect header or version mismatch from " + this.hostAddress + ":" + this.remotePort + " got version " + version + " expected version " + 4));
                        }
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    if (this.authMethod == null) {
                        throw new IOException("Unable to read authentication method");
                    }
                    if (SecureServer.this.isSecurityEnabled && this.authMethod == HBaseSaslRpcServer.AuthMethod.SIMPLE) {
                        AccessControlException ae = new AccessControlException("Authentication is required");
                        SecureCall failedCall = new SecureCall(-1, null, (HBaseServer.Connection)this, null, 0L);
                        failedCall.setResponse(null, Status.FATAL, ae.getClass().getName(), ae.getMessage());
                        SecureServer.this.responder.doRespond(failedCall);
                        throw ae;
                    }
                    if (!SecureServer.this.isSecurityEnabled && this.authMethod != HBaseSaslRpcServer.AuthMethod.SIMPLE) {
                        this.doSaslReply(HBaseSaslRpcServer.SaslStatus.SUCCESS, (Writable)new IntWritable(-88), null, null);
                        this.authMethod = HBaseSaslRpcServer.AuthMethod.SIMPLE;
                        this.skipInitialSaslHandshake = true;
                    }
                    if (this.authMethod != HBaseSaslRpcServer.AuthMethod.SIMPLE) {
                        this.useSasl = true;
                    }
                    this.rpcHeaderBuffer = null;
                    this.rpcHeaderRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    if (this.dataLength == -1 && !this.useWrap) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    if (this.dataLength < 0) {
                        LOG.warn((Object)("Unexpected data length " + this.dataLength + "!! from " + this.getHostAddress()));
                    }
                    this.data = ByteBuffer.allocate(this.dataLength);
                    this.incRpcCount();
                }
                count = SecureServer.this.channelRead(this.channel, this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.skipInitialSaslHandshake) {
                    this.data = null;
                    this.skipInitialSaslHandshake = false;
                    continue;
                }
                boolean isHeaderRead = this.headerRead;
                if (this.useSasl) {
                    this.saslReadAndProcess(this.data.array());
                } else {
                    this.processOneRpc(this.data.array());
                }
                this.data = null;
                if (isHeaderRead) break;
            }
            return count;
        }

        private void processHeader(byte[] buf) throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
            this.header.readFields(in);
            try {
                String protocolClassName = this.header.getProtocol();
                if (protocolClassName != null) {
                    this.protocol = HBaseServer.getProtocolClass(this.header.getProtocol(), SecureServer.this.conf);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unknown protocol: " + this.header.getProtocol());
            }
            User protocolUser = this.header.getUser();
            if (!this.useSasl) {
                this.ticket = protocolUser;
                if (this.ticket != null) {
                    this.ticket.getUGI().setAuthenticationMethod(HBaseSaslRpcServer.AuthMethod.SIMPLE.authenticationMethod);
                }
            } else {
                this.ticket.getUGI().setAuthenticationMethod(this.authMethod.authenticationMethod);
                if (protocolUser != null && !protocolUser.getName().equals(this.ticket.getName())) {
                    if (this.authMethod == HBaseSaslRpcServer.AuthMethod.DIGEST) {
                        throw new AccessControlException("Authenticated user (" + this.ticket + ") doesn't match what the client claims to be (" + protocolUser + ")");
                    }
                    UserGroupInformation realUser = this.ticket.getUGI();
                    this.ticket = User.create(UserGroupInformation.createProxyUser((String)protocolUser.getName(), (UserGroupInformation)realUser));
                    this.ticket.getUGI().setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
                }
            }
        }

        private void processUnwrappedData(byte[] inBuf) throws IOException, InterruptedException {
            ReadableByteChannel ch = Channels.newChannel(new ByteArrayInputStream(inBuf));
            while (true) {
                int count = -1;
                if (this.unwrappedDataLengthBuffer.remaining() > 0 && ((count = SecureServer.this.channelRead(ch, this.unwrappedDataLengthBuffer)) <= 0 || this.unwrappedDataLengthBuffer.remaining() > 0)) {
                    return;
                }
                if (this.unwrappedData == null) {
                    this.unwrappedDataLengthBuffer.flip();
                    int unwrappedDataLength = this.unwrappedDataLengthBuffer.getInt();
                    if (unwrappedDataLength == -1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Received ping message");
                        }
                        this.unwrappedDataLengthBuffer.clear();
                        continue;
                    }
                    this.unwrappedData = ByteBuffer.allocate(unwrappedDataLength);
                }
                if ((count = SecureServer.this.channelRead(ch, this.unwrappedData)) <= 0 || this.unwrappedData.remaining() > 0) {
                    return;
                }
                if (this.unwrappedData.remaining() != 0) continue;
                this.unwrappedDataLengthBuffer.clear();
                this.unwrappedData.flip();
                this.processOneRpc(this.unwrappedData.array());
                this.unwrappedData = null;
            }
        }

        private void processOneRpc(byte[] buf) throws IOException, InterruptedException {
            if (this.headerRead) {
                this.processData(buf);
            } else {
                this.processHeader(buf);
                this.headerRead = true;
                if (!this.authorizeConnection()) {
                    throw new AccessControlException("Connection from " + this + " for protocol " + this.header.getProtocol() + " is unauthorized for user " + this.ticket);
                }
            }
        }

        @Override
        protected void processData(byte[] buf) throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
            int id = dis.readInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" got #" + id));
            }
            Writable param = (Writable)ReflectionUtils.newInstance((Class)SecureServer.this.paramClass, (Configuration)SecureServer.this.conf);
            param.readFields((DataInput)dis);
            SecureCall call = new SecureCall(id, param, (HBaseServer.Connection)this, SecureServer.this.responder, (long)buf.length);
            if (SecureServer.this.priorityCallQueue != null && SecureServer.this.getQosLevel(param) > SecureServer.this.highPriorityLevel) {
                SecureServer.this.priorityCallQueue.put(call);
                SecureServer.this.updateCallQueueLenMetrics(SecureServer.this.priorityCallQueue);
            } else if (SecureServer.this.replicationQueue != null && SecureServer.this.getQosLevel(param) == 5) {
                SecureServer.this.replicationQueue.put(call);
                SecureServer.this.updateCallQueueLenMetrics(SecureServer.this.replicationQueue);
            } else {
                SecureServer.this.callQueue.put(call);
                SecureServer.this.updateCallQueueLenMetrics(SecureServer.this.callQueue);
            }
        }

        private boolean authorizeConnection() throws IOException {
            try {
                if (this.ticket != null && this.ticket.getUGI().getRealUser() != null && this.authMethod != HBaseSaslRpcServer.AuthMethod.DIGEST) {
                    ProxyUsers.authorize((UserGroupInformation)this.ticket.getUGI(), (String)this.getHostAddress(), (Configuration)SecureServer.this.conf);
                }
                SecureServer.this.authorize(this.ticket, this.header, this.getHostInetAddress());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Successfully authorized " + this.header));
                }
                SecureServer.this.rpcMetrics.authorizationSuccesses.inc();
            }
            catch (AuthorizationException ae) {
                LOG.debug((Object)("Connection authorization failed: " + ae.getMessage()), (Throwable)ae);
                SecureServer.this.rpcMetrics.authorizationFailures.inc();
                SecureCall failedCall = new SecureCall(-1, null, (HBaseServer.Connection)this, null, 0L);
                failedCall.setResponse(null, Status.FATAL, ((Object)((Object)ae)).getClass().getName(), ae.getMessage());
                SecureServer.this.responder.doRespond(failedCall);
                return false;
            }
            return true;
        }

        @Override
        protected synchronized void close() {
            this.disposeSasl();
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class SecureCall
    extends HBaseServer.Call {
        public SecureCall(int id, Writable param, HBaseServer.Connection connection, HBaseServer.Responder responder, long size) {
            super(SecureServer.this, id, param, connection, responder, size);
        }

        @Override
        protected synchronized void setResponse(Object value, Status status, String errorClass, String error) {
            Writable result = null;
            if (value instanceof Writable) {
                result = (Writable)value;
            } else if (value != null) {
                result = new HbaseObjectWritable(value);
            }
            int size = 1024;
            if (result instanceof WritableWithSize) {
                WritableWithSize ohint = (WritableWithSize)result;
                long hint = ohint.getWritableSize() + 4L + 4L;
                if (hint > Integer.MAX_VALUE) {
                    IOException ioe = new IOException("Result buffer size too large: " + hint);
                    errorClass = ioe.getClass().getName();
                    error = StringUtils.stringifyException((Throwable)ioe);
                } else {
                    size = (int)hint;
                }
            }
            ByteBufferOutputStream buf = new ByteBufferOutputStream(size);
            DataOutputStream out = new DataOutputStream(buf);
            try {
                out.writeInt(this.id);
                out.writeInt(status.state);
            }
            catch (IOException e) {
                errorClass = e.getClass().getName();
                error = StringUtils.stringifyException((Throwable)e);
            }
            try {
                if (status == Status.SUCCESS) {
                    result.write((DataOutput)out);
                } else {
                    WritableUtils.writeString((DataOutput)out, (String)errorClass);
                    WritableUtils.writeString((DataOutput)out, (String)error);
                }
                if (((SecureConnection)this.connection).useWrap) {
                    this.wrapWithSasl(buf);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error sending response to call: ", (Throwable)e);
            }
            this.response = buf.getByteBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wrapWithSasl(ByteBufferOutputStream response) throws IOException {
            if (((SecureConnection)this.connection).useSasl) {
                byte[] token;
                ByteBuffer buf = response.getByteBuffer();
                SaslServer saslServer = ((SecureConnection)this.connection).saslServer;
                synchronized (saslServer) {
                    token = ((SecureConnection)this.connection).saslServer.wrap(buf.array(), buf.arrayOffset(), buf.remaining());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding saslServer wrapped token of size " + token.length + " as call response."));
                }
                buf.clear();
                DataOutputStream saslOut = new DataOutputStream(response);
                saslOut.writeInt(token.length);
                saslOut.write(token, 0, token.length);
            }
        }
    }
}

