/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class Import {
    static final String NAME = "import";
    static final String CF_RENAME_PROP = "HBASE_IMPORTER_RENAME_CFS";
    static final String BULK_OUTPUT_CONF_KEY = "import.bulk.output";

    private static KeyValue convertKv(KeyValue kv, Map<byte[], byte[]> cfRenameMap) {
        byte[] newCfName;
        if (cfRenameMap != null && (newCfName = cfRenameMap.get(kv.getFamily())) != null) {
            kv = new KeyValue(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), newCfName, 0, newCfName.length, kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getType()), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        }
        return kv;
    }

    private static Map<byte[], byte[]> createCfRenameMap(Configuration conf) {
        TreeMap<byte[], byte[]> cfRenameMap = null;
        String allMappingsPropVal = conf.get(CF_RENAME_PROP);
        if (allMappingsPropVal != null) {
            String[] allMappings;
            for (String mapping : allMappings = allMappingsPropVal.split(",")) {
                String[] srcAndDest;
                if (cfRenameMap == null) {
                    cfRenameMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
                }
                if ((srcAndDest = mapping.split(":")).length != 2) continue;
                cfRenameMap.put(srcAndDest[0].getBytes(), srcAndDest[1].getBytes());
            }
        }
        return cfRenameMap;
    }

    public static void configureCfRenaming(Configuration conf, Map<String, String> renameMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : renameMap.entrySet()) {
            String sourceCf = entry.getKey();
            String destCf = entry.getValue();
            if (sourceCf.contains(":") || sourceCf.contains(",") || destCf.contains(":") || destCf.contains(",")) {
                throw new IllegalArgumentException("Illegal character in CF names: " + sourceCf + ", " + destCf);
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(sourceCf + ":" + destCf);
        }
        conf.set(CF_RENAME_PROP, sb.toString());
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path inputDir = new Path(args[1]);
        Job job = new Job(conf, "import_" + tableName);
        job.setJarByClass(Importer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setInputFormatClass(SequenceFileInputFormat.class);
        String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
        if (hfileOutPath != null) {
            job.setMapperClass(KeyValueImporter.class);
            HTable table = new HTable(conf, tableName);
            job.setReducerClass(KeyValueSortReducer.class);
            Path outputDir = new Path(hfileOutPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
            HFileOutputFormat.configureIncrementalLoad(job, table);
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), Preconditions.class);
        } else {
            job.setMapperClass(Importer.class);
            TableMapReduceUtil.initTableReducerJob(tableName, null, job);
            job.setNumReduceTasks(0);
        }
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Import [options] <tablename> <inputdir>");
        System.err.println("By default Import will load data directly into HBase. To instead generate");
        System.err.println("HFiles of data to prepare for a bulk data load, pass the option:");
        System.err.println("  -Dimport.bulk.output=/path/for/output");
        System.err.println("For performance consider the following options:\n  -Dmapred.map.tasks.speculative.execution=false\n  -Dmapred.reduce.tasks.speculative.execution=false");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Import.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        System.exit((job = Import.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class Importer
    extends TableMapper<ImmutableBytesWritable, Mutation> {
        private Map<byte[], byte[]> cfRenameMap;

        Importer() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                this.writeResult(row, value, context);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void writeResult(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException, InterruptedException {
            Put put2 = null;
            Delete delete = null;
            for (KeyValue kv : result.raw()) {
                if ((kv = Import.convertKv(kv, this.cfRenameMap)).isDelete()) {
                    if (delete == null) {
                        delete = new Delete(key.get());
                    }
                    delete.addDeleteMarker(kv);
                    continue;
                }
                if (put2 == null) {
                    put2 = new Put(key.get());
                }
                put2.add(kv);
            }
            if (put2 != null) {
                context.write((Object)key, put2);
            }
            if (delete != null) {
                context.write((Object)key, delete);
            }
        }

        public void setup(Mapper.Context context) {
            this.cfRenameMap = Import.createCfRenameMap(context.getConfiguration());
        }
    }

    static class KeyValueImporter
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        private Map<byte[], byte[]> cfRenameMap;

        KeyValueImporter() {
        }

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                for (KeyValue kv : value.raw()) {
                    context.write((Object)row, (Object)Import.convertKv(kv, this.cfRenameMap));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setup(Mapper.Context context) {
            this.cfRenameMap = Import.createCfRenameMap(context.getConfiguration());
        }
    }
}

