/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class CreateTableHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(CreateTableHandler.class);
    protected MasterFileSystem fileSystemManager;
    protected final HTableDescriptor hTableDescriptor;
    protected Configuration conf;
    protected final AssignmentManager assignmentManager;
    protected final CatalogTracker catalogTracker;
    protected final ServerManager serverManager;
    private final HRegionInfo[] newRegions;

    public CreateTableHandler(Server server, MasterFileSystem fileSystemManager, ServerManager serverManager, HTableDescriptor hTableDescriptor, Configuration conf, HRegionInfo[] newRegions, CatalogTracker catalogTracker, AssignmentManager assignmentManager) throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        super(server, EventHandler.EventType.C_M_CREATE_TABLE);
        this.fileSystemManager = fileSystemManager;
        this.serverManager = serverManager;
        this.hTableDescriptor = hTableDescriptor;
        this.conf = conf;
        this.newRegions = newRegions;
        this.catalogTracker = catalogTracker;
        this.assignmentManager = assignmentManager;
        int timeout = conf.getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (catalogTracker.waitForMeta(timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted waiting for meta availability", (Throwable)e);
            throw new IOException(e);
        }
        String tableName = this.hTableDescriptor.getNameAsString();
        if (MetaReader.tableExists(catalogTracker, tableName)) {
            throw new TableExistsException(tableName);
        }
        try {
            if (!this.assignmentManager.getZKTable().checkAndSetEnablingTable(tableName)) {
                throw new TableExistsException(tableName);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabling because of a ZooKeeper issue", e);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.hTableDescriptor.getNameAsString();
    }

    @Override
    public void process() {
        String tableName = this.hTableDescriptor.getNameAsString();
        try {
            LOG.info((Object)("Attempting to create the table " + tableName));
            this.handleCreateTable(tableName);
            this.completed(null);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error trying to create the table " + tableName), e);
            this.completed(e);
        }
    }

    protected void completed(Throwable exception) {
    }

    private void handleCreateTable(String tableName) throws IOException, KeeperException {
        Path tempdir = this.fileSystemManager.getTempDir();
        FileSystem fs = this.fileSystemManager.getFileSystem();
        FSTableDescriptors.createTableDescriptor(fs, tempdir, this.hTableDescriptor);
        Path tempTableDir = new Path(tempdir, tableName);
        Path tableDir = new Path(this.fileSystemManager.getRootDir(), tableName);
        List<HRegionInfo> regionInfos = this.handleCreateHdfsRegions(tempdir, tableName);
        if (!fs.rename(tempTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
        }
        if (regionInfos != null && regionInfos.size() > 0) {
            MetaEditor.addRegionsToMeta(this.catalogTracker, regionInfos);
            List<ServerName> servers = this.serverManager.getOnlineServersList();
            this.assignmentManager.removeDeadNotExpiredServers(servers);
            try {
                this.assignmentManager.assignUserRegions(regionInfos, servers);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Caught " + e + " during round-robin assignment"));
                InterruptedIOException ie = new InterruptedIOException(e.getMessage());
                ie.initCause(e);
                throw ie;
            }
        }
        try {
            this.assignmentManager.getZKTable().setEnabledTable(tableName);
        }
        catch (KeeperException e) {
            throw new IOException("Unable to ensure that the table will be enabled because of a ZooKeeper issue", e);
        }
    }

    protected List<HRegionInfo> handleCreateHdfsRegions(final Path tableRootDir, String tableName) throws IOException {
        int regionNumber = this.newRegions.length;
        ThreadPoolExecutor regionOpenAndInitThreadPool = this.getRegionOpenAndInitThreadPool("RegionOpenAndInitThread-" + tableName, regionNumber);
        ExecutorCompletionService<HRegion> completionService = new ExecutorCompletionService<HRegion>(regionOpenAndInitThreadPool);
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        for (final HRegionInfo newRegion : this.newRegions) {
            completionService.submit(new Callable<HRegion>(){

                @Override
                public HRegion call() throws IOException {
                    HRegion region = HRegion.createHRegion(newRegion, tableRootDir, CreateTableHandler.this.conf, CreateTableHandler.this.hTableDescriptor, null, false, true);
                    region.close();
                    return region;
                }
            });
        }
        try {
            for (int i = 0; i < regionNumber; ++i) {
                Future future = completionService.take();
                HRegion region = (HRegion)future.get();
                regionInfos.add(region.getRegionInfo());
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            regionOpenAndInitThreadPool.shutdownNow();
        }
        return regionInfos;
    }

    protected ThreadPoolExecutor getRegionOpenAndInitThreadPool(final String threadNamePrefix, int regionNumber) {
        int maxThreads = Math.min(regionNumber, this.conf.getInt("hbase.hregion.open.and.init.threads.max", 10));
        ThreadPoolExecutor openAndInitializeThreadPool = Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadNamePrefix + "-" + this.count++);
                return t;
            }
        });
        return openAndInitializeThreadPool;
    }
}

