/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.zookeeper.KeeperException;

public class DeleteTableHandler
extends TableEventHandler {
    private static final Log LOG = LogFactory.getLog(DeleteTableHandler.class);

    public DeleteTableHandler(byte[] tableName, Server server, MasterServices masterServices) throws IOException {
        super(EventHandler.EventType.C_M_DELETE_TABLE, tableName, server, masterServices);
        this.getTableDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException, KeeperException {
        AssignmentManager am = this.masterServices.getAssignmentManager();
        long waitTime = this.server.getConfiguration().getLong("hbase.master.wait.on.region", 300000L);
        for (HRegionInfo region : regions) {
            AssignmentManager.RegionState rs;
            long done = System.currentTimeMillis() + waitTime;
            while (System.currentTimeMillis() < done && (rs = am.isRegionInTransition(region)) != null) {
                Threads.sleep(this.waitingTimeForEvents);
                LOG.debug((Object)("Waiting on  region to clear regions in transition; " + rs));
            }
            if (am.isRegionInTransition(region) == null) continue;
            throw new IOException("Waited hbase.master.wait.on.region (" + waitTime + "ms) for region to leave region " + region.getRegionNameAsString() + " in transitions");
        }
        LOG.debug((Object)"Deleting regions from META");
        MetaEditor.deleteRegions(this.server.getCatalogTracker(), regions);
        LOG.debug((Object)"Moving table directory to a temp directory");
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        Path tempTableDir = mfs.moveTableToTemp(this.tableName);
        try {
            FileSystem fs = mfs.getFileSystem();
            for (HRegionInfo hri : regions) {
                LOG.debug((Object)("Deleting region " + hri.getRegionNameAsString() + " from FS"));
                HFileArchiver.archiveRegion(fs, mfs.getRootDir(), tempTableDir, new Path(tempTableDir, hri.getEncodedName()));
            }
            fs.delete(tempTableDir, true);
        }
        finally {
            this.masterServices.getTableDescriptors().remove(Bytes.toString(this.tableName));
            am.getZKTable().setDeletedTable(Bytes.toString(this.tableName));
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableNameStr;
    }
}

