/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MasterSnapshotVerifier {
    private HBaseProtos.SnapshotDescription snapshot;
    private FileSystem fs;
    private Path rootDir;
    private String tableName;
    private MasterServices services;

    public MasterSnapshotVerifier(MasterServices services, HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        this.fs = services.getMasterFileSystem().getFileSystem();
        this.services = services;
        this.snapshot = snapshot;
        this.rootDir = rootDir;
        this.tableName = snapshot.getTable();
    }

    public void verifySnapshot(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        this.verifySnapshotDescription(snapshotDir);
        this.verifyTableInfo(snapshotDir);
        this.verifyRegions(snapshotDir);
    }

    private void verifySnapshotDescription(Path snapshotDir) throws CorruptedSnapshotException {
        HBaseProtos.SnapshotDescription found = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        if (!this.snapshot.equals(found)) {
            throw new CorruptedSnapshotException("Snapshot read (" + found + ") doesn't equal snapshot we ran (" + this.snapshot + ").", this.snapshot);
        }
    }

    private void verifyTableInfo(Path snapshotDir) throws IOException {
        FSTableDescriptors.getTableDescriptor(this.fs, snapshotDir);
    }

    private void verifyRegions(Path snapshotDir) throws IOException {
        List<HRegionInfo> regions = MetaReader.getTableRegions(this.services.getCatalogTracker(), Bytes.toBytes(this.tableName));
        for (HRegionInfo region : regions) {
            if (region.isOffline() || region.isSplit() || region.isSplitParent()) continue;
            this.verifyRegion(this.fs, snapshotDir, region);
        }
    }

    private void verifyRegion(FileSystem fs, Path snapshotDir, HRegionInfo region) throws IOException {
        Path regionDir = new Path(snapshotDir, region.getEncodedName());
        if (!fs.exists(regionDir)) {
            throw new CorruptedSnapshotException("No region directory found for region:" + (Object)((Object)region), this.snapshot);
        }
        Path regionInfo = new Path(regionDir, ".regioninfo");
        if (!fs.exists(regionInfo)) {
            throw new CorruptedSnapshotException("No region info found for region:" + (Object)((Object)region), this.snapshot);
        }
        FSDataInputStream in = fs.open(regionInfo);
        HRegionInfo found = new HRegionInfo();
        found.readFields((DataInput)in);
        if (!region.equals((Object)found)) {
            throw new CorruptedSnapshotException("Found region info (" + (Object)((Object)found) + ") doesn't match expected region:" + (Object)((Object)region), this.snapshot);
        }
        TakeSnapshotUtils.verifyRecoveredEdits(fs, snapshotDir, found, this.snapshot);
        FSUtils.FamilyDirFilter familiesDirs = new FSUtils.FamilyDirFilter(fs);
        FileStatus[] columnFamilies = FSUtils.listStatus(fs, regionDir, familiesDirs);
        if (columnFamilies == null) {
            return;
        }
        Path tableNameSuffix = new Path(this.tableName);
        Path regionNameSuffix = new Path(tableNameSuffix, region.getEncodedName());
        Path archivedRegion = new Path(HFileArchiveUtil.getArchivePath(this.services.getConfiguration()), regionNameSuffix);
        Path realRegion = new Path(this.rootDir, regionNameSuffix);
        for (FileStatus cf : columnFamilies) {
            FileStatus[] hfiles = FSUtils.listStatus(fs, cf.getPath(), null);
            if (hfiles == null || hfiles.length == 0) continue;
            Path realCfDir = new Path(realRegion, cf.getPath().getName());
            Path archivedCfDir = new Path(archivedRegion, cf.getPath().getName());
            for (FileStatus hfile : hfiles) {
                if (!StoreFile.validateStoreFileName(hfile.getPath().getName())) {
                    throw new CorruptedSnapshotException("HFile: " + hfile.getPath() + " is not a valid hfile name.", this.snapshot);
                }
                String fileName = hfile.getPath().getName();
                Path file = new Path(realCfDir, fileName);
                Path archived = new Path(archivedCfDir, fileName);
                if (fs.exists(file) || file.equals((Object)archived)) continue;
                throw new CorruptedSnapshotException("Can't find hfile: " + hfile.getPath() + " in the real (" + realCfDir + ") or archive (" + archivedCfDir + ") directory for the primary table.", this.snapshot);
            }
        }
    }

    private void verifyLogs(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        Path snapshotLogDir = new Path(snapshotDir, ".logs");
        Path logsDir = new Path(this.rootDir, ".logs");
        TakeSnapshotUtils.verifyAllLogsGotReferenced(this.fs, logsDir, snapshotServers, this.snapshot, snapshotLogDir);
    }
}

