/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;

public class KeyPrefixRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Log LOG = LogFactory.getLog(KeyPrefixRegionSplitPolicy.class);
    public static String PREFIX_LENGTH_KEY = "prefix_split_key_policy.prefix_length";
    private int prefixLength = 0;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        if (region != null) {
            this.prefixLength = 0;
            String prefixLengthString = region.getTableDesc().getValue(PREFIX_LENGTH_KEY);
            if (prefixLengthString == null) {
                LOG.error((Object)(PREFIX_LENGTH_KEY + " not specified for table " + region.getTableDesc().getNameAsString() + ". Using default RegionSplitPolicy"));
                return;
            }
            try {
                this.prefixLength = Integer.parseInt(prefixLengthString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.prefixLength <= 0) {
                LOG.error((Object)("Invalid value for " + PREFIX_LENGTH_KEY + " for table " + region.getTableDesc().getNameAsString() + ":" + prefixLengthString + ". Using default RegionSplitPolicy"));
            }
        }
    }

    @Override
    protected byte[] getSplitPoint() {
        byte[] splitPoint = super.getSplitPoint();
        if (this.prefixLength > 0 && splitPoint != null && splitPoint.length > 0) {
            return Arrays.copyOf(splitPoint, Math.min(this.prefixLength, splitPoint.length));
        }
        return splitPoint;
    }
}

