/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;

public class RegionCoprocessorHost
extends CoprocessorHost<RegionEnvironment> {
    private static final Log LOG = LogFactory.getLog(RegionCoprocessorHost.class);
    private static ReferenceMap sharedDataMap = new ReferenceMap(0, 2);
    RegionServerServices rsServices;
    HRegion region;

    public RegionCoprocessorHost(HRegion region, RegionServerServices rsServices, Configuration conf) {
        this.rsServices = rsServices;
        this.region = region;
        this.pathPrefix = Integer.toString(this.region.getRegionInfo().hashCode());
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.region.classes");
        if (!HTableDescriptor.isMetaTable(region.getRegionInfo().getTableName())) {
            this.loadSystemCoprocessors(conf, "hbase.coprocessor.user.region.classes");
        }
        this.loadTableCoprocessors(conf);
    }

    void loadTableCoprocessors(Configuration conf) {
        ArrayList configured = new ArrayList();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.region.getTableDesc().getValues().entrySet()) {
            String key = Bytes.toString(e.getKey().get()).trim();
            String spec = Bytes.toString(e.getValue().get()).trim();
            if (!HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(key).matches()) continue;
            try {
                Matcher matcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(spec);
                if (matcher.matches()) {
                    Path path = matcher.group(1).trim().isEmpty() ? null : new Path(matcher.group(1).trim());
                    String className = matcher.group(2).trim();
                    int priority = matcher.group(3).trim().isEmpty() ? 0x3FFFFFFF : Integer.valueOf(matcher.group(3));
                    String cfgSpec = null;
                    try {
                        cfgSpec = matcher.group(4);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (cfgSpec != null) {
                        cfgSpec = cfgSpec.substring(cfgSpec.indexOf(124) + 1);
                        Configuration newConf = new Configuration(conf);
                        Matcher m = HConstants.CP_HTD_ATTR_VALUE_PARAM_PATTERN.matcher(cfgSpec);
                        while (m.find()) {
                            newConf.set(m.group(1), m.group(2));
                        }
                        configured.add(this.load(path, className, priority, newConf));
                    } else {
                        configured.add(this.load(path, className, priority, conf));
                    }
                    LOG.info((Object)("Load coprocessor " + className + " from HTD of " + Bytes.toString(this.region.getTableDesc().getName()) + " successfully."));
                    continue;
                }
                throw new RuntimeException("specification does not match pattern");
            }
            catch (Exception ex) {
                LOG.warn((Object)("attribute '" + key + "' has invalid coprocessor specification '" + spec + "'"));
                LOG.warn((Object)StringUtils.stringifyException((Throwable)ex));
            }
        }
        this.coprocessors.addAll(configured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        ConcurrentHashMap<String, Object> classData;
        for (Class<?> c : implClass.getInterfaces()) {
            if (!CoprocessorProtocol.class.isAssignableFrom(c)) continue;
            this.region.registerProtocol(c, (CoprocessorProtocol)((Object)instance));
            break;
        }
        ReferenceMap referenceMap = sharedDataMap;
        synchronized (referenceMap) {
            classData = (ConcurrentHashMap<String, Object>)sharedDataMap.get((Object)implClass.getName());
            if (classData == null) {
                classData = new ConcurrentHashMap<String, Object>();
                sharedDataMap.put((Object)implClass.getName(), classData);
            }
        }
        return new RegionEnvironment(instance, priority, seq, conf, this.region, this.rsServices, classData);
    }

    @Override
    protected void abortServer(CoprocessorEnvironment env, Throwable e) {
        this.abortServer("regionserver", this.rsServices, env, e);
    }

    private void handleCoprocessorThrowableNoRethrow(CoprocessorEnvironment env, Throwable e) {
        try {
            this.handleCoprocessorThrowable(env, e);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("handleCoprocessorThrowable() threw an IOException while attempting to handle Throwable " + e + ". Ignoring."), e);
        }
    }

    public void preOpen() {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preOpen(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public void postOpen() {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postOpen(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public void preClose(boolean abortRequested) {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preClose(ctx, abortRequested);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
        }
    }

    public void postClose(boolean abortRequested) {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (env.getInstance() instanceof RegionObserver) {
                ctx = ObserverContext.createAndPrepare(env, ctx);
                try {
                    ((RegionObserver)env.getInstance()).postClose(ctx, abortRequested);
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowableNoRethrow(env, e);
                }
            }
            this.shutdown(env);
        }
    }

    public InternalScanner preCompactScannerOpen(Store store, List<StoreFileScanner> scanners, ScanType scanType, long earliestPutTs) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        InternalScanner s = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                s = ((RegionObserver)env.getInstance()).preCompactScannerOpen(ctx, store, scanners, scanType, earliestPutTs, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    public boolean preCompactSelection(Store store, List<StoreFile> candidates) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        boolean bypass = false;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preCompactSelection(ctx, store, candidates);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postCompactSelection(Store store, ImmutableList<StoreFile> selected) {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postCompactSelection(ctx, store, selected);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowableNoRethrow(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public InternalScanner preCompact(Store store, InternalScanner scanner) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        boolean bypass = false;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                scanner = ((RegionObserver)env.getInstance()).preCompact(ctx, store, scanner);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? null : scanner;
    }

    public void postCompact(Store store, StoreFile resultFile) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postCompact(ctx, store, resultFile);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public InternalScanner preFlush(Store store, InternalScanner scanner) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        boolean bypass = false;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                scanner = ((RegionObserver)env.getInstance()).preFlush(ctx, store, scanner);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? null : scanner;
    }

    public void preFlush() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preFlush(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public InternalScanner preFlushScannerOpen(Store store, KeyValueScanner memstoreScanner) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        InternalScanner s = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                s = ((RegionObserver)env.getInstance()).preFlushScannerOpen(ctx, store, memstoreScanner, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    public void postFlush() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postFlush(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public void postFlush(Store store, StoreFile storeFile) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postFlush(ctx, store, storeFile);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public void preSplit() throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preSplit(ctx);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public void postSplit(HRegion l, HRegion r) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postSplit(ctx, l, r);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public boolean preGetClosestRowBefore(byte[] row, byte[] family, Result result) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preGetClosestRowBefore(ctx, row, family, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postGetClosestRowBefore(byte[] row, byte[] family, Result result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postGetClosestRowBefore(ctx, row, family, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public boolean preGet(Get get2, List<KeyValue> results) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preGet(ctx, get2, results);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postGet(Get get2, List<KeyValue> results) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postGet(ctx, get2, results);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public Boolean preExists(Get get2) throws IOException {
        boolean bypass = false;
        boolean exists2 = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                exists2 = ((RegionObserver)env.getInstance()).preExists(ctx, get2, exists2);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(exists2) : null;
    }

    public boolean postExists(Get get2, boolean exists2) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                exists2 = ((RegionObserver)env.getInstance()).postExists(ctx, get2, exists2);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return exists2;
    }

    public boolean prePut(Put put2, WALEdit edit, boolean writeToWAL) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).prePut(ctx, put2, edit, writeToWAL);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postPut(Put put2, WALEdit edit, boolean writeToWAL) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postPut(ctx, put2, edit, writeToWAL);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public boolean preDelete(Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preDelete(ctx, delete, edit, writeToWAL);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postDelete(Delete delete, WALEdit edit, boolean writeToWAL) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postDelete(ctx, delete, edit, writeToWAL);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public Boolean preCheckAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Put put2) throws IOException {
        boolean bypass = false;
        boolean result = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).preCheckAndPut(ctx, row, family, qualifier, compareOp, comparator, put2, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(result) : null;
    }

    public boolean postCheckAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Put put2, boolean result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).postCheckAndPut(ctx, row, family, qualifier, compareOp, comparator, put2, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    public Boolean preCheckAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Delete delete) throws IOException {
        boolean bypass = false;
        boolean result = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).preCheckAndDelete(ctx, row, family, qualifier, compareOp, comparator, delete, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(result) : null;
    }

    public boolean postCheckAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).postCheckAndDelete(ctx, row, family, qualifier, compareOp, comparator, delete, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    public Long preIncrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                amount = ((RegionObserver)env.getInstance()).preIncrementColumnValue(ctx, row, family, qualifier, amount, writeToWAL);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Long.valueOf(amount) : null;
    }

    public long postIncrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL, long result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).postIncrementColumnValue(ctx, row, family, qualifier, amount, writeToWAL, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    public Result preAppend(Append append) throws IOException {
        boolean bypass = false;
        Result result = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).preAppend(ctx, append);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? result : null;
    }

    public Result preIncrement(Increment increment2) throws IOException {
        boolean bypass = false;
        Result result = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).preIncrement(ctx, increment2);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? result : null;
    }

    public void postAppend(Append append, Result result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postAppend(ctx, append, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public Result postIncrement(Increment increment2, Result result) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                result = ((RegionObserver)env.getInstance()).postIncrement(ctx, increment2, result);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return result;
    }

    public RegionScanner preScannerOpen(Scan scan) throws IOException {
        boolean bypass = false;
        RegionScanner s = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                s = ((RegionObserver)env.getInstance()).preScannerOpen(ctx, scan, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? s : null;
    }

    public KeyValueScanner preStoreScannerOpen(Store store, Scan scan, NavigableSet<byte[]> targetCols) throws IOException {
        KeyValueScanner s = null;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                s = ((RegionObserver)env.getInstance()).preStoreScannerOpen(ctx, store, scan, targetCols, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    public RegionScanner postScannerOpen(Scan scan, RegionScanner s) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                s = ((RegionObserver)env.getInstance()).postScannerOpen(ctx, scan, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return s;
    }

    public Boolean preScannerNext(InternalScanner s, List<Result> results, int limit) throws IOException {
        boolean bypass = false;
        boolean hasNext = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                hasNext = ((RegionObserver)env.getInstance()).preScannerNext(ctx, s, results, limit, hasNext);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass ? Boolean.valueOf(hasNext) : null;
    }

    public boolean postScannerNext(InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                hasMore = ((RegionObserver)env.getInstance()).postScannerNext(ctx, s, results, limit, hasMore);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return hasMore;
    }

    public boolean preScannerClose(InternalScanner s) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preScannerClose(ctx, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postScannerClose(InternalScanner s) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postScannerClose(ctx, s);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public boolean preWALRestore(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preWALRestore(ctx, info, logKey, logEdit);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public void postWALRestore(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).postWALRestore(ctx, info, logKey, logEdit);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
    }

    public boolean preBulkLoadHFile(List<Pair<byte[], String>> familyPaths) throws IOException {
        boolean bypass = false;
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                ((RegionObserver)env.getInstance()).preBulkLoadHFile(ctx, familyPaths);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            bypass |= ctx.shouldBypass();
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return bypass;
    }

    public boolean postBulkLoadHFile(List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        ObserverContext<RegionCoprocessorEnvironment> ctx = null;
        for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            ctx = ObserverContext.createAndPrepare(env, ctx);
            try {
                hasLoaded = ((RegionObserver)env.getInstance()).postBulkLoadHFile(ctx, familyPaths, hasLoaded);
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            if (!ctx.shouldComplete()) continue;
            break;
        }
        return hasLoaded;
    }

    static class RegionEnvironment
    extends CoprocessorHost.Environment
    implements RegionCoprocessorEnvironment {
        private HRegion region;
        private RegionServerServices rsServices;
        ConcurrentMap<String, Object> sharedData;

        public RegionEnvironment(Coprocessor impl, int priority, int seq, Configuration conf, HRegion region, RegionServerServices services, ConcurrentMap<String, Object> sharedData) {
            super(impl, priority, seq, conf);
            this.region = region;
            this.rsServices = services;
            this.sharedData = sharedData;
        }

        @Override
        public HRegion getRegion() {
            return this.region;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.rsServices;
        }

        @Override
        public void shutdown() {
            super.shutdown();
        }

        @Override
        public ConcurrentMap<String, Object> getSharedData() {
            return this.sharedData;
        }
    }
}

