/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactSelection;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;

public class CompactionRequest
implements Comparable<CompactionRequest>,
Runnable {
    static final Log LOG = LogFactory.getLog(CompactionRequest.class);
    private final HRegion r;
    private final Store s;
    private final CompactSelection compactSelection;
    private final long totalSize;
    private final boolean isMajor;
    private int p;
    private final Long timeInNanos;
    private HRegionServer server = null;
    private static final ConcurrentHashMap<Long, AtomicInteger> majorCompactions = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, AtomicInteger> minorCompactions = new ConcurrentHashMap();

    public CompactionRequest(HRegion r, Store s, CompactSelection files, boolean isMajor, int p) {
        Preconditions.checkNotNull((Object)r);
        Preconditions.checkNotNull((Object)files);
        this.r = r;
        this.s = s;
        this.compactSelection = files;
        long sz = 0L;
        for (StoreFile sf : files.getFilesToCompact()) {
            sz += sf.getReader().length();
        }
        this.totalSize = sz;
        this.isMajor = isMajor;
        this.p = p;
        this.timeInNanos = System.nanoTime();
    }

    public static CompactionState getCompactionState(long regionId) {
        Long key = regionId;
        AtomicInteger major = majorCompactions.get(key);
        AtomicInteger minor = minorCompactions.get(key);
        int state = 0;
        if (minor != null && minor.get() > 0) {
            ++state;
        }
        if (major != null && major.get() > 0) {
            state += 2;
        }
        switch (state) {
            case 3: {
                return CompactionState.MAJOR_AND_MINOR;
            }
            case 2: {
                return CompactionState.MAJOR;
            }
            case 1: {
                return CompactionState.MINOR;
            }
        }
        return CompactionState.NONE;
    }

    public static void preRequest(CompactionRequest cr) {
        Long key = cr.getHRegion().getRegionId();
        ConcurrentHashMap<Long, AtomicInteger> compactions = cr.isMajor() ? majorCompactions : minorCompactions;
        AtomicInteger count = compactions.get(key);
        if (count == null) {
            compactions.putIfAbsent(key, new AtomicInteger(0));
            count = compactions.get(key);
        }
        count.incrementAndGet();
    }

    public static void postRequest(CompactionRequest cr) {
        Long key = cr.getHRegion().getRegionId();
        ConcurrentHashMap<Long, AtomicInteger> compactions = cr.isMajor() ? majorCompactions : minorCompactions;
        AtomicInteger count = compactions.get(key);
        if (count != null) {
            count.decrementAndGet();
        }
    }

    public void finishRequest() {
        this.compactSelection.finishRequest();
    }

    @Override
    public int compareTo(CompactionRequest request) {
        if (this.equals(request)) {
            return 0;
        }
        int compareVal = this.p - request.p;
        if (compareVal != 0) {
            return compareVal;
        }
        compareVal = this.timeInNanos.compareTo(request.timeInNanos);
        if (compareVal != 0) {
            return compareVal;
        }
        return this.hashCode() - request.hashCode();
    }

    public HRegion getHRegion() {
        return this.r;
    }

    public Store getStore() {
        return this.s;
    }

    public CompactSelection getCompactSelection() {
        return this.compactSelection;
    }

    public List<StoreFile> getFiles() {
        return this.compactSelection.getFilesToCompact();
    }

    public long getSize() {
        return this.totalSize;
    }

    public boolean isMajor() {
        return this.isMajor;
    }

    public int getPriority() {
        return this.p;
    }

    public void setPriority(int p) {
        this.p = p;
    }

    public void setServer(HRegionServer hrs) {
        this.server = hrs;
    }

    public String toString() {
        String fsList = Joiner.on((String)", ").join((Iterable)Collections2.transform((Collection)Collections2.filter(this.compactSelection.getFilesToCompact(), (Predicate)new Predicate<StoreFile>(){

            public boolean apply(StoreFile sf) {
                return sf.getReader() != null;
            }
        }), (Function)new Function<StoreFile, String>(){

            public String apply(StoreFile sf) {
                return StringUtils.humanReadableInt((long)sf.getReader().length());
            }
        }));
        return "regionName=" + this.r.getRegionNameAsString() + ", storeName=" + new String(this.s.getFamily().getName()) + ", fileCount=" + this.compactSelection.getFilesToCompact().size() + ", fileSize=" + StringUtils.humanReadableInt((long)this.totalSize) + (fsList.isEmpty() ? "" : " (" + fsList + ")") + ", priority=" + this.p + ", time=" + this.timeInNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Preconditions.checkNotNull((Object)this.server);
        if (this.server.isStopped()) {
            return;
        }
        try {
            long start = EnvironmentEdgeManager.currentTimeMillis();
            boolean completed = this.r.compact(this);
            long now = EnvironmentEdgeManager.currentTimeMillis();
            LOG.info((Object)((completed ? "completed" : "aborted") + " compaction: " + this + "; duration=" + StringUtils.formatTimeDiff((long)now, (long)start)));
            if (completed) {
                this.server.getMetrics().addCompaction(now - start, this.totalSize);
                if (this.s.getCompactPriority() <= 0) {
                    this.server.compactSplitThread.requestCompaction(this.r, this.s, "Recursive enqueue");
                } else {
                    this.server.compactSplitThread.requestSplit(this.r);
                }
            }
        }
        catch (IOException ex) {
            LOG.error((Object)("Compaction failed " + this), (Throwable)RemoteExceptionHandler.checkIOException(ex));
            this.server.checkFileSystem();
        }
        catch (Exception ex) {
            LOG.error((Object)("Compaction failed " + this), (Throwable)ex);
            this.server.checkFileSystem();
        }
        finally {
            this.s.finishRequest(this);
            LOG.debug((Object)("CompactSplitThread status: " + this.server.compactSplitThread));
        }
    }

    public static class Rejection
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable request, ThreadPoolExecutor pool) {
            if (request instanceof CompactionRequest) {
                CompactionRequest cr = (CompactionRequest)request;
                LOG.debug((Object)("Compaction Rejected: " + cr));
                cr.getStore().finishRequest(cr);
            }
        }
    }

    public static enum CompactionState {
        NONE,
        MINOR,
        MAJOR,
        MAJOR_AND_MINOR;

    }
}

