/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.util.Pair;

public class RegionMetricsStorage {
    private static final ConcurrentMap<String, AtomicLong> numericMetrics = new ConcurrentHashMap<String, AtomicLong>();
    private static final ConcurrentMap<String, AtomicLong> numericPersistentMetrics = new ConcurrentHashMap<String, AtomicLong>();
    private static final ConcurrentMap<String, Pair<AtomicLong, AtomicInteger>> timeVaryingMetrics = new ConcurrentHashMap<String, Pair<AtomicLong, AtomicInteger>>();

    public static Map<String, AtomicLong> getNumericMetrics() {
        return numericMetrics;
    }

    public static Map<String, AtomicLong> getNumericPersistentMetrics() {
        return numericPersistentMetrics;
    }

    public static Map<String, Pair<AtomicLong, AtomicInteger>> getTimeVaryingMetrics() {
        return timeVaryingMetrics;
    }

    public static void incrNumericMetric(String key, long amount) {
        AtomicLong oldVal = (AtomicLong)numericMetrics.get(key);
        if (oldVal == null && (oldVal = numericMetrics.putIfAbsent(key, new AtomicLong(amount))) == null) {
            return;
        }
        oldVal.addAndGet(amount);
    }

    public static void incrTimeVaryingMetric(String key, long amount) {
        Pair<AtomicLong, AtomicInteger> oldVal = (Pair<AtomicLong, AtomicInteger>)timeVaryingMetrics.get(key);
        if (oldVal == null && (oldVal = timeVaryingMetrics.putIfAbsent(key, new Pair<AtomicLong, AtomicInteger>(new AtomicLong(amount), new AtomicInteger(1)))) == null) {
            return;
        }
        ((AtomicLong)oldVal.getFirst()).addAndGet(amount);
        ((AtomicInteger)oldVal.getSecond()).incrementAndGet();
    }

    public static void incrNumericPersistentMetric(String key, long amount) {
        AtomicLong oldVal = (AtomicLong)numericPersistentMetrics.get(key);
        if (oldVal == null && (oldVal = numericPersistentMetrics.putIfAbsent(key, new AtomicLong(amount))) == null) {
            return;
        }
        oldVal.addAndGet(amount);
    }

    public static void setNumericMetric(String key, long amount) {
        numericMetrics.put(key, new AtomicLong(amount));
    }

    public static long getNumericMetric(String key) {
        AtomicLong m = (AtomicLong)numericMetrics.get(key);
        if (m == null) {
            return 0L;
        }
        return m.get();
    }

    public static Pair<Long, Integer> getTimeVaryingMetric(String key) {
        Pair pair = (Pair)timeVaryingMetrics.get(key);
        if (pair == null) {
            return new Pair<Long, Integer>(0L, 0);
        }
        return new Pair<Long, Integer>(((AtomicLong)pair.getFirst()).get(), ((AtomicInteger)pair.getSecond()).get());
    }

    public static long getNumericPersistentMetric(String key) {
        AtomicLong m = (AtomicLong)numericPersistentMetrics.get(key);
        if (m == null) {
            return 0L;
        }
        return m.get();
    }

    public static void clear() {
        timeVaryingMetrics.clear();
        numericMetrics.clear();
        numericPersistentMetrics.clear();
    }
}

