/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.metrics.RegionMetricsStorage;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerDynamicStatistics;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class RegionServerDynamicMetrics
implements Updater {
    private static final String UNABLE_TO_CLEAR = "Unable to clear RegionServerDynamicMetrics";
    private MetricsRecord metricsRecord;
    private MetricsContext context;
    private final RegionServerDynamicStatistics rsDynamicStatistics;
    private Method updateMbeanInfoIfMetricsListChanged = null;
    private static final Log LOG = LogFactory.getLog(RegionServerDynamicStatistics.class);
    private boolean reflectionInitialized = false;
    private boolean needsUpdateMessage = false;
    private Field recordMetricMapField;
    private Field registryMetricMapField;
    public final MetricsRegistry registry = new MetricsRegistry();

    private RegionServerDynamicMetrics() {
        this.context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)this.context, (String)"RegionServerDynamicStatistics");
        this.context.registerUpdater((Updater)this);
        this.rsDynamicStatistics = new RegionServerDynamicStatistics(this.registry);
        try {
            this.updateMbeanInfoIfMetricsListChanged = ((Object)((Object)this.rsDynamicStatistics)).getClass().getSuperclass().getDeclaredMethod("updateMbeanInfoIfMetricsListChanged", new Class[0]);
            this.updateMbeanInfoIfMetricsListChanged.setAccessible(true);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static RegionServerDynamicMetrics newInstance() {
        RegionServerDynamicMetrics metrics = new RegionServerDynamicMetrics();
        return metrics;
    }

    public synchronized void setNumericMetric(String name, long amt) {
        MetricsLongValue m = (MetricsLongValue)this.registry.get(name);
        if (m == null) {
            m = new MetricsLongValue(name, this.registry);
            this.needsUpdateMessage = true;
        }
        m.set(amt);
    }

    public synchronized void incrTimeVaryingMetric(String name, long amt, int numOps) {
        MetricsTimeVaryingRate m = (MetricsTimeVaryingRate)this.registry.get(name);
        if (m == null) {
            m = new MetricsTimeVaryingRate(name, this.registry);
            this.needsUpdateMessage = true;
        }
        if (numOps > 0) {
            m.inc(numOps, amt);
        }
    }

    public void clear() {
        this.needsUpdateMessage = true;
        if (!this.reflectionInitialized) {
            this.reflectionInitialized = true;
            try {
                this.recordMetricMapField = this.metricsRecord.getClass().getDeclaredField("metricTable");
                this.recordMetricMapField.setAccessible(true);
            }
            catch (SecurityException e) {
                LOG.debug((Object)UNABLE_TO_CLEAR);
                return;
            }
            catch (NoSuchFieldException e) {
                LOG.debug((Object)UNABLE_TO_CLEAR);
                return;
            }
            try {
                this.registryMetricMapField = this.registry.getClass().getDeclaredField("metricsList");
                this.registryMetricMapField.setAccessible(true);
            }
            catch (SecurityException e) {
                LOG.debug((Object)UNABLE_TO_CLEAR);
                return;
            }
            catch (NoSuchFieldException e) {
                LOG.debug((Object)UNABLE_TO_CLEAR);
                return;
            }
        }
        if (this.recordMetricMapField != null && this.registryMetricMapField != null) {
            try {
                Map recordMap = (Map)this.recordMetricMapField.get(this.metricsRecord);
                recordMap.clear();
                Map registryMap = (Map)this.registryMetricMapField.get(this.registry);
                registryMap.clear();
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Object)UNABLE_TO_CLEAR);
            }
            catch (IllegalAccessException e) {
                LOG.debug((Object)UNABLE_TO_CLEAR);
            }
        } else {
            LOG.debug((Object)UNABLE_TO_CLEAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext context) {
        for (Map.Entry<String, AtomicLong> entry : RegionMetricsStorage.getNumericMetrics().entrySet()) {
            this.setNumericMetric(entry.getKey(), entry.getValue().getAndSet(0L));
        }
        for (Map.Entry<String, AtomicLong> entry : RegionMetricsStorage.getNumericPersistentMetrics().entrySet()) {
            this.setNumericMetric(entry.getKey(), entry.getValue().get());
        }
        for (Map.Entry<String, Serializable> entry : RegionMetricsStorage.getTimeVaryingMetrics().entrySet()) {
            Pair value = (Pair)entry.getValue();
            this.incrTimeVaryingMetric(entry.getKey(), ((AtomicLong)value.getFirst()).getAndSet(0L), ((AtomicInteger)value.getSecond()).getAndSet(0));
        }
        if (this.needsUpdateMessage) {
            try {
                if (this.updateMbeanInfoIfMetricsListChanged != null) {
                    this.updateMbeanInfoIfMetricsListChanged.invoke((Object)this.rsDynamicStatistics, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            this.needsUpdateMessage = false;
        }
        MetricsRegistry metricsRegistry = this.registry;
        synchronized (metricsRegistry) {
            for (String metricName : this.registry.getKeyList()) {
                MetricsBase value = this.registry.get(metricName);
                value.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rsDynamicStatistics != null) {
            this.rsDynamicStatistics.shutdown();
        }
    }
}

