/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.OrphanHLogAfterSplitException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.io.MultipleIOException;

public class HLogSplitter {
    private static final String LOG_SPLITTER_IMPL = "hbase.hlog.splitter.impl";
    public static final String RECOVERED_EDITS = "recovered.edits";
    static final Log LOG = LogFactory.getLog(HLogSplitter.class);
    private boolean hasSplit = false;
    private long splitTime = 0L;
    private long splitSize = 0L;
    protected final Path rootDir;
    protected final Path srcDir;
    protected final Path oldLogDir;
    protected final FileSystem fs;
    protected final Configuration conf;
    OutputSink outputSink;
    EntryBuffers entryBuffers;
    protected AtomicReference<Throwable> thrown = new AtomicReference();
    Object dataAvailable = new Object();
    private MonitoredTask status;

    public static HLogSplitter createLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs) {
        Class splitterClass = conf.getClass(LOG_SPLITTER_IMPL, HLogSplitter.class);
        try {
            Constructor constructor = splitterClass.getConstructor(Configuration.class, Path.class, Path.class, Path.class, FileSystem.class);
            return (HLogSplitter)constructor.newInstance(conf, rootDir, srcDir, oldLogDir, fs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public HLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs) {
        this.conf = conf;
        this.rootDir = rootDir;
        this.srcDir = srcDir;
        this.oldLogDir = oldLogDir;
        this.fs = fs;
        this.entryBuffers = new EntryBuffers(conf.getInt("hbase.regionserver.hlog.splitlog.buffersize", 0x8000000));
        this.outputSink = new OutputSink();
    }

    public List<Path> splitLog() throws IOException {
        Preconditions.checkState((!this.hasSplit ? 1 : 0) != 0, (Object)"An HLogSplitter instance may only be used once");
        this.hasSplit = true;
        this.status = TaskMonitor.get().createStatus("Splitting logs in " + this.srcDir);
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        this.status.setStatus("Determining files to split...");
        List<Path> splits = null;
        if (!this.fs.exists(this.srcDir)) {
            this.status.markComplete("No log directory existed to split.");
            return splits;
        }
        FileStatus[] logfiles = this.fs.listStatus(this.srcDir);
        if (logfiles == null || logfiles.length == 0) {
            return splits;
        }
        this.logAndReport("Splitting " + logfiles.length + " hlog(s) in " + this.srcDir.toString());
        splits = this.splitLog(logfiles);
        this.splitTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
        String msg = "hlog file splitting completed in " + this.splitTime + " ms for " + this.srcDir.toString();
        this.status.markComplete(msg);
        LOG.info((Object)msg);
        return splits;
    }

    private void logAndReport(String msg) {
        this.status.setStatus(msg);
        LOG.info((Object)msg);
    }

    public long getTime() {
        return this.splitTime;
    }

    public long getSize() {
        return this.splitSize;
    }

    Map<byte[], Long> getOutputCounts() {
        Preconditions.checkState((boolean)this.hasSplit);
        return this.outputSink.getOutputCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> splitLog(FileStatus[] logfiles) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        List<Path> splits = null;
        boolean skipErrors = this.conf.getBoolean("hbase.hlog.split.skip.errors", true);
        HLogSplitter.countTotalBytes(logfiles);
        this.splitSize = 0L;
        this.outputSink.startWriterThreads(this.entryBuffers);
        try {
            int i = 0;
            for (FileStatus log : logfiles) {
                Path logPath = log.getPath();
                long logLength = log.getLen();
                this.splitSize += logLength;
                this.logAndReport("Splitting hlog " + (i++ + 1) + " of " + logfiles.length + ": " + logPath + ", length=" + logLength);
                try {
                    HLog.Reader in = this.getReader(this.fs, log, this.conf, skipErrors);
                    if (in != null) {
                        this.parseHLog(in, logPath, this.entryBuffers, this.fs, this.conf, skipErrors);
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LOG.warn((Object)"Close log reader threw exception -- continuing", (Throwable)e);
                        }
                    }
                    processedLogs.add(logPath);
                }
                catch (CorruptedLogFileException e) {
                    LOG.info((Object)("Got while parsing hlog " + logPath + ". Marking as corrupted"), (Throwable)e);
                    corruptedLogs.add(logPath);
                }
            }
            this.status.setStatus("Log splits complete. Checking for orphaned logs.");
            if (this.fs.listStatus(this.srcDir).length > processedLogs.size() + corruptedLogs.size()) {
                throw new OrphanHLogAfterSplitException("Discovered orphan hlog after split. Maybe the HRegionServer was not dead when we started");
            }
        }
        finally {
            this.status.setStatus("Finishing writing output logs and closing down.");
            splits = this.outputSink.finishWritingAndClose();
        }
        this.status.setStatus("Archiving logs after completed split");
        HLogSplitter.archiveLogs(this.srcDir, corruptedLogs, processedLogs, this.oldLogDir, this.fs, this.conf);
        return splits;
    }

    private static long countTotalBytes(FileStatus[] logfiles) {
        long ret = 0L;
        for (FileStatus stat : logfiles) {
            ret += stat.getLen();
        }
        return ret;
    }

    public static boolean splitLogFile(Path rootDir, FileStatus logfile, FileSystem fs, Configuration conf, CancelableProgressable reporter) throws IOException {
        HLogSplitter s = new HLogSplitter(conf, rootDir, null, null, fs);
        return s.splitLogFile(logfile, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean splitLogFile(FileStatus logfile, CancelableProgressable reporter) throws IOException {
        logWriters = Collections.synchronizedMap(new TreeMap<byte[], V>(Bytes.BYTES_COMPARATOR));
        isCorrupted = false;
        Preconditions.checkState((boolean)(this.status == null));
        this.status = TaskMonitor.get().createStatus("Splitting log file " + logfile.getPath() + "into a temporary staging area.");
        BAD_WRITER = new Object();
        progress_failed = false;
        skipErrors = this.conf.getBoolean("hbase.hlog.split.skip.errors", false);
        interval = this.conf.getInt("hbase.splitlog.report.interval.loglines", 1024);
        period = this.conf.getInt("hbase.splitlog.report.period", this.conf.getInt("hbase.splitlog.manager.timeout", 25000) / 2);
        numOpenedFilesBeforeReporting = this.conf.getInt("hbase.splitlog.report.openedfiles", 3);
        logPath = logfile.getPath();
        logLength = logfile.getLen();
        HLogSplitter.LOG.info((Object)("Splitting hlog: " + logPath + ", length=" + logLength));
        this.status.setStatus("Opening log file");
        in = null;
        try {
            in = this.getReader(this.fs, logfile, this.conf, skipErrors);
        }
        catch (CorruptedLogFileException e) {
            HLogSplitter.LOG.warn((Object)("Could not get reader, corrupted log file " + logPath), (Throwable)e);
            ZKSplitLog.markCorrupted(this.rootDir, logfile.getPath().getName(), this.fs);
            isCorrupted = true;
        }
        if (in == null) {
            this.status.markComplete("Was nothing to split in log file");
            HLogSplitter.LOG.warn((Object)("Nothing to split in log file " + logPath));
            return true;
        }
        last_report_at = t = EnvironmentEdgeManager.currentTimeMillis();
        if (reporter != null && !reporter.progress()) {
            this.status.markComplete("Failed: reporter.progress asked us to terminate");
            return false;
        }
        editsCount = 0;
        numNewlyOpenedFiles = 0;
        while (true) {
            try {
                while ((entry = HLogSplitter.getNextLogLine(in, logPath, skipErrors)) != null) {
                    region = entry.getKey().getEncodedRegionName();
                    o = logWriters.get(region);
                    if (o == BAD_WRITER) continue;
                    wap = (WriterAndPath)o;
                    if (wap == null) {
                        wap = this.createWAP(region, entry, this.rootDir, this.fs, this.conf);
                        ++numNewlyOpenedFiles;
                        if (wap == null) {
                            logWriters.put(region, BAD_WRITER);
                            continue;
                        }
                        logWriters.put(region, wap);
                    }
                    wap.w.append(entry);
                    this.outputSink.updateRegionMaximumEditLogSeqNum(entry);
                    if (++editsCount % interval != 0 && numNewlyOpenedFiles <= numOpenedFilesBeforeReporting) ** GOTO lbl187
                    numNewlyOpenedFiles = 0;
                    countsStr = "edits=" + editsCount + ", files=" + logWriters.size();
                    this.status.setStatus("Split " + countsStr);
                    t1 = EnvironmentEdgeManager.currentTimeMillis();
                    if (t1 - last_report_at <= (long)period) ** GOTO lbl187
                    last_report_at = t;
                    if (reporter == null || reporter.progress()) ** GOTO lbl187
                    this.status.markComplete("Failed: reporter.progress asked us to terminate; " + countsStr);
                    progress_failed = true;
                    var28_38 = false;
                    allWritersClosed = false;
                    ** GOTO lbl124
                }
                ** GOTO lbl188
            }
            catch (CorruptedLogFileException e) {
                HLogSplitter.LOG.warn((Object)("Could not parse, corrupted log file " + logPath), (Throwable)e);
                ZKSplitLog.markCorrupted(this.rootDir, logfile.getPath().getName(), this.fs);
                isCorrupted = true;
                allWritersClosed = false;
                ** GOTO lbl251
                {
                    catch (Throwable var56_75) {
                        block76: {
                            block79: {
                                block78: {
                                    block77: {
                                        allWritersClosed = false;
                                        try {
                                            n = 0;
                                            for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                                o = logWritersEntry.getValue();
                                                t1 = EnvironmentEdgeManager.currentTimeMillis();
                                                if (t1 - last_report_at > (long)period) {
                                                    last_report_at = t;
                                                    if (!progress_failed && reporter != null && !reporter.progress()) {
                                                        progress_failed = true;
                                                    }
                                                }
                                                if (o == BAD_WRITER) continue;
                                                ++n;
                                                wap = (WriterAndPath)o;
                                                wap.writerClosed = true;
                                                wap.w.close();
                                                HLogSplitter.LOG.debug((Object)("Closed " + wap.p));
                                                dst = HLogSplitter.getCompletedRecoveredEditsFilePath(wap.p, this.outputSink.getRegionMaximumEditLogSeqNum(logWritersEntry.getKey()));
                                                if (!dst.equals((Object)wap.p) && this.fs.exists(dst)) {
                                                    HLogSplitter.LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + dst + ", length=" + this.fs.getFileStatus(dst).getLen()));
                                                    if (!this.fs.delete(dst, false)) {
                                                        HLogSplitter.LOG.warn((Object)("Failed deleting of old " + dst));
                                                        throw new IOException("Failed deleting of old " + dst);
                                                    }
                                                }
                                                if (!this.fs.exists(wap.p)) continue;
                                                if (!this.fs.rename(wap.p, dst)) {
                                                    throw new IOException("Failed renaming " + wap.p + " to " + dst);
                                                }
                                                HLogSplitter.LOG.debug((Object)("Rename " + wap.p + " to " + dst));
                                            }
                                            allWritersClosed = true;
                                            msg = "Processed " + editsCount + " edits across " + n + " regions" + " threw away edits for " + (logWriters.size() - n) + " regions" + "; log file=" + logPath + " is corrupted = " + isCorrupted + " progress failed = " + progress_failed;
                                            HLogSplitter.LOG.info((Object)msg);
                                            this.status.markComplete(msg);
                                            if (!allWritersClosed) {
                                                i$ = logWriters.entrySet().iterator();
                                            }
                                            break block76;
                                        }
                                        catch (Throwable var66_86) {
                                            if (!allWritersClosed) {
                                                for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                                    o = logWritersEntry.getValue();
                                                    if (o == BAD_WRITER) continue;
                                                    wap = (WriterAndPath)o;
                                                    try {
                                                        if (wap.writerClosed) continue;
                                                        wap.writerClosed = true;
                                                        wap.w.close();
                                                    }
                                                    catch (IOException e) {
                                                        HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                                    }
                                                }
                                            }
                                            in.close();
                                            throw var66_86;
                                        }
lbl124:
                                        // 1 sources

                                        try {
                                            n = 0;
                                            for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                                o = logWritersEntry.getValue();
                                                t1 = EnvironmentEdgeManager.currentTimeMillis();
                                                if (t1 - last_report_at > (long)period) {
                                                    last_report_at = t;
                                                    if (!progress_failed && reporter != null && !reporter.progress()) {
                                                        progress_failed = true;
                                                    }
                                                }
                                                if (o == BAD_WRITER) continue;
                                                ++n;
                                                wap = (WriterAndPath)o;
                                                wap.writerClosed = true;
                                                wap.w.close();
                                                HLogSplitter.LOG.debug((Object)("Closed " + wap.p));
                                                dst = HLogSplitter.getCompletedRecoveredEditsFilePath(wap.p, this.outputSink.getRegionMaximumEditLogSeqNum(logWritersEntry.getKey()));
                                                if (!dst.equals((Object)wap.p) && this.fs.exists(dst)) {
                                                    HLogSplitter.LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + dst + ", length=" + this.fs.getFileStatus(dst).getLen()));
                                                    if (!this.fs.delete(dst, false)) {
                                                        HLogSplitter.LOG.warn((Object)("Failed deleting of old " + dst));
                                                        throw new IOException("Failed deleting of old " + dst);
                                                    }
                                                }
                                                if (!this.fs.exists(wap.p)) continue;
                                                if (!this.fs.rename(wap.p, dst)) {
                                                    throw new IOException("Failed renaming " + wap.p + " to " + dst);
                                                }
                                                HLogSplitter.LOG.debug((Object)("Rename " + wap.p + " to " + dst));
                                            }
                                            allWritersClosed = true;
                                            msg = "Processed " + editsCount + " edits across " + n + " regions" + " threw away edits for " + (logWriters.size() - n) + " regions" + "; log file=" + logPath + " is corrupted = " + isCorrupted + " progress failed = " + progress_failed;
                                            HLogSplitter.LOG.info((Object)msg);
                                            this.status.markComplete(msg);
                                            if (allWritersClosed) break block77;
                                        }
                                        catch (Throwable var38_53) {
                                            if (!allWritersClosed) {
                                                for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                                    o = logWritersEntry.getValue();
                                                    if (o == BAD_WRITER) continue;
                                                    wap = (WriterAndPath)o;
                                                    try {
                                                        if (wap.writerClosed) continue;
                                                        wap.writerClosed = true;
                                                        wap.w.close();
                                                    }
                                                    catch (IOException e) {
                                                        HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                                    }
                                                }
                                            }
                                            in.close();
                                            throw var38_53;
                                        }
                                        for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                            o = logWritersEntry.getValue();
                                            if (o == BAD_WRITER) continue;
                                            wap = (WriterAndPath)o;
                                            try {
                                                if (wap.writerClosed) continue;
                                                wap.writerClosed = true;
                                                wap.w.close();
                                            }
                                            catch (IOException e) {
                                                HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                            }
                                        }
                                    }
                                    in.close();
                                    return var28_38;
lbl187:
                                    // 4 sources

                                    continue;
lbl188:
                                    // 1 sources

                                    allWritersClosed = false;
                                    try {
                                        n = 0;
                                        for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                            o = logWritersEntry.getValue();
                                            t1 = EnvironmentEdgeManager.currentTimeMillis();
                                            if (t1 - last_report_at > (long)period) {
                                                last_report_at = t;
                                                if (!progress_failed && reporter != null && !reporter.progress()) {
                                                    progress_failed = true;
                                                }
                                            }
                                            if (o == BAD_WRITER) continue;
                                            ++n;
                                            wap = (WriterAndPath)o;
                                            wap.writerClosed = true;
                                            wap.w.close();
                                            HLogSplitter.LOG.debug((Object)("Closed " + wap.p));
                                            dst = HLogSplitter.getCompletedRecoveredEditsFilePath(wap.p, this.outputSink.getRegionMaximumEditLogSeqNum(logWritersEntry.getKey()));
                                            if (!dst.equals((Object)wap.p) && this.fs.exists(dst)) {
                                                HLogSplitter.LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + dst + ", length=" + this.fs.getFileStatus(dst).getLen()));
                                                if (!this.fs.delete(dst, false)) {
                                                    HLogSplitter.LOG.warn((Object)("Failed deleting of old " + dst));
                                                    throw new IOException("Failed deleting of old " + dst);
                                                }
                                            }
                                            if (!this.fs.exists(wap.p)) continue;
                                            if (!this.fs.rename(wap.p, dst)) {
                                                throw new IOException("Failed renaming " + wap.p + " to " + dst);
                                            }
                                            HLogSplitter.LOG.debug((Object)("Rename " + wap.p + " to " + dst));
                                        }
                                        allWritersClosed = true;
                                        msg = "Processed " + editsCount + " edits across " + n + " regions" + " threw away edits for " + (logWriters.size() - n) + " regions" + "; log file=" + logPath + " is corrupted = " + isCorrupted + " progress failed = " + progress_failed;
                                        HLogSplitter.LOG.info((Object)msg);
                                        this.status.markComplete(msg);
                                        if (allWritersClosed) break block78;
                                    }
                                    catch (Throwable var44_63) {
                                        if (!allWritersClosed) {
                                            for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                                o = logWritersEntry.getValue();
                                                if (o == BAD_WRITER) continue;
                                                wap = (WriterAndPath)o;
                                                try {
                                                    if (wap.writerClosed) continue;
                                                    wap.writerClosed = true;
                                                    wap.w.close();
                                                }
                                                catch (IOException e) {
                                                    HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                                }
                                            }
                                        }
                                        in.close();
                                        throw var44_63;
                                    }
                                    for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                        o = logWritersEntry.getValue();
                                        if (o == BAD_WRITER) continue;
                                        wap = (WriterAndPath)o;
                                        try {
                                            if (wap.writerClosed) continue;
                                            wap.writerClosed = true;
                                            wap.w.close();
                                        }
                                        catch (IOException e) {
                                            HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                        }
                                    }
                                }
                                in.close();
                                break;
lbl251:
                                // 1 sources

                                try {
                                    n = 0;
                                    for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                        o = logWritersEntry.getValue();
                                        t1 = EnvironmentEdgeManager.currentTimeMillis();
                                        if (t1 - last_report_at > (long)period) {
                                            last_report_at = t;
                                            if (!progress_failed && reporter != null && !reporter.progress()) {
                                                progress_failed = true;
                                            }
                                        }
                                        if (o == BAD_WRITER) continue;
                                        ++n;
                                        wap = (WriterAndPath)o;
                                        wap.writerClosed = true;
                                        wap.w.close();
                                        HLogSplitter.LOG.debug((Object)("Closed " + wap.p));
                                        dst = HLogSplitter.getCompletedRecoveredEditsFilePath(wap.p, this.outputSink.getRegionMaximumEditLogSeqNum(logWritersEntry.getKey()));
                                        if (!dst.equals((Object)wap.p) && this.fs.exists(dst)) {
                                            HLogSplitter.LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + dst + ", length=" + this.fs.getFileStatus(dst).getLen()));
                                            if (!this.fs.delete(dst, false)) {
                                                HLogSplitter.LOG.warn((Object)("Failed deleting of old " + dst));
                                                throw new IOException("Failed deleting of old " + dst);
                                            }
                                        }
                                        if (!this.fs.exists(wap.p)) continue;
                                        if (!this.fs.rename(wap.p, dst)) {
                                            throw new IOException("Failed renaming " + wap.p + " to " + dst);
                                        }
                                        HLogSplitter.LOG.debug((Object)("Rename " + wap.p + " to " + dst));
                                    }
                                    allWritersClosed = true;
                                    msg = "Processed " + editsCount + " edits across " + n + " regions" + " threw away edits for " + (logWriters.size() - n) + " regions" + "; log file=" + logPath + " is corrupted = " + isCorrupted + " progress failed = " + progress_failed;
                                    HLogSplitter.LOG.info((Object)msg);
                                    this.status.markComplete(msg);
                                    if (allWritersClosed) break block79;
                                }
                                catch (Throwable var50_69) {
                                    if (!allWritersClosed) {
                                        for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                            o = logWritersEntry.getValue();
                                            if (o == BAD_WRITER) continue;
                                            wap = (WriterAndPath)o;
                                            try {
                                                if (wap.writerClosed) continue;
                                                wap.writerClosed = true;
                                                wap.w.close();
                                            }
                                            catch (IOException e) {
                                                HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                            }
                                        }
                                    }
                                    in.close();
                                    throw var50_69;
                                }
                                for (Map.Entry<byte[], V> logWritersEntry : logWriters.entrySet()) {
                                    o = logWritersEntry.getValue();
                                    if (o == BAD_WRITER) continue;
                                    wap = (WriterAndPath)o;
                                    try {
                                        if (wap.writerClosed) continue;
                                        wap.writerClosed = true;
                                        wap.w.close();
                                    }
                                    catch (IOException e) {
                                        HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                    }
                                }
                            }
                            in.close();
                            break;
                            catch (IOException e) {}
                            {
                                e = RemoteExceptionHandler.checkIOException(e);
                                throw e;
                            }
                            while (i$.hasNext()) {
                                logWritersEntry = i$.next();
                                o = logWritersEntry.getValue();
                                if (o == BAD_WRITER) continue;
                                wap = (WriterAndPath)o;
                                try {
                                    if (wap.writerClosed) continue;
                                    wap.writerClosed = true;
                                    wap.w.close();
                                }
                                catch (IOException e) {
                                    HLogSplitter.LOG.debug((Object)"Exception while closing the writer :", (Throwable)e);
                                }
                            }
                        }
                        in.close();
                        throw var56_75;
                    }
                }
            }
            break;
        }
        if (progress_failed != false) return false;
        return true;
    }

    public static void finishSplitLogFile(String logfile, Configuration conf) throws IOException {
        Path rootdir = FSUtils.getRootDir(conf);
        Path oldLogDir = new Path(rootdir, ".oldlogs");
        HLogSplitter.finishSplitLogFile(rootdir, oldLogDir, logfile, conf);
    }

    public static void finishSplitLogFile(Path rootdir, Path oldLogDir, String logfile, Configuration conf) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        FileSystem fs = rootdir.getFileSystem(conf);
        Path logPath = new Path(logfile);
        if (ZKSplitLog.isCorrupted(rootdir, logPath.getName(), fs)) {
            corruptedLogs.add(logPath);
        } else {
            processedLogs.add(logPath);
        }
        HLogSplitter.archiveLogs(null, corruptedLogs, processedLogs, oldLogDir, fs, conf);
        Path stagingDir = ZKSplitLog.getSplitLogDir(rootdir, logPath.getName());
        fs.delete(stagingDir, true);
    }

    private static void archiveLogs(Path srcDir, List<Path> corruptedLogs, List<Path> processedLogs, Path oldLogDir, FileSystem fs, Configuration conf) throws IOException {
        Path corruptDir = new Path(conf.get("hbase.rootdir"), conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir", ".corrupt"));
        if (!fs.mkdirs(corruptDir)) {
            LOG.info((Object)("Unable to mkdir " + corruptDir));
        }
        fs.mkdirs(oldLogDir);
        for (Path corrupted : corruptedLogs) {
            Path p = new Path(corruptDir, corrupted.getName());
            if (!fs.exists(corrupted)) continue;
            if (!fs.rename(corrupted, p)) {
                LOG.warn((Object)("Unable to move corrupted log " + corrupted + " to " + p));
                continue;
            }
            LOG.warn((Object)("Moving corrupted log " + corrupted + " to " + p));
        }
        for (Path p : processedLogs) {
            Path newPath = HLog.getHLogArchivePath(oldLogDir, p);
            if (!fs.exists(p)) continue;
            if (!fs.rename(p, newPath)) {
                LOG.warn((Object)("Unable to move  " + p + " to " + newPath));
                continue;
            }
            LOG.debug((Object)("Archived processed log " + p + " to " + newPath));
        }
        if (srcDir != null && !fs.delete(srcDir, true)) {
            throw new IOException("Unable to delete src dir: " + srcDir);
        }
    }

    static Path getRegionSplitEditsPath(FileSystem fs, HLog.Entry logEntry, Path rootDir, boolean isCreate) throws IOException {
        Path tableDir = HTableDescriptor.getTableDir(rootDir, logEntry.getKey().getTablename());
        String encodedRegionName = Bytes.toString(logEntry.getKey().getEncodedRegionName());
        Path regiondir = HRegion.getRegionDir(tableDir, encodedRegionName);
        Path dir = HLog.getRegionDirRecoveredEditsDir(regiondir);
        if (!fs.exists(regiondir)) {
            LOG.info((Object)("This region's directory doesn't exist: " + regiondir.toString() + ". It is very likely that it was" + " already split so it's safe to discard those edits."));
            return null;
        }
        if (fs.exists(dir) && fs.isFile(dir)) {
            Path tmp = new Path("/tmp");
            if (!fs.exists(tmp)) {
                fs.mkdirs(tmp);
            }
            tmp = new Path(tmp, "recovered.edits_" + encodedRegionName);
            LOG.warn((Object)("Found existing old file: " + dir + ". It could be some " + "leftover of an old installation. It should be a folder instead. " + "So moving it to " + tmp));
            if (!fs.rename(dir, tmp)) {
                LOG.warn((Object)("Failed to sideline old file " + dir));
            }
        }
        if (isCreate && !fs.exists(dir) && !fs.mkdirs(dir)) {
            LOG.warn((Object)("mkdir failed on " + dir));
        }
        String fileName = HLogSplitter.formatRecoveredEditsFileName(logEntry.getKey().getLogSeqNum());
        fileName = HLogSplitter.getTmpRecoveredEditsFileName(fileName);
        return new Path(dir, fileName);
    }

    static String getTmpRecoveredEditsFileName(String fileName) {
        return fileName + ".temp";
    }

    static Path getCompletedRecoveredEditsFilePath(Path srcPath, Long maximumEditLogSeqNum) {
        String fileName = HLogSplitter.formatRecoveredEditsFileName(maximumEditLogSeqNum);
        return new Path(srcPath.getParent(), fileName);
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    private void parseHLog(HLog.Reader in, Path path, EntryBuffers entryBuffers, FileSystem fs, Configuration conf, boolean skipErrors) throws IOException, CorruptedLogFileException {
        int editsCount = 0;
        try {
            HLog.Entry entry;
            while ((entry = HLogSplitter.getNextLogLine(in, path, skipErrors)) != null) {
                entryBuffers.appendEntry(entry);
                ++editsCount;
            }
        }
        catch (InterruptedException ie) {
            InterruptedIOException t = new InterruptedIOException();
            t.initCause(ie);
            throw t;
        }
        finally {
            LOG.debug((Object)("Pushed=" + editsCount + " entries from " + path));
        }
    }

    protected HLog.Reader getReader(FileSystem fs, FileStatus file, Configuration conf, boolean skipErrors) throws IOException, CorruptedLogFileException {
        HLog.Reader in;
        Path path = file.getPath();
        long length = file.getLen();
        if (length <= 0L) {
            LOG.warn((Object)("File " + path + " might be still open, length is 0"));
        }
        try {
            FSUtils.getInstance(fs, conf).recoverFileLease(fs, path, conf);
            try {
                in = this.getReader(fs, path, conf);
            }
            catch (EOFException e) {
                if (length <= 0L) {
                    LOG.warn((Object)("Could not open " + path + " for reading. File is empty"), (Throwable)e);
                    return null;
                }
                return null;
            }
        }
        catch (IOException e) {
            if (!skipErrors) {
                throw e;
            }
            CorruptedLogFileException t = new CorruptedLogFileException("skipErrors=true Could not open hlog " + path + " ignoring");
            t.initCause(e);
            throw t;
        }
        return in;
    }

    private static HLog.Entry getNextLogLine(HLog.Reader in, Path path, boolean skipErrors) throws CorruptedLogFileException, IOException {
        try {
            return in.next();
        }
        catch (EOFException eof) {
            LOG.info((Object)("EOF from hlog " + path + ".  continuing"));
            return null;
        }
        catch (IOException e) {
            if (e.getCause() != null && (e.getCause() instanceof ParseException || e.getCause() instanceof ChecksumException)) {
                LOG.warn((Object)("Parse exception " + e.getCause().toString() + " from hlog " + path + ".  continuing"));
                return null;
            }
            if (!skipErrors) {
                throw e;
            }
            CorruptedLogFileException t = new CorruptedLogFileException("skipErrors=true Ignoring exception while parsing hlog " + path + ". Marking as corrupted");
            t.initCause(e);
            throw t;
        }
    }

    private void writerThreadError(Throwable t) {
        this.thrown.compareAndSet(null, t);
    }

    private void checkForErrors() throws IOException {
        Throwable thrown = this.thrown.get();
        if (thrown == null) {
            return;
        }
        if (thrown instanceof IOException) {
            throw (IOException)thrown;
        }
        throw new RuntimeException(thrown);
    }

    protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
        return HLog.createWriter(fs, logfile, conf);
    }

    protected HLog.Reader getReader(FileSystem fs, Path curLogFile, Configuration conf) throws IOException {
        return HLog.getReader(fs, curLogFile, conf);
    }

    private WriterAndPath createWAP(byte[] region, HLog.Entry entry, Path rootdir, FileSystem fs, Configuration conf) throws IOException {
        Path regionedits = HLogSplitter.getRegionSplitEditsPath(fs, entry, rootdir, true);
        if (regionedits == null) {
            return null;
        }
        if (fs.exists(regionedits)) {
            LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + regionedits + ", length=" + fs.getFileStatus(regionedits).getLen()));
            if (!fs.delete(regionedits, false)) {
                LOG.warn((Object)("Failed delete of old " + regionedits));
            }
        }
        HLog.Writer w = this.createWriter(fs, regionedits, conf);
        LOG.debug((Object)("Creating writer path=" + regionedits + " region=" + Bytes.toStringBinary(region)));
        return new WriterAndPath(regionedits, w);
    }

    Path convertRegionEditsToTemp(Path rootdir, Path edits, String tmpname) {
        ArrayList<String> components = new ArrayList<String>(10);
        do {
            components.add(edits.getName());
        } while ((edits = edits.getParent()).depth() > rootdir.depth());
        Path ret = ZKSplitLog.getSplitLogDir(rootdir, tmpname);
        for (int i = components.size() - 1; i >= 0; --i) {
            ret = new Path(ret, (String)components.get(i));
        }
        try {
            Path dir;
            if (this.fs.exists(ret)) {
                LOG.warn((Object)("Found existing old temporary edits file. It could be the result of a previous failed split attempt. Deleting " + ret + ", length=" + this.fs.getFileStatus(ret).getLen()));
                if (!this.fs.delete(ret, false)) {
                    LOG.warn((Object)("Failed delete of old " + ret));
                }
            }
            if (!this.fs.exists(dir = ret.getParent()) && !this.fs.mkdirs(dir)) {
                LOG.warn((Object)("mkdir failed on " + dir));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not prepare temp staging area ", (Throwable)e);
        }
        return ret;
    }

    static class CorruptedLogFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CorruptedLogFileException(String s) {
            super(s);
        }
    }

    private static final class WriterAndPath {
        final Path p;
        final HLog.Writer w;
        long editsWritten = 0L;
        long nanosSpent = 0L;
        boolean writerClosed = false;

        WriterAndPath(Path p, HLog.Writer w) {
            this.p = p;
            this.w = w;
        }

        void incrementEdits(int edits) {
            this.editsWritten += (long)edits;
        }

        void incrementNanoTime(long nanos) {
            this.nanosSpent += nanos;
        }
    }

    class OutputSink {
        private final Map<byte[], WriterAndPath> logWriters = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        private final Map<byte[], Long> regionMaximumEditLogSeqNum = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        private final List<WriterThread> writerThreads = Lists.newArrayList();
        private final Set<byte[]> blacklistedRegions = Collections.synchronizedSet(new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR));
        private boolean closeAndCleanCompleted = false;
        private boolean logWritersClosed = false;

        OutputSink() {
        }

        synchronized void startWriterThreads(EntryBuffers entryBuffers) {
            int numThreads = HLogSplitter.this.conf.getInt("hbase.regionserver.hlog.splitlog.writer.threads", 3);
            for (int i = 0; i < numThreads; ++i) {
                WriterThread t = new WriterThread(i);
                t.start();
                this.writerThreads.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Path> finishWritingAndClose() throws IOException {
            LOG.info((Object)"Waiting for split writer threads to finish");
            try {
                for (WriterThread t : this.writerThreads) {
                    t.finish();
                }
                for (WriterThread t : this.writerThreads) {
                    try {
                        t.join();
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(ie);
                    }
                    HLogSplitter.this.checkForErrors();
                }
                LOG.info((Object)"Split writers finished");
                List<Path> list = this.closeStreams();
                return list;
            }
            finally {
                List<IOException> thrown = this.closeLogWriters(null);
                if (thrown != null && !thrown.isEmpty()) {
                    throw MultipleIOException.createIOException(thrown);
                }
            }
        }

        private List<Path> closeStreams() throws IOException {
            Preconditions.checkState((!this.closeAndCleanCompleted ? 1 : 0) != 0);
            ArrayList<Path> paths = new ArrayList<Path>();
            ArrayList thrown = Lists.newArrayList();
            this.closeLogWriters(thrown);
            for (Map.Entry<byte[], WriterAndPath> logWritersEntry : this.logWriters.entrySet()) {
                Path dst;
                block7: {
                    WriterAndPath wap = logWritersEntry.getValue();
                    dst = HLogSplitter.getCompletedRecoveredEditsFilePath(wap.p, this.regionMaximumEditLogSeqNum.get(logWritersEntry.getKey()));
                    try {
                        if (!dst.equals((Object)wap.p) && HLogSplitter.this.fs.exists(dst)) {
                            LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + dst + ", length=" + HLogSplitter.this.fs.getFileStatus(dst).getLen()));
                            if (!HLogSplitter.this.fs.delete(dst, false)) {
                                LOG.warn((Object)("Failed deleting of old " + dst));
                                throw new IOException("Failed deleting of old " + dst);
                            }
                        }
                        if (!HLogSplitter.this.fs.exists(wap.p)) break block7;
                        if (!HLogSplitter.this.fs.rename(wap.p, dst)) {
                            throw new IOException("Failed renaming " + wap.p + " to " + dst);
                        }
                        LOG.debug((Object)("Rename " + wap.p + " to " + dst));
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)("Couldn't rename " + wap.p + " to " + dst), (Throwable)ioe);
                        thrown.add(ioe);
                        continue;
                    }
                }
                paths.add(dst);
            }
            if (!thrown.isEmpty()) {
                throw MultipleIOException.createIOException((List)thrown);
            }
            this.closeAndCleanCompleted = true;
            return paths;
        }

        private List<IOException> closeLogWriters(List<IOException> thrown) throws IOException {
            if (!this.logWritersClosed) {
                if (thrown == null) {
                    thrown = Lists.newArrayList();
                }
                for (WriterAndPath wap : this.logWriters.values()) {
                    try {
                        wap.w.close();
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)("Couldn't close log at " + wap.p), (Throwable)ioe);
                        thrown.add(ioe);
                        continue;
                    }
                    LOG.info((Object)("Closed path " + wap.p + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)"));
                }
                this.logWritersClosed = true;
            }
            return thrown;
        }

        WriterAndPath getWriterAndPath(HLog.Entry entry) throws IOException {
            byte[] region = entry.getKey().getEncodedRegionName();
            WriterAndPath ret = this.logWriters.get(region);
            if (ret != null) {
                return ret;
            }
            if (this.blacklistedRegions.contains(region)) {
                return null;
            }
            ret = HLogSplitter.this.createWAP(region, entry, HLogSplitter.this.rootDir, HLogSplitter.this.fs, HLogSplitter.this.conf);
            if (ret == null) {
                this.blacklistedRegions.add(region);
                return null;
            }
            this.logWriters.put(region, ret);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateRegionMaximumEditLogSeqNum(HLog.Entry entry) {
            Map<byte[], Long> map = this.regionMaximumEditLogSeqNum;
            synchronized (map) {
                Long currentMaxSeqNum = this.regionMaximumEditLogSeqNum.get(entry.getKey().getEncodedRegionName());
                if (currentMaxSeqNum == null || entry.getKey().getLogSeqNum() > currentMaxSeqNum) {
                    this.regionMaximumEditLogSeqNum.put(entry.getKey().getEncodedRegionName(), entry.getKey().getLogSeqNum());
                }
            }
        }

        Long getRegionMaximumEditLogSeqNum(byte[] region) {
            return this.regionMaximumEditLogSeqNum.get(region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<byte[], Long> getOutputCounts() {
            TreeMap<byte[], Long> ret = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            Map<byte[], WriterAndPath> map = this.logWriters;
            synchronized (map) {
                for (Map.Entry<byte[], WriterAndPath> entry : this.logWriters.entrySet()) {
                    ret.put(entry.getKey(), entry.getValue().editsWritten);
                }
            }
            return ret;
        }
    }

    class WriterThread
    extends Thread {
        private volatile boolean shouldStop;

        WriterThread(int i) {
            super("WriterThread-" + i);
            this.shouldStop = false;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in log splitting write thread", t);
                HLogSplitter.this.writerThreadError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws IOException {
            LOG.debug((Object)("Writer thread " + this + ": starting"));
            while (true) {
                RegionEntryBuffer buffer;
                if ((buffer = HLogSplitter.this.entryBuffers.getChunkToWrite()) == null) {
                    Object object = HLogSplitter.this.dataAvailable;
                    synchronized (object) {
                        block12: {
                            if (this.shouldStop) {
                                return;
                            }
                            try {
                                HLogSplitter.this.dataAvailable.wait(1000L);
                            }
                            catch (InterruptedException ie) {
                                if (this.shouldStop) break block12;
                                throw new RuntimeException(ie);
                            }
                        }
                    }
                }
                assert (buffer != null);
                try {
                    this.writeBuffer(buffer);
                    continue;
                }
                finally {
                    HLogSplitter.this.entryBuffers.doneWriting(buffer);
                    continue;
                }
                break;
            }
        }

        private void writeBuffer(RegionEntryBuffer buffer) throws IOException {
            List<HLog.Entry> entries = buffer.entryBuffer;
            if (entries.isEmpty()) {
                LOG.warn((Object)(this.getName() + " got an empty buffer, skipping"));
                return;
            }
            WriterAndPath wap = null;
            long startTime = System.nanoTime();
            try {
                int editsCount = 0;
                for (HLog.Entry logEntry : entries) {
                    if (wap == null && (wap = HLogSplitter.this.outputSink.getWriterAndPath(logEntry)) == null) {
                        return;
                    }
                    wap.w.append(logEntry);
                    HLogSplitter.this.outputSink.updateRegionMaximumEditLogSeqNum(logEntry);
                    ++editsCount;
                }
                wap.incrementEdits(editsCount);
                wap.incrementNanoTime(System.nanoTime() - startTime);
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException(e);
                LOG.fatal((Object)(this.getName() + " Got while writing log entry to log"), (Throwable)e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish() {
            Object object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.shouldStop = true;
                HLogSplitter.this.dataAvailable.notifyAll();
            }
        }
    }

    static class RegionEntryBuffer
    implements HeapSize {
        long heapInBuffer = 0L;
        List<HLog.Entry> entryBuffer;
        byte[] tableName;
        byte[] encodedRegionName;

        RegionEntryBuffer(byte[] table, byte[] region) {
            this.tableName = table;
            this.encodedRegionName = region;
            this.entryBuffer = new LinkedList<HLog.Entry>();
        }

        long appendEntry(HLog.Entry entry) {
            this.internify(entry);
            this.entryBuffer.add(entry);
            long incrHeap = entry.getEdit().heapSize() + (long)ClassSize.align(2 * ClassSize.REFERENCE) + 0L;
            this.heapInBuffer += incrHeap;
            return incrHeap;
        }

        private void internify(HLog.Entry entry) {
            HLogKey k = entry.getKey();
            k.internTableName(this.tableName);
            k.internEncodedRegionName(this.encodedRegionName);
        }

        @Override
        public long heapSize() {
            return this.heapInBuffer;
        }
    }

    class EntryBuffers {
        Map<byte[], RegionEntryBuffer> buffers = new TreeMap<byte[], RegionEntryBuffer>(Bytes.BYTES_COMPARATOR);
        Set<byte[]> currentlyWriting = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        long totalBuffered = 0L;
        long maxHeapUsage;

        EntryBuffers(long maxHeapUsage) {
            this.maxHeapUsage = maxHeapUsage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void appendEntry(HLog.Entry entry) throws InterruptedException, IOException {
            long incrHeap;
            HLogKey key = entry.getKey();
            Object object = this;
            synchronized (object) {
                RegionEntryBuffer buffer = this.buffers.get(key.getEncodedRegionName());
                if (buffer == null) {
                    buffer = new RegionEntryBuffer(key.getTablename(), key.getEncodedRegionName());
                    this.buffers.put(key.getEncodedRegionName(), buffer);
                }
                incrHeap = buffer.appendEntry(entry);
            }
            object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.totalBuffered += incrHeap;
                while (this.totalBuffered > this.maxHeapUsage && HLogSplitter.this.thrown.get() == null) {
                    LOG.debug((Object)("Used " + this.totalBuffered + " bytes of buffered edits, waiting for IO threads..."));
                    HLogSplitter.this.dataAvailable.wait(3000L);
                }
                HLogSplitter.this.dataAvailable.notifyAll();
            }
            HLogSplitter.this.checkForErrors();
        }

        synchronized RegionEntryBuffer getChunkToWrite() {
            long biggestSize = 0L;
            byte[] biggestBufferKey = null;
            for (Map.Entry<byte[], RegionEntryBuffer> entry : this.buffers.entrySet()) {
                long size = entry.getValue().heapSize();
                if (size <= biggestSize || this.currentlyWriting.contains(entry.getKey())) continue;
                biggestSize = size;
                biggestBufferKey = entry.getKey();
            }
            if (biggestBufferKey == null) {
                return null;
            }
            RegionEntryBuffer buffer = this.buffers.remove(biggestBufferKey);
            this.currentlyWriting.add(biggestBufferKey);
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doneWriting(RegionEntryBuffer buffer) {
            EntryBuffers entryBuffers = this;
            synchronized (entryBuffers) {
                boolean removed = this.currentlyWriting.remove(buffer.encodedRegionName);
                assert (removed);
            }
            long size = buffer.heapSize();
            Object object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.totalBuffered -= size;
                HLogSplitter.this.dataAvailable.notifyAll();
            }
        }

        synchronized boolean isRegionCurrentlyWriting(byte[] region) {
            return this.currentlyWriting.contains(region);
        }
    }
}

