/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationPeer
implements Abortable {
    private static final Log LOG = LogFactory.getLog(ReplicationPeer.class);
    private final String clusterKey;
    private final String id;
    private List<ServerName> regionServers = new ArrayList<ServerName>(0);
    private final AtomicBoolean peerEnabled = new AtomicBoolean();
    private ZooKeeperWatcher zkw;
    private final Configuration conf;
    private PeerStateTracker peerStateTracker;

    public ReplicationPeer(Configuration conf, String key, String id) throws IOException {
        this.conf = conf;
        this.clusterKey = key;
        this.id = id;
        this.reloadZkWatcher();
    }

    public void startStateTracker(ZooKeeperWatcher zookeeper, String peerStateNode) throws KeeperException {
        if (ZKUtil.checkExists(zookeeper, peerStateNode) == -1) {
            ZKUtil.createNodeIfNotExistsAndWatch(zookeeper, peerStateNode, Bytes.toBytes(ReplicationZookeeper.PeerState.ENABLED.name()));
        }
        this.peerStateTracker = new PeerStateTracker(peerStateNode, zookeeper, this);
        this.peerStateTracker.start();
        this.readPeerStateZnode();
    }

    private void readPeerStateZnode() {
        String currentState = Bytes.toString(this.peerStateTracker.getData(false));
        this.peerEnabled.set(ReplicationZookeeper.PeerState.ENABLED.equals((Object)ReplicationZookeeper.PeerState.valueOf(currentState)));
    }

    public String getClusterKey() {
        return this.clusterKey;
    }

    public AtomicBoolean getPeerEnabled() {
        return this.peerEnabled;
    }

    public List<ServerName> getRegionServers() {
        return this.regionServers;
    }

    public void setRegionServers(List<ServerName> regionServers) {
        this.regionServers = regionServers;
    }

    public ZooKeeperWatcher getZkw() {
        return this.zkw;
    }

    public String getId() {
        return this.id;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.warn((Object)("The ReplicationPeer coresponding to peer " + this.clusterKey + " was aborted for the following reason(s):" + why), e);
    }

    public void reloadZkWatcher() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        this.zkw = new ZooKeeperWatcher(this.conf, "connection to cluster: " + this.id, this);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    public class PeerStateTracker
    extends ZooKeeperNodeTracker {
        public PeerStateTracker(String peerStateZNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, peerStateZNode, abortable);
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
                ReplicationPeer.this.readPeerStateZnode();
            }
        }
    }
}

