/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.HLog;

@InterfaceAudience.Private
public class ReplicationHLogReaderManager {
    private static final Log LOG = LogFactory.getLog(ReplicationHLogReaderManager.class);
    private final FileSystem fs;
    private final Configuration conf;
    private long position = 0L;
    private HLog.Reader reader;
    private Path lastPath;

    public ReplicationHLogReaderManager(FileSystem fs, Configuration conf) {
        this.fs = fs;
        this.conf = conf;
    }

    public HLog.Reader openReader(Path path) throws IOException {
        if (this.reader == null || !this.lastPath.equals((Object)path)) {
            this.reader = HLog.getReader(this.fs, path, this.conf);
            this.lastPath = path;
        } else {
            this.reader.reset();
        }
        return this.reader;
    }

    public HLog.Entry readNextAndSetPosition(HLog.Entry[] entriesArray, int currentNbEntries) throws IOException {
        HLog.Entry entry = this.reader.next(entriesArray[currentNbEntries]);
        this.position = this.reader.getPosition();
        if (entry != null) {
            entry.setCompressionContext(null);
        }
        return entry;
    }

    public void seek() throws IOException {
        if (this.position != 0L) {
            this.reader.seek(this.position);
        }
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public void closeReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void finishCurrentFile() {
        this.position = 0L;
        this.reader = null;
    }
}

