/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;

public class ReplicationSink {
    private static final Log LOG = LogFactory.getLog(ReplicationSink.class);
    public static final String REPLICATION_LOG_DIR = ".replogs";
    private final Configuration conf;
    private final ExecutorService sharedThreadPool;
    private final HConnection sharedHtableCon;
    private final ReplicationSinkMetrics metrics;
    private final AtomicLong totalReplicatedEdits = new AtomicLong();

    public ReplicationSink(Configuration conf, Stoppable stopper) throws IOException {
        this.conf = HBaseConfiguration.create(conf);
        this.decorateConf();
        this.sharedHtableCon = HConnectionManager.createConnection(this.conf);
        this.sharedThreadPool = new ThreadPoolExecutor(1, conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE), conf.getLong("hbase.htable.threads.keepalivetime", 60L), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory("hbase-repl"));
        ((ThreadPoolExecutor)this.sharedThreadPool).allowCoreThreadTimeOut(true);
        this.metrics = new ReplicationSinkMetrics();
    }

    private void decorateConf() {
        this.conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, this.conf.getInt("replication.sink.client.retries.number", 4));
        this.conf.setInt("hbase.client.operation.timeout", this.conf.getInt("replication.sink.client.ops.timeout", 10000));
    }

    public void replicateEntries(HLog.Entry[] entries) throws IOException {
        if (entries.length == 0) {
            return;
        }
        try {
            long totalReplicated = 0L;
            TreeMap rows = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (HLog.Entry entry : entries) {
                WALEdit edit = entry.getEdit();
                byte[] table = entry.getKey().getTablename();
                Put put2 = null;
                Delete del = null;
                KeyValue lastKV = null;
                List<KeyValue> kvs = edit.getKeyValues();
                for (KeyValue kv : kvs) {
                    if (lastKV == null || lastKV.getType() != kv.getType() || !lastKV.matchingRow(kv)) {
                        if (kv.isDelete()) {
                            del = new Delete(kv.getRow());
                            del.setClusterId(entry.getKey().getClusterId());
                            this.addToMultiMap(rows, table, del);
                        } else {
                            put2 = new Put(kv.getRow());
                            put2.setClusterId(entry.getKey().getClusterId());
                            this.addToMultiMap(rows, table, put2);
                        }
                    }
                    if (kv.isDelete()) {
                        del.addDeleteMarker(kv);
                    } else {
                        put2.add(kv);
                    }
                    lastKV = kv;
                }
                ++totalReplicated;
            }
            for (byte[] table : rows.keySet()) {
                this.batch(table, (List)rows.get(table));
            }
            this.metrics.setAgeOfLastAppliedOp(entries[entries.length - 1].getKey().getWriteTime());
            this.metrics.appliedBatchesRate.inc(1);
            this.totalReplicatedEdits.addAndGet(totalReplicated);
        }
        catch (IOException ex) {
            LOG.error((Object)"Unable to accept edit because:", (Throwable)ex);
            throw ex;
        }
    }

    private <K, V> List<V> addToMultiMap(Map<K, List<V>> map, K key, V value) {
        List<V> values = map.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            map.put(key, values);
        }
        values.add(value);
        return values;
    }

    public void stopReplicationSinkServices() {
        try {
            this.sharedThreadPool.shutdown();
            if (!this.sharedThreadPool.awaitTermination(60000L, TimeUnit.MILLISECONDS)) {
                this.sharedThreadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while closing the table pool", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.sharedHtableCon.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException while closing the connection", (Throwable)e);
        }
    }

    private void batch(byte[] tableName, List<Row> rows) throws IOException {
        if (rows.isEmpty()) {
            return;
        }
        HTableInterface table = null;
        try {
            table = new HTable(tableName, this.sharedHtableCon, this.sharedThreadPool);
            table.batch(rows);
            this.metrics.appliedOpsRate.inc(rows.size());
        }
        catch (InterruptedException ix) {
            throw new IOException(ix);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    public String getStats() {
        return this.totalReplicatedEdits.get() == 0L ? "" : "Sink: age in ms of last applied edit: " + this.metrics.refreshAgeOfLastAppliedOp() + ", total replicated edits: " + this.totalReplicatedEdits;
    }
}

