/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationHLogReaderManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

public class ReplicationSource
extends Thread
implements ReplicationSourceInterface {
    private static final Log LOG = LogFactory.getLog(ReplicationSource.class);
    private PriorityBlockingQueue<Path> queue;
    private HLog.Entry[] entriesArray;
    private HConnection conn;
    private ReplicationZookeeper zkHelper;
    private Configuration conf;
    private float ratio;
    private Random random;
    private AtomicBoolean replicating;
    private String peerId;
    private ReplicationSourceManager manager;
    private Stoppable stopper;
    private List<ServerName> currentPeers;
    private long sleepForRetries;
    private long replicationQueueSizeCapacity;
    private int replicationQueueNbCapacity;
    private HLog.Reader reader;
    private long lastLoggedPosition = -1L;
    private volatile Path currentPath;
    private FileSystem fs;
    private UUID clusterId;
    private UUID peerClusterId;
    private long totalReplicatedEdits = 0L;
    private String peerClusterZnode;
    private boolean queueRecovered;
    private String[] deadRegionServers;
    private int maxRetriesMultiplier;
    private int socketTimeoutMultiplier;
    private int currentNbEntries = 0;
    private int currentNbOperations = 0;
    private int currentSize = 0;
    private volatile boolean running = true;
    private ReplicationSourceMetrics metrics;
    private ReplicationHLogReaderManager repLogReader;

    @Override
    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, Stoppable stopper, AtomicBoolean replicating, String peerClusterZnode) throws IOException {
        this.stopper = stopper;
        this.conf = conf;
        this.replicationQueueSizeCapacity = this.conf.getLong("replication.source.size.capacity", 0x4000000L);
        this.replicationQueueNbCapacity = this.conf.getInt("replication.source.nb.capacity", 25000);
        this.entriesArray = new HLog.Entry[this.replicationQueueNbCapacity];
        for (int i = 0; i < this.replicationQueueNbCapacity; ++i) {
            this.entriesArray[i] = new HLog.Entry();
        }
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 10);
        this.socketTimeoutMultiplier = this.maxRetriesMultiplier * this.maxRetriesMultiplier;
        this.queue = new PriorityBlockingQueue<Path>(conf.getInt("hbase.regionserver.maxlogs", 32), new LogsComparator());
        this.conn = HConnectionManager.getConnection(conf);
        this.zkHelper = manager.getRepZkWrapper();
        this.ratio = this.conf.getFloat("replication.source.ratio", 0.1f);
        this.currentPeers = new ArrayList<ServerName>();
        this.random = new Random();
        this.replicating = replicating;
        this.manager = manager;
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.fs = fs;
        this.metrics = new ReplicationSourceMetrics(peerClusterZnode);
        this.repLogReader = new ReplicationHLogReaderManager(this.fs, this.conf);
        try {
            this.clusterId = this.zkHelper.getUUIDForCluster(this.zkHelper.getZookeeperWatcher());
        }
        catch (KeeperException ke) {
            throw new IOException("Could not read cluster id", ke);
        }
        this.checkIfQueueRecovered(peerClusterZnode);
    }

    private void checkIfQueueRecovered(String peerClusterZnode) {
        String[] parts = peerClusterZnode.split("-");
        this.queueRecovered = parts.length != 1;
        this.peerId = this.queueRecovered ? parts[0] : peerClusterZnode;
        this.peerClusterZnode = peerClusterZnode;
        this.deadRegionServers = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            this.deadRegionServers[i - 1] = parts[i];
        }
    }

    private void chooseSinks() {
        this.currentPeers.clear();
        List<ServerName> addresses = this.zkHelper.getSlavesAddresses(this.peerId);
        HashSet<ServerName> setOfAddr = new HashSet<ServerName>();
        int nbPeers = (int)Math.ceil((float)addresses.size() * this.ratio);
        LOG.info((Object)("Getting " + nbPeers + " rs from peer cluster # " + this.peerId));
        for (int i = 0; i < nbPeers; ++i) {
            ServerName sn;
            while (setOfAddr.contains(sn = addresses.get(this.random.nextInt(addresses.size())))) {
            }
            LOG.info((Object)("Choosing peer " + sn));
            setOfAddr.add(sn);
        }
        this.currentPeers.addAll(setOfAddr);
    }

    @Override
    public void enqueueLog(Path log) {
        this.queue.put(log);
        this.metrics.sizeOfLogQueue.set(this.queue.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.connectToPeers();
        if (!this.isActive()) {
            return;
        }
        int sleepMultiplier = 1;
        while (this.peerClusterId == null) {
            this.peerClusterId = this.zkHelper.getPeerUUID(this.peerId);
            if (this.peerClusterId != null || !this.sleepForRetries("Cannot contact the peer's zk ensemble", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
        sleepMultiplier = 1;
        LOG.info((Object)("Replicating " + this.clusterId + " -> " + this.peerClusterId));
        if (this.queueRecovered) {
            try {
                this.repLogReader.setPosition(this.zkHelper.getHLogRepPosition(this.peerClusterZnode, this.queue.peek().getName()));
            }
            catch (KeeperException e) {
                this.terminate("Couldn't get the position of this recovered queue " + this.peerClusterZnode, (Exception)((Object)e));
            }
        }
        while (this.isActive()) {
            boolean gotIOE;
            boolean currentWALisBeingWrittenTo;
            block40: {
                if (!this.isPeerEnabled()) {
                    if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                Path oldPath = this.getCurrentPath();
                boolean hasCurrentPath = this.getNextPath();
                if (this.getCurrentPath() != null && oldPath == null) {
                    sleepMultiplier = 1;
                }
                if (!hasCurrentPath) {
                    if (!this.sleepForRetries("No log to process", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                currentWALisBeingWrittenTo = false;
                if (!this.queueRecovered && this.queue.size() == 0) {
                    currentWALisBeingWrittenTo = true;
                }
                if (!this.openReader(sleepMultiplier)) {
                    sleepMultiplier = 1;
                    continue;
                }
                if (this.reader == null) {
                    if (!this.sleepForRetries("Unable to open a reader", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                gotIOE = false;
                this.currentNbEntries = 0;
                this.currentSize = 0;
                try {
                    if (this.readAllEntriesToReplicateOrNextFile(currentWALisBeingWrittenTo)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)(this.peerClusterZnode + " Got: "), (Throwable)ioe);
                    gotIOE = true;
                    if (!(ioe.getCause() instanceof EOFException)) break block40;
                    boolean considerDumping = false;
                    if (this.queueRecovered) {
                        try {
                            FileStatus stat = this.fs.getFileStatus(this.currentPath);
                            if (stat.getLen() == 0L) {
                                LOG.warn((Object)(this.peerClusterZnode + " Got EOF and the file was empty"));
                            }
                            considerDumping = true;
                        }
                        catch (IOException e) {
                            LOG.warn((Object)(this.peerClusterZnode + " Got while getting file size: "), (Throwable)e);
                        }
                    } else if (this.currentNbEntries != 0) {
                        LOG.warn((Object)(this.peerClusterZnode + " Got EOF while reading, " + "looks like this file is broken? " + this.currentPath));
                        considerDumping = true;
                        this.currentNbEntries = 0;
                    }
                    if (considerDumping && sleepMultiplier == this.maxRetriesMultiplier && this.processEndOfFile()) {
                        continue;
                    }
                }
                finally {
                    try {
                        this.repLogReader.closeReader();
                    }
                    catch (IOException e) {
                        gotIOE = true;
                        LOG.warn((Object)"Unable to finalize the tailing of a file", (Throwable)e);
                    }
                    continue;
                }
            }
            if (this.isActive() && (gotIOE || this.currentNbEntries == 0)) {
                if (this.lastLoggedPosition != this.repLogReader.getPosition()) {
                    this.manager.logPositionAndCleanOldLogs(this.currentPath, this.peerClusterZnode, this.repLogReader.getPosition(), this.queueRecovered, currentWALisBeingWrittenTo);
                    this.lastLoggedPosition = this.repLogReader.getPosition();
                }
                if (!this.sleepForRetries("Nothing to replicate", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            sleepMultiplier = 1;
            this.shipEdits(currentWALisBeingWrittenTo);
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (IOException e) {
                LOG.debug((Object)"Attempt to close connection failed", (Throwable)e);
            }
        }
        LOG.debug((Object)("Source exiting " + this.peerId));
    }

    protected boolean readAllEntriesToReplicateOrNextFile(boolean currentWALisBeingWrittenTo) throws IOException {
        long seenEntries = 0L;
        this.repLogReader.seek();
        HLog.Entry entry = this.repLogReader.readNextAndSetPosition(this.entriesArray, this.currentNbEntries);
        while (entry != null) {
            WALEdit edit = entry.getEdit();
            this.metrics.logEditsReadRate.inc(1);
            ++seenEntries;
            HLogKey logKey = entry.getKey();
            if (!logKey.getClusterId().equals(this.peerClusterId)) {
                this.removeNonReplicableEdits(edit);
                if (!Bytes.equals(logKey.getTablename(), HConstants.ROOT_TABLE_NAME) && !Bytes.equals(logKey.getTablename(), HConstants.META_TABLE_NAME) && edit.size() != 0 && this.replicating.get()) {
                    if (HConstants.DEFAULT_CLUSTER_ID == logKey.getClusterId()) {
                        logKey.setClusterId(this.clusterId);
                    }
                    this.currentNbOperations += this.countDistinctRowKeys(edit);
                    ++this.currentNbEntries;
                    this.currentSize = (int)((long)this.currentSize + entry.getEdit().heapSize());
                } else {
                    this.metrics.logEditsFilteredRate.inc(1);
                }
            }
            if ((long)this.currentSize >= this.replicationQueueSizeCapacity || this.currentNbEntries >= this.replicationQueueNbCapacity) break;
            try {
                entry = this.repLogReader.readNextAndSetPosition(this.entriesArray, this.currentNbEntries);
            }
            catch (IOException ie) {
                LOG.debug((Object)("Break on IOE: " + ie.getMessage()));
                break;
            }
        }
        if (currentWALisBeingWrittenTo) {
            return false;
        }
        return seenEntries == 0L && this.processEndOfFile();
    }

    private void connectToPeers() {
        while (this.isActive() && this.currentPeers.size() == 0) {
            try {
                this.chooseSinks();
                Thread.sleep(this.sleepForRetries);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted while trying to connect to sinks", (Throwable)e);
            }
        }
    }

    protected boolean getNextPath() {
        try {
            if (this.currentPath == null) {
                this.currentPath = this.queue.poll(this.sleepForRetries, TimeUnit.MILLISECONDS);
                this.metrics.sizeOfLogQueue.set(this.queue.size());
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while reading edits", (Throwable)e);
        }
        return this.currentPath != null;
    }

    protected boolean openReader(int sleepMultiplier) {
        block8: {
            try {
                try {
                    this.reader = this.repLogReader.openReader(this.currentPath);
                }
                catch (FileNotFoundException fnfe) {
                    if (this.queueRecovered) {
                        LOG.info((Object)("NB dead servers : " + this.deadRegionServers.length));
                        for (int i = this.deadRegionServers.length - 1; i >= 0; --i) {
                            Path[] locs;
                            Path deadRsDirectory = new Path(this.manager.getLogDir().getParent(), this.deadRegionServers[i]);
                            for (Path possibleLogLocation : locs = new Path[]{new Path(deadRsDirectory, this.currentPath.getName()), new Path(deadRsDirectory.suffix("-splitting"), this.currentPath.getName())}) {
                                LOG.info((Object)("Possible location " + possibleLogLocation.toUri().toString()));
                                if (!this.manager.getFs().exists(possibleLogLocation)) continue;
                                LOG.info((Object)("Log " + this.currentPath + " still exists at " + possibleLogLocation));
                                return true;
                            }
                        }
                        throw new IOException("File from recovered queue is nowhere to be found", fnfe);
                    }
                    Path archivedLogLocation = new Path(this.manager.getOldLogDir(), this.currentPath.getName());
                    if (this.manager.getFs().exists(archivedLogLocation)) {
                        this.currentPath = archivedLogLocation;
                        LOG.info((Object)("Log " + this.currentPath + " was moved to " + archivedLogLocation));
                        this.openReader(sleepMultiplier);
                    }
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)(this.peerClusterZnode + " Got: "), (Throwable)ioe);
                this.reader = null;
                if (sleepMultiplier != this.maxRetriesMultiplier) break block8;
                LOG.warn((Object)"Waited too long for this file, considering dumping");
            }
        }
        return true;
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        try {
            LOG.debug((Object)(msg + ", sleeping " + this.sleepForRetries + " times " + sleepMultiplier));
            Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Interrupted while sleeping between retries");
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    protected void removeNonReplicableEdits(WALEdit edit) {
        NavigableMap<byte[], Integer> scopes = edit.getScopes();
        List<KeyValue> kvs = edit.getKeyValues();
        for (int i = edit.size() - 1; i >= 0; --i) {
            KeyValue kv = kvs.get(i);
            if (scopes != null && scopes.containsKey(kv.getFamily())) continue;
            kvs.remove(i);
        }
    }

    private int countDistinctRowKeys(WALEdit edit) {
        List<KeyValue> kvs = edit.getKeyValues();
        int distinctRowKeys = 1;
        KeyValue lastKV = kvs.get(0);
        for (int i = 0; i < edit.size(); ++i) {
            if (kvs.get(i).matchingRow(lastKV)) continue;
            ++distinctRowKeys;
        }
        return distinctRowKeys;
    }

    protected void shipEdits(boolean currentWALisBeingWrittenTo) {
        int sleepMultiplier = 1;
        if (this.currentNbEntries == 0) {
            LOG.warn((Object)"Was given 0 edits to ship");
            return;
        }
        block4: while (this.isActive()) {
            if (!this.isPeerEnabled()) {
                if (!this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                ++sleepMultiplier;
                continue;
            }
            try {
                HRegionInterface rrs = this.getRS();
                rrs.replicateLogEntries(Arrays.copyOf(this.entriesArray, this.currentNbEntries));
                if (this.lastLoggedPosition != this.repLogReader.getPosition()) {
                    this.manager.logPositionAndCleanOldLogs(this.currentPath, this.peerClusterZnode, this.repLogReader.getPosition(), this.queueRecovered, currentWALisBeingWrittenTo);
                    this.lastLoggedPosition = this.repLogReader.getPosition();
                }
                this.totalReplicatedEdits += (long)this.currentNbEntries;
                this.metrics.shippedBatchesRate.inc(1);
                this.metrics.shippedOpsRate.inc(this.currentNbOperations);
                this.metrics.setAgeOfLastShippedOp(this.entriesArray[this.currentNbEntries - 1].getKey().getWriteTime());
                break;
            }
            catch (IOException ioe) {
                this.metrics.refreshAgeOfLastShippedOp();
                if (ioe instanceof RemoteException) {
                    ioe = ((RemoteException)((Object)ioe)).unwrapRemoteException();
                    LOG.warn((Object)"Can't replicate because of an error on the remote cluster: ", (Throwable)ioe);
                } else if (ioe instanceof SocketTimeoutException) {
                    this.sleepForRetries("Encountered a SocketTimeoutException. Since thecall to the remote cluster timed out, which is usually caused by a machine failure or a massive slowdown", this.socketTimeoutMultiplier);
                } else {
                    LOG.warn((Object)"Can't replicate because of a local or network error: ", (Throwable)ioe);
                }
                try {
                    boolean down;
                    do {
                        if (down = this.isSlaveDown()) {
                            if (this.sleepForRetries("Since we are unable to replicate", sleepMultiplier)) {
                                ++sleepMultiplier;
                            } else {
                                this.chooseSinks();
                            }
                        }
                        if (!this.isActive()) continue block4;
                    } while (down);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Interrupted while trying to contact the peer cluster");
                }
            }
        }
    }

    protected boolean isPeerEnabled() {
        return this.replicating.get() && this.zkHelper.getPeerEnabled(this.peerId);
    }

    protected boolean processEndOfFile() {
        if (this.queue.size() != 0) {
            this.currentPath = null;
            this.repLogReader.finishCurrentFile();
            this.reader = null;
            return true;
        }
        if (this.queueRecovered) {
            this.manager.closeRecoveredQueue(this);
            LOG.info((Object)"Finished recovering the queue");
            this.running = false;
            return true;
        }
        return false;
    }

    @Override
    public void startup() {
        String n = Thread.currentThread().getName();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error((Object)("Unexpected exception in ReplicationSource," + this.toString()), e);
            }
        };
        Threads.setDaemonThreadRunning(this, n + ".replicationSource," + this.peerClusterZnode, handler);
    }

    @Override
    public void terminate(String reason) {
        this.terminate(reason, null);
    }

    @Override
    public void terminate(String reason, Exception cause) {
        if (cause == null) {
            LOG.info((Object)("Closing source " + this.peerClusterZnode + " because: " + reason));
        } else {
            LOG.error((Object)("Closing source " + this.peerClusterZnode + " because an error occurred: " + reason), (Throwable)cause);
        }
        this.running = false;
        if (!Thread.currentThread().equals(this)) {
            Threads.shutdown(this, this.sleepForRetries);
        }
    }

    private HRegionInterface getRS() throws IOException {
        if (this.currentPeers.size() == 0) {
            throw new IOException(this.peerClusterZnode + " has 0 region servers");
        }
        ServerName address = this.currentPeers.get(this.random.nextInt(this.currentPeers.size()));
        return this.conn.getHRegionConnection(address.getHostname(), address.getPort());
    }

    public boolean isSlaveDown() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        Thread pingThread = new Thread(){

            @Override
            public void run() {
                try {
                    HRegionInterface rrs = ReplicationSource.this.getRS();
                    rrs.getHServerInfo();
                    latch.countDown();
                }
                catch (IOException ex) {
                    if (ex instanceof RemoteException) {
                        ex = ((RemoteException)((Object)ex)).unwrapRemoteException();
                    }
                    LOG.info((Object)("Slave cluster looks down: " + ex.getMessage()));
                }
            }
        };
        pingThread.start();
        boolean down = !latch.await(this.sleepForRetries, TimeUnit.MILLISECONDS);
        pingThread.interrupt();
        return down;
    }

    @Override
    public String getPeerClusterZnode() {
        return this.peerClusterZnode;
    }

    @Override
    public String getPeerClusterId() {
        return this.peerId;
    }

    @Override
    public Path getCurrentPath() {
        return this.currentPath;
    }

    private boolean isActive() {
        return !this.stopper.isStopped() && this.running;
    }

    @Override
    public String getStats() {
        return "Total replicated edits: " + this.totalReplicatedEdits + ", currently replicating from: " + this.currentPath + " at position: " + this.lastLoggedPosition;
    }

    public static class LogsComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.valueOf(this.getTS(o1)).compareTo(this.getTS(o2));
        }

        @Override
        public boolean equals(Object o) {
            return true;
        }

        private long getTS(Path p) {
            String[] parts = p.getName().split("\\.");
            return Long.parseLong(parts[parts.length - 1]);
        }
    }
}

