/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.TableInfoModel;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.util.Bytes;

public class RegionsResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RegionsResource.class);
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public RegionsResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            String tableName = this.tableResource.getName();
            TableInfoModel model = new TableInfoModel(tableName);
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this.servlet.getConfiguration(), Bytes.toBytes(tableName), false);
            for (Map.Entry e : regions.entrySet()) {
                HRegionInfo hri = (HRegionInfo)((Object)e.getKey());
                ServerName addr = (ServerName)e.getValue();
                model.add(new TableRegionModel(tableName, hri.getRegionId(), hri.getStartKey(), hri.getEndKey(), addr.getHostAndPort()));
            }
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (TableNotFoundException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

