/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Bytes;

public class RowResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RowResource.class);
    static final String CHECK_PUT = "put";
    static final String CHECK_DELETE = "delete";
    TableResource tableResource;
    RowSpec rowspec;
    private String check = null;

    public RowResource(TableResource tableResource, String rowspec, String versions, String check) throws IOException {
        this.tableResource = tableResource;
        this.rowspec = new RowSpec(rowspec);
        if (versions != null) {
            this.rowspec.setMaxVersions(Integer.valueOf(versions));
        }
        this.check = check;
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null);
            if (!generator.hasNext()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            int count = 0;
            CellSetModel model = new CellSetModel();
            KeyValue value = (KeyValue)generator.next();
            byte[] rowKey = value.getRow();
            RowModel rowModel = new RowModel(rowKey);
            do {
                if (!Bytes.equals(value.getRow(), rowKey)) {
                    model.addRow(rowModel);
                    rowKey = value.getRow();
                    rowModel = new RowModel(rowKey);
                }
                rowModel.addCell(new CellModel(value.getFamily(), value.getQualifier(), value.getTimestamp(), value.getValue()));
            } while (++count <= this.rowspec.getMaxValues() && (value = (KeyValue)generator.next()) != null);
            model.addRow(rowModel);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)model).build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getBinary(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (!this.rowspec.hasColumns() || this.rowspec.getColumns().length > 1) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null);
            if (!generator.hasNext()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            KeyValue value = (KeyValue)generator.next();
            Response.ResponseBuilder response = Response.ok((Object)value.getValue());
            response.header("X-Timestamp", (Object)value.getTimestamp());
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    Response update(CellSetModel model, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (CHECK_PUT.equalsIgnoreCase(this.check)) {
            return this.checkAndPut(model);
        }
        if (CHECK_DELETE.equalsIgnoreCase(this.check)) {
            return this.checkAndDelete(model);
        }
        if (this.check != null && this.check.length() > 0) {
            LOG.warn((Object)("Unknown check value: " + this.check + ", ignored"));
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            List<RowModel> rows = model.getRows();
            ArrayList<Put> puts = new ArrayList<Put>();
            for (RowModel row : rows) {
                byte[] key = row.getKey();
                if (key == null) {
                    key = this.rowspec.getRow();
                }
                if (key == null) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
                Put put2 = new Put(key);
                int i = 0;
                for (CellModel cell : row.getCells()) {
                    byte[] col = cell.getColumn();
                    if (col == null) {
                        try {
                            col = this.rowspec.getColumns()[i++];
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            col = null;
                        }
                    }
                    if (col == null) {
                        throw new WebApplicationException(Response.Status.BAD_REQUEST);
                    }
                    byte[][] parts = KeyValue.parseColumn(col);
                    if (parts.length == 2 && parts[1].length > 0) {
                        put2.add(parts[0], parts[1], cell.getTimestamp(), cell.getValue());
                        continue;
                    }
                    put2.add(parts[0], null, cell.getTimestamp(), cell.getValue());
                }
                puts.add(put2);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("PUT " + put2.toString()));
            }
            table = pool.getTable(this.tableResource.getName());
            table.put(puts);
            table.flushCommits();
            Response.ResponseBuilder response = Response.ok();
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            Response response2 = response.build();
            return response2;
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    Response updateBinary(byte[] message, HttpHeaders headers, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            byte[] row = this.rowspec.getRow();
            byte[][] columns = this.rowspec.getColumns();
            byte[] column = null;
            if (columns != null) {
                column = columns[0];
            }
            long timestamp = Long.MAX_VALUE;
            List vals = headers.getRequestHeader("X-Row");
            if (vals != null && !vals.isEmpty()) {
                row = Bytes.toBytes((String)vals.get(0));
            }
            if ((vals = headers.getRequestHeader("X-Column")) != null && !vals.isEmpty()) {
                column = Bytes.toBytes((String)vals.get(0));
            }
            if ((vals = headers.getRequestHeader("X-Timestamp")) != null && !vals.isEmpty()) {
                timestamp = Long.valueOf((String)vals.get(0));
            }
            if (column == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            Put put2 = new Put(row);
            byte[][] parts = KeyValue.parseColumn(column);
            if (parts.length == 2 && parts[1].length > 0) {
                put2.add(parts[0], parts[1], timestamp, message);
            } else {
                put2.add(parts[0], null, timestamp, message);
            }
            table = pool.getTable(this.tableResource.getName());
            table.put(put2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PUT " + put2.toString()));
            }
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            Response response = Response.ok().build();
            return response;
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response put(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath() + " " + uriInfo.getQueryParameters()));
        }
        return this.update(model, true);
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    public Response putBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        return this.updateBinary(message, headers, true);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response post(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath() + " " + uriInfo.getQueryParameters()));
        }
        return this.update(model, false);
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public Response postBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream"));
        }
        return this.updateBinary(message, headers, false);
    }

    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETE " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Delete delete = null;
        delete = this.rowspec.hasTimestamp() ? new Delete(this.rowspec.getRow(), this.rowspec.getTimestamp(), null) : new Delete(this.rowspec.getRow());
        for (byte[] column : this.rowspec.getColumns()) {
            byte[][] split = KeyValue.parseColumn(column);
            if (this.rowspec.hasTimestamp()) {
                if (split.length == 2 && split[1].length != 0) {
                    delete.deleteColumns(split[0], split[1], this.rowspec.getTimestamp());
                    continue;
                }
                delete.deleteFamily(split[0], this.rowspec.getTimestamp());
                continue;
            }
            if (split.length == 2 && split[1].length != 0) {
                delete.deleteColumns(split[0], split[1]);
                continue;
            }
            delete.deleteFamily(split[0]);
        }
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            table = pool.getTable(this.tableResource.getName());
            table.delete(delete);
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE " + delete.toString()));
            }
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
        return Response.ok().build();
    }

    Response checkAndPut(CellSetModel model) {
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        try {
            CellModel valueToPutCell;
            if (model.getRows().size() != 1) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            List<CellModel> cellModels = rowModel.getCells();
            int cellModelCount = cellModels.size();
            if (key == null || cellModelCount <= 1) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            Put put2 = new Put(key);
            CellModel valueToCheckCell = cellModels.get(cellModelCount - 1);
            byte[] valueToCheckColumn = valueToCheckCell.getColumn();
            byte[][] valueToPutParts = KeyValue.parseColumn(valueToCheckColumn);
            if (valueToPutParts.length == 2 && valueToPutParts[1].length > 0) {
                valueToPutCell = null;
                int n = cellModelCount - 1;
                for (int i = 0; i < n; ++i) {
                    if (!Bytes.equals(cellModels.get(i).getColumn(), valueToCheckCell.getColumn())) continue;
                    valueToPutCell = cellModels.get(i);
                    break;
                }
                if (valueToPutCell == null) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            put2.add(valueToPutParts[0], valueToPutParts[1], valueToPutCell.getTimestamp(), valueToPutCell.getValue());
            table = pool.getTable(this.tableResource.getName());
            boolean retValue = table.checkAndPut(key, valueToPutParts[0], valueToPutParts[1], valueToCheckCell.getValue(), put2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("CHECK-AND-PUT " + put2.toString() + ", returns " + retValue));
            }
            table.flushCommits();
            Response.ResponseBuilder response = Response.ok();
            if (!retValue) {
                response = Response.status((int)304);
            }
            Response response2 = response.build();
            return response2;
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    Response checkAndDelete(CellSetModel model) {
        HTablePool pool = this.servlet.getTablePool();
        HTableInterface table = null;
        Delete delete = null;
        try {
            byte[][] parts;
            if (model.getRows().size() != 1) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            if (key == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            delete = new Delete(key);
            CellModel valueToDeleteCell = rowModel.getCells().get(0);
            byte[] valueToDeleteColumn = valueToDeleteCell.getColumn();
            if (valueToDeleteColumn == null) {
                try {
                    valueToDeleteColumn = this.rowspec.getColumns()[0];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            }
            if ((parts = KeyValue.parseColumn(valueToDeleteColumn)).length != 2 || parts[1].length <= 0) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            delete.deleteColumns(parts[0], parts[1]);
            table = pool.getTable(this.tableResource.getName());
            boolean retValue = table.checkAndDelete(key, parts[0], parts[1], valueToDeleteCell.getValue(), delete);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("CHECK-AND-DELETE " + delete.toString() + ", returns " + retValue));
            }
            table.flushCommits();
            Response.ResponseBuilder response = Response.ok();
            if (!retValue) {
                response = Response.status((int)304);
            }
            Response response2 = response.build();
            return response2;
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

