/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.ScannerInstanceResource;
import org.apache.hadoop.hbase.rest.ScannerResultGenerator;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.ScannerModel;

public class ScannerResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(ScannerResource.class);
    static final Map<String, ScannerInstanceResource> scanners = Collections.synchronizedMap(new HashMap());
    TableResource tableResource;

    public ScannerResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    static boolean delete(String id) {
        ScannerInstanceResource instance = scanners.remove(id);
        if (instance != null) {
            instance.generator.close();
            return true;
        }
        return false;
    }

    Response update(ScannerModel model, boolean replace, UriInfo uriInfo) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        byte[] endRow = model.hasEndRow() ? model.getEndRow() : null;
        RowSpec spec = new RowSpec(model.getStartRow(), endRow, model.getColumns(), model.getStartTime(), model.getEndTime(), model.getMaxVersions());
        try {
            Filter filter = ScannerResultGenerator.buildFilterFromModel(model);
            String tableName = this.tableResource.getName();
            ScannerResultGenerator gen = new ScannerResultGenerator(tableName, spec, filter);
            String id = gen.getID();
            ScannerInstanceResource instance = new ScannerInstanceResource(tableName, id, gen, model.getBatch());
            scanners.put(id, instance);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("new scanner: " + id));
            }
            UriBuilder builder = uriInfo.getAbsolutePathBuilder();
            URI uri = builder.path(id).build(new Object[0]);
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            return Response.created((URI)uri).build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.SERVICE_UNAVAILABLE);
        }
        catch (RuntimeException e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            if (e.getCause() instanceof TableNotFoundException) {
                throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response put(ScannerModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PUT " + uriInfo.getAbsolutePath()));
        }
        return this.update(model, true, uriInfo);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf"})
    public Response post(ScannerModel model, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("POST " + uriInfo.getAbsolutePath()));
        }
        return this.update(model, false, uriInfo);
    }

    @Path(value="{scanner: .+}")
    public ScannerInstanceResource getScannerInstanceResource(@PathParam(value="scanner") String id) {
        ScannerInstanceResource instance = scanners.get(id);
        if (instance == null) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.servlet.getMetrics().incrementSucessfulGetRequests(1);
        return instance;
    }
}

