/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.StorageClusterVersionResource;
import org.apache.hadoop.hbase.rest.model.VersionModel;

public class VersionResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(VersionResource.class);
    static CacheControl cacheControl = new CacheControl();

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf"})
    public Response get(@Context ServletContext context, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        Response.ResponseBuilder response = Response.ok((Object)new VersionModel(context));
        response.cacheControl(cacheControl);
        this.servlet.getMetrics().incrementSucessfulGetRequests(1);
        return response.build();
    }

    @Path(value="cluster")
    public StorageClusterVersionResource getClusterVersionResource() throws IOException {
        return new StorageClusterVersionResource();
    }

    @Path(value="rest")
    public VersionResource getVersionResource() {
        return this;
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

