/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;

public class HBasePolicyProvider
extends PolicyProvider {
    protected static Service[] services = new Service[]{new Service("security.client.protocol.acl", HRegionInterface.class), new Service("security.admin.protocol.acl", HMasterInterface.class), new Service("security.masterregion.protocol.acl", HMasterRegionInterface.class)};

    public Service[] getServices() {
        return services;
    }

    public static void init(Configuration conf, ServiceAuthorizationManager authManager) {
        conf.set("hadoop.policy.file", "hbase-policy.xml");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            authManager.refresh(conf, (PolicyProvider)new HBasePolicyProvider());
        }
    }
}

