/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

public abstract class SnapshotTask
implements ForeignExceptionSnare,
Callable<Void> {
    protected final HBaseProtos.SnapshotDescription snapshot;
    protected final ForeignExceptionDispatcher errorMonitor;

    public SnapshotTask(HBaseProtos.SnapshotDescription snapshot, ForeignExceptionDispatcher monitor) {
        assert (monitor != null) : "ForeignExceptionDispatcher must not be null!";
        assert (snapshot != null) : "SnapshotDescription must not be null!";
        this.snapshot = snapshot;
        this.errorMonitor = monitor;
    }

    public void snapshotFailure(String message, Exception e) {
        ForeignException ee = new ForeignException(message, e);
        this.errorMonitor.receive(ee);
    }

    @Override
    public void rethrowException() throws ForeignException {
        this.errorMonitor.rethrowException();
    }

    @Override
    public boolean hasException() {
        return this.errorMonitor.hasException();
    }

    @Override
    public ForeignException getException() {
        return this.errorMonitor.getException();
    }
}

