/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.util.Shell;

public class ThriftServer {
    private static final Log LOG = LogFactory.getLog(ThriftServer.class);
    private static final String MIN_WORKERS_OPTION = "minWorkers";
    private static final String MAX_WORKERS_OPTION = "workers";
    private static final String MAX_QUEUE_SIZE_OPTION = "queue";
    private static final String KEEP_ALIVE_SEC_OPTION = "keepAliveSec";
    static final String BIND_OPTION = "bind";
    static final String COMPACT_OPTION = "compact";
    static final String FRAMED_OPTION = "framed";
    static final String PORT_OPTION = "port";
    private static final String DEFAULT_BIND_ADDR = "0.0.0.0";
    private static final int DEFAULT_LISTEN_PORT = 9090;
    private Configuration conf;
    ThriftServerRunner serverRunner;

    public ThriftServer(Configuration conf) {
        this.conf = HBaseConfiguration.create(conf);
    }

    private static void printUsageAndExit(Options options, int exitCode) throws Shell.ExitCodeException {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, options, "To start the Thrift server run 'bin/hbase-daemon.sh start thrift'\nTo shutdown the thrift server run 'bin/hbase-daemon.sh stop thrift' or send a kill signal to the thrift server pid", true);
        throw new Shell.ExitCodeException(exitCode, "");
    }

    void doMain(String[] args) throws Exception {
        this.processOptions(args);
        this.serverRunner = new ThriftServerRunner(this.conf);
        this.serverRunner.run();
    }

    private void processOptions(String[] args) throws Exception {
        boolean invalidStartStop;
        Options options = new Options();
        options.addOption("b", BIND_OPTION, true, "Address to bind the Thrift server to. Not supported by the Nonblocking and HsHa server [default: 0.0.0.0]");
        options.addOption("p", PORT_OPTION, true, "Port to bind to [default: 9090]");
        options.addOption("f", FRAMED_OPTION, false, "Use framed transport");
        options.addOption("c", COMPACT_OPTION, false, "Use the compact protocol");
        options.addOption("h", "help", false, "Print help information");
        options.addOption("m", MIN_WORKERS_OPTION, true, "The minimum number of worker threads for " + ThriftServerRunner.ImplType.THREAD_POOL.simpleClassName());
        options.addOption("w", MAX_WORKERS_OPTION, true, "The maximum number of worker threads for " + ThriftServerRunner.ImplType.THREAD_POOL.simpleClassName());
        options.addOption("q", MAX_QUEUE_SIZE_OPTION, true, "The maximum number of queued requests in " + ThriftServerRunner.ImplType.THREAD_POOL.simpleClassName());
        options.addOption("k", KEEP_ALIVE_SEC_OPTION, true, "The amount of time in secods to keep a thread alive when idle in " + ThriftServerRunner.ImplType.THREAD_POOL.simpleClassName());
        options.addOptionGroup(ThriftServerRunner.ImplType.createOptionGroup());
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        List<String> commandLine = Arrays.asList(args);
        boolean stop = commandLine.contains("stop");
        boolean start = commandLine.contains("start");
        boolean bl = invalidStartStop = start && stop || !start && !stop;
        if (cmd.hasOption("help") || invalidStartStop) {
            if (invalidStartStop) {
                LOG.error((Object)"Exactly one of 'start' and 'stop' has to be specified");
            }
            ThriftServer.printUsageAndExit(options, 1);
        }
        try {
            int listenPort = Integer.parseInt(cmd.getOptionValue(PORT_OPTION, String.valueOf(9090)));
            this.conf.setInt("hbase.regionserver.thrift.port", listenPort);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Could not parse the value provided for the port option", (Throwable)e);
            ThriftServer.printUsageAndExit(options, -1);
        }
        ThriftServer.optionToConf(cmd, MIN_WORKERS_OPTION, this.conf, "hbase.thrift.minWorkerThreads");
        ThriftServer.optionToConf(cmd, MAX_WORKERS_OPTION, this.conf, "hbase.thrift.maxWorkerThreads");
        ThriftServer.optionToConf(cmd, MAX_QUEUE_SIZE_OPTION, this.conf, "hbase.thrift.maxQueuedRequests");
        ThriftServer.optionToConf(cmd, KEEP_ALIVE_SEC_OPTION, this.conf, "hbase.thrift.threadKeepAliveTimeSec");
        this.conf.setBoolean("hbase.regionserver.thrift.compact", cmd.hasOption(COMPACT_OPTION));
        this.conf.setBoolean("hbase.regionserver.thrift.framed", cmd.hasOption(FRAMED_OPTION));
        if (cmd.hasOption(BIND_OPTION)) {
            this.conf.set("hbase.regionserver.thrift.ipaddress", cmd.getOptionValue(BIND_OPTION));
        }
        ThriftServerRunner.ImplType.setServerImpl(cmd, this.conf);
    }

    public void stop() {
        this.serverRunner.shutdown();
    }

    private static void optionToConf(CommandLine cmd, String option, Configuration conf, String destConfKey) {
        if (cmd.hasOption(option)) {
            String value = cmd.getOptionValue(option);
            LOG.info((Object)("Set configuration key:" + destConfKey + " value:" + value));
            conf.set(destConfKey, value);
        }
    }

    public static void main(String[] args) throws Exception {
        VersionInfo.logVersion();
        try {
            new ThriftServer(HBaseConfiguration.create()).doMain(args);
        }
        catch (Shell.ExitCodeException ex) {
            System.exit(ex.getExitCode());
        }
    }
}

