/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.thrift2.generated.TColumnValue;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TPut
implements TBase<TPut, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TPut");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField COLUMN_VALUES_FIELD_DESC = new TField("columnValues", 15, 2);
    private static final TField TIMESTAMP_FIELD_DESC = new TField("timestamp", 10, 3);
    private static final TField WRITE_TO_WAL_FIELD_DESC = new TField("writeToWal", 2, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ByteBuffer row;
    public List<TColumnValue> columnValues;
    public long timestamp;
    public boolean writeToWal;
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private static final int __WRITETOWAL_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.TIMESTAMP, _Fields.WRITE_TO_WAL};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TPut() {
        this.writeToWal = true;
    }

    public TPut(ByteBuffer row, List<TColumnValue> columnValues) {
        this();
        this.row = row;
        this.columnValues = columnValues;
    }

    public TPut(TPut other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetRow()) {
            this.row = TBaseHelper.copyBinary((ByteBuffer)other.row);
        }
        if (other.isSetColumnValues()) {
            ArrayList<TColumnValue> __this__columnValues = new ArrayList<TColumnValue>();
            for (TColumnValue other_element : other.columnValues) {
                __this__columnValues.add(new TColumnValue(other_element));
            }
            this.columnValues = __this__columnValues;
        }
        this.timestamp = other.timestamp;
        this.writeToWal = other.writeToWal;
    }

    public TPut deepCopy() {
        return new TPut(this);
    }

    public void clear() {
        this.row = null;
        this.columnValues = null;
        this.setTimestampIsSet(false);
        this.timestamp = 0L;
        this.writeToWal = true;
    }

    public byte[] getRow() {
        this.setRow(TBaseHelper.rightSize((ByteBuffer)this.row));
        return this.row == null ? null : this.row.array();
    }

    public ByteBuffer bufferForRow() {
        return this.row;
    }

    public TPut setRow(byte[] row) {
        this.setRow(row == null ? (ByteBuffer)null : ByteBuffer.wrap(row));
        return this;
    }

    public TPut setRow(ByteBuffer row) {
        this.row = row;
        return this;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnValuesSize() {
        return this.columnValues == null ? 0 : this.columnValues.size();
    }

    public Iterator<TColumnValue> getColumnValuesIterator() {
        return this.columnValues == null ? null : this.columnValues.iterator();
    }

    public void addToColumnValues(TColumnValue elem) {
        if (this.columnValues == null) {
            this.columnValues = new ArrayList<TColumnValue>();
        }
        this.columnValues.add(elem);
    }

    public List<TColumnValue> getColumnValues() {
        return this.columnValues;
    }

    public TPut setColumnValues(List<TColumnValue> columnValues) {
        this.columnValues = columnValues;
        return this;
    }

    public void unsetColumnValues() {
        this.columnValues = null;
    }

    public boolean isSetColumnValues() {
        return this.columnValues != null;
    }

    public void setColumnValuesIsSet(boolean value) {
        if (!value) {
            this.columnValues = null;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TPut setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setTimestampIsSet(true);
        return this;
    }

    public void unsetTimestamp() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTimestamp() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setTimestampIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public boolean isWriteToWal() {
        return this.writeToWal;
    }

    public TPut setWriteToWal(boolean writeToWal) {
        this.writeToWal = writeToWal;
        this.setWriteToWalIsSet(true);
        return this;
    }

    public void unsetWriteToWal() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetWriteToWal() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setWriteToWalIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROW: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((ByteBuffer)value);
                break;
            }
            case COLUMN_VALUES: {
                if (value == null) {
                    this.unsetColumnValues();
                    break;
                }
                this.setColumnValues((List)value);
                break;
            }
            case TIMESTAMP: {
                if (value == null) {
                    this.unsetTimestamp();
                    break;
                }
                this.setTimestamp((Long)value);
                break;
            }
            case WRITE_TO_WAL: {
                if (value == null) {
                    this.unsetWriteToWal();
                    break;
                }
                this.setWriteToWal((Boolean)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROW: {
                return this.getRow();
            }
            case COLUMN_VALUES: {
                return this.getColumnValues();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case WRITE_TO_WAL: {
                return this.isWriteToWal();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROW: {
                return this.isSetRow();
            }
            case COLUMN_VALUES: {
                return this.isSetColumnValues();
            }
            case TIMESTAMP: {
                return this.isSetTimestamp();
            }
            case WRITE_TO_WAL: {
                return this.isSetWriteToWal();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TPut) {
            return this.equals((TPut)that);
        }
        return false;
    }

    public boolean equals(TPut that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!this.row.equals(that.row)) {
                return false;
            }
        }
        boolean this_present_columnValues = this.isSetColumnValues();
        boolean that_present_columnValues = that.isSetColumnValues();
        if (this_present_columnValues || that_present_columnValues) {
            if (!this_present_columnValues || !that_present_columnValues) {
                return false;
            }
            if (!((Object)this.columnValues).equals(that.columnValues)) {
                return false;
            }
        }
        boolean this_present_timestamp = this.isSetTimestamp();
        boolean that_present_timestamp = that.isSetTimestamp();
        if (this_present_timestamp || that_present_timestamp) {
            if (!this_present_timestamp || !that_present_timestamp) {
                return false;
            }
            if (this.timestamp != that.timestamp) {
                return false;
            }
        }
        boolean this_present_writeToWal = this.isSetWriteToWal();
        boolean that_present_writeToWal = that.isSetWriteToWal();
        if (this_present_writeToWal || that_present_writeToWal) {
            if (!this_present_writeToWal || !that_present_writeToWal) {
                return false;
            }
            if (this.writeToWal != that.writeToWal) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(TPut other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        TPut typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetRow()).compareTo(typedOther.isSetRow());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRow() && (lastComparison = TBaseHelper.compareTo((Comparable)this.row, (Comparable)typedOther.row)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnValues()).compareTo(typedOther.isSetColumnValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnValues() && (lastComparison = TBaseHelper.compareTo(this.columnValues, typedOther.columnValues)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTimestamp()).compareTo(typedOther.isSetTimestamp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimestamp() && (lastComparison = TBaseHelper.compareTo((long)this.timestamp, (long)typedOther.timestamp)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWriteToWal()).compareTo(typedOther.isSetWriteToWal());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWriteToWal() && (lastComparison = TBaseHelper.compareTo((boolean)this.writeToWal, (boolean)typedOther.writeToWal)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TPut(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.row, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columnValues:");
        if (this.columnValues == null) {
            sb.append("null");
        } else {
            sb.append(this.columnValues);
        }
        first = false;
        if (this.isSetTimestamp()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timestamp:");
            sb.append(this.timestamp);
            first = false;
        }
        if (this.isSetWriteToWal()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("writeToWal:");
            sb.append(this.writeToWal);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.row == null) {
            throw new TProtocolException("Required field 'row' was not present! Struct: " + this.toString());
        }
        if (this.columnValues == null) {
            throw new TProtocolException("Required field 'columnValues' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TPutStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TPutTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROW, new FieldMetaData("row", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMN_VALUES, new FieldMetaData("columnValues", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumnValue.class))));
        tmpMap.put(_Fields.TIMESTAMP, new FieldMetaData("timestamp", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.WRITE_TO_WAL, new FieldMetaData("writeToWal", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TPut.class, metaDataMap);
    }

    private static class TPutTupleScheme
    extends TupleScheme<TPut> {
        private TPutTupleScheme() {
        }

        public void write(TProtocol prot, TPut struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.row);
            oprot.writeI32(struct.columnValues.size());
            for (TColumnValue _iter20 : struct.columnValues) {
                _iter20.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetTimestamp()) {
                optionals.set(0);
            }
            if (struct.isSetWriteToWal()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetTimestamp()) {
                oprot.writeI64(struct.timestamp);
            }
            if (struct.isSetWriteToWal()) {
                oprot.writeBool(struct.writeToWal);
            }
        }

        public void read(TProtocol prot, TPut struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.row = iprot.readBinary();
            struct.setRowIsSet(true);
            TList _list21 = new TList(12, iprot.readI32());
            struct.columnValues = new ArrayList<TColumnValue>(_list21.size);
            for (int _i22 = 0; _i22 < _list21.size; ++_i22) {
                TColumnValue _elem23 = new TColumnValue();
                _elem23.read((TProtocol)iprot);
                struct.columnValues.add(_elem23);
            }
            struct.setColumnValuesIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
            }
            if (incoming.get(1)) {
                struct.writeToWal = iprot.readBool();
                struct.setWriteToWalIsSet(true);
            }
        }
    }

    private static class TPutTupleSchemeFactory
    implements SchemeFactory {
        private TPutTupleSchemeFactory() {
        }

        public TPutTupleScheme getScheme() {
            return new TPutTupleScheme();
        }
    }

    private static class TPutStandardScheme
    extends StandardScheme<TPut> {
        private TPutStandardScheme() {
        }

        public void read(TProtocol iprot, TPut struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.row = iprot.readBinary();
                            struct.setRowIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list16 = iprot.readListBegin();
                            struct.columnValues = new ArrayList<TColumnValue>(_list16.size);
                            for (int _i17 = 0; _i17 < _list16.size; ++_i17) {
                                TColumnValue _elem18 = new TColumnValue();
                                _elem18.read(iprot);
                                struct.columnValues.add(_elem18);
                            }
                            iprot.readListEnd();
                            struct.setColumnValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.timestamp = iprot.readI64();
                            struct.setTimestampIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 2) {
                            struct.writeToWal = iprot.readBool();
                            struct.setWriteToWalIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TPut struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.row != null) {
                oprot.writeFieldBegin(ROW_FIELD_DESC);
                oprot.writeBinary(struct.row);
                oprot.writeFieldEnd();
            }
            if (struct.columnValues != null) {
                oprot.writeFieldBegin(COLUMN_VALUES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columnValues.size()));
                for (TColumnValue _iter19 : struct.columnValues) {
                    _iter19.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimestamp()) {
                oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
                oprot.writeI64(struct.timestamp);
                oprot.writeFieldEnd();
            }
            if (struct.isSetWriteToWal()) {
                oprot.writeFieldBegin(WRITE_TO_WAL_FIELD_DESC);
                oprot.writeBool(struct.writeToWal);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TPutStandardSchemeFactory
    implements SchemeFactory {
        private TPutStandardSchemeFactory() {
        }

        public TPutStandardScheme getScheme() {
            return new TPutStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROW(1, "row"),
        COLUMN_VALUES(2, "columnValues"),
        TIMESTAMP(3, "timestamp"),
        WRITE_TO_WAL(4, "writeToWal");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROW;
                }
                case 2: {
                    return COLUMN_VALUES;
                }
                case 3: {
                    return TIMESTAMP;
                }
                case 4: {
                    return WRITE_TO_WAL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

