/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public abstract class AbstractHBaseTool
implements Tool {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;
    private static final String HELP_OPTION = "help";
    private static final Log LOG = LogFactory.getLog(AbstractHBaseTool.class);
    private final Options options = new Options();
    protected Configuration conf = null;
    private static final Set<String> requiredOptions = new TreeSet<String>();

    protected abstract void addOptions();

    protected abstract void processOptions(CommandLine var1);

    protected abstract void doWork() throws Exception;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public final int run(String[] args) throws Exception {
        CommandLine cmd;
        if (this.conf == null) {
            LOG.error((Object)"Tool configuration is not initialized");
            throw new NullPointerException("conf");
        }
        try {
            cmd = this.parseArgs(args);
        }
        catch (ParseException e) {
            LOG.error((Object)"Error when parsing command-line arguemnts", (Throwable)e);
            this.printUsage();
            return 1;
        }
        if (cmd.hasOption(HELP_OPTION) || !this.sanityCheckOptions(cmd)) {
            this.printUsage();
            return 1;
        }
        this.processOptions(cmd);
        try {
            this.doWork();
        }
        catch (Exception e) {
            LOG.error((Object)"Error running command-line tool", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private boolean sanityCheckOptions(CommandLine cmd) {
        boolean success = true;
        for (String reqOpt : requiredOptions) {
            if (cmd.hasOption(reqOpt)) continue;
            LOG.error((Object)("Required option -" + reqOpt + " is missing"));
            success = false;
        }
        return success;
    }

    private CommandLine parseArgs(String[] args) throws ParseException {
        this.options.addOption(HELP_OPTION, false, "Show usage");
        this.addOptions();
        BasicParser parser = new BasicParser();
        return parser.parse(this.options, args);
    }

    private void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(80);
        String usageHeader = "Options:";
        String usageFooter = "";
        String usageStr = "bin/hbase " + this.getClass().getName() + " <options>";
        helpFormatter.printHelp(usageStr, usageHeader, this.options, usageFooter);
    }

    protected void addRequiredOptWithArg(String opt, String description) {
        requiredOptions.add(opt);
        this.addOptWithArg(opt, description);
    }

    protected void addOptNoArg(String opt, String description) {
        this.options.addOption(opt, false, description);
    }

    protected void addOptWithArg(String opt, String description) {
        this.options.addOption(opt, true, description);
    }

    public static long parseLong(String s, long minValue, long maxValue) {
        long l = Long.parseLong(s);
        if (l < minValue || l > maxValue) {
            throw new IllegalArgumentException("The value " + l + " is out of range [" + minValue + ", " + maxValue + "]");
        }
        return l;
    }

    public static int parseInt(String s, int minValue, int maxValue) {
        return (int)AbstractHBaseTool.parseLong(s, minValue, maxValue);
    }

    protected void doStaticMain(String[] args) {
        int ret;
        try {
            ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)this, (String[])args);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error running command-line tool", (Throwable)ex);
            ret = 1;
        }
        System.exit(ret);
    }
}

