/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import sun.misc.Unsafe;

public class Bytes {
    private static final Log LOG = LogFactory.getLog(Bytes.class);
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    public static final int ESTIMATED_HEAP_TAX = 16;
    public static Comparator<byte[]> BYTES_COMPARATOR = new ByteArrayComparator();
    public static RawComparator<byte[]> BYTES_RAWCOMPARATOR = new ByteArrayComparator();

    public static byte[] readByteArray(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        if (len < 0) {
            throw new NegativeArraySizeException(Integer.toString(len));
        }
        byte[] result = new byte[len];
        in.readFully(result, 0, len);
        return result;
    }

    public static byte[] readByteArrayThrowsRuntime(DataInput in) {
        try {
            return Bytes.readByteArray(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b) throws IOException {
        if (b == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        } else {
            Bytes.writeByteArray(out, b, 0, b.length);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b, int offset, int length) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)length);
        out.write(b, offset, length);
    }

    public static int writeByteArray(byte[] tgt, int tgtOffset, byte[] src, int srcOffset, int srcLength) {
        byte[] vint = Bytes.vintToBytes(srcLength);
        System.arraycopy(vint, 0, tgt, tgtOffset, vint.length);
        int offset = tgtOffset + vint.length;
        System.arraycopy(src, srcOffset, tgt, offset, srcLength);
        return offset + srcLength;
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static byte[] toBytes(ByteBuffer bb) {
        int length = bb.limit();
        byte[] result = new byte[length];
        System.arraycopy(bb.array(), bb.arrayOffset(), result, 0, length);
        return result;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Bytes.toString(b1, 0, b1.length) + sep + Bytes.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        try {
            return new String(b, off, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"UTF-8 not supported?", (Throwable)e);
            return null;
        }
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return Bytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(ByteBuffer buf) {
        if (buf == null) {
            return "null";
        }
        return Bytes.toStringBinary(buf.array(), buf.arrayOffset(), buf.limit());
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?".indexOf(ch) >= 0) {
                    result.append(first.charAt(i));
                    continue;
                }
                result.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"ISO-8859-1 not supported?", (Throwable)e);
        }
        return result.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        return (byte)(ch - 48);
    }

    public static byte[] toBytesBinary(String in) {
        byte[] b = new byte[in.length()];
        int size = 0;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\' && in.length() > i + 1 && in.charAt(i + 1) == 'x') {
                char hd1 = in.charAt(i + 2);
                char hd2 = in.charAt(i + 3);
                if (!Bytes.isHexDigit(hd1) || !Bytes.isHexDigit(hd2)) continue;
                byte d = (byte)((Bytes.toBinaryFromHex((byte)hd1) << 4) + Bytes.toBinaryFromHex((byte)hd2));
                b[size++] = d;
                i += 3;
                continue;
            }
            b[size++] = (byte)ch;
        }
        byte[] b2 = new byte[size];
        System.arraycopy(b, 0, b2, 0, size);
        return b2;
    }

    public static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"UTF-8 not supported?", (Throwable)e);
            return null;
        }
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Bytes.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the" + " capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return Bytes.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, offset, 4));
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        return Bytes.putInt(bytes, offset, Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes) {
        return Bytes.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, offset, 8));
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        return Bytes.putLong(bytes, offset, Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Bytes.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (length != 4 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 4);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return Bytes.toShort(bytes, 0, 2);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Bytes.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (length != 2 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 2);
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] getBytes(ByteBuffer buf) {
        int savedPos = buf.position();
        byte[] newBytes = new byte[buf.remaining()];
        buf.get(newBytes);
        buf.position(savedPos);
        return newBytes;
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(result, 0, val.scale());
        Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes, int offset, BigDecimal val) {
        if (bytes == null) {
            return offset;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        offset = Bytes.putInt(result, offset, val.scale());
        return Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
    }

    public static byte[] vintToBytes(long vint) {
        long i = vint;
        int size = WritableUtils.getVIntSize((long)i);
        byte[] result = new byte[size];
        int offset = 0;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return result;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return result;
    }

    public static long bytesToVint(byte[] buffer) {
        byte firstByte;
        int len;
        int offset = 0;
        if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = buffer[offset++]))) == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset++];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static long readVLong(byte[] buffer, int offset) throws IOException {
        byte firstByte = buffer[offset];
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int compareTo(byte[] left, byte[] right) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(buffer1, offset1, length1, buffer2, offset2, length2);
    }

    @VisibleForTesting
    static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        if (left.length == 0) {
            return true;
        }
        if (left[left.length - 1] != right[right.length - 1]) {
            return false;
        }
        return Bytes.compareTo(left, right) == 0;
    }

    public static boolean equals(byte[] left, int leftOffset, int leftLen, byte[] right, int rightOffset, int rightLen) {
        if (left == right && leftOffset == rightOffset && leftLen == rightLen) {
            return true;
        }
        if (leftLen != rightLen) {
            return false;
        }
        if (leftLen == 0) {
            return true;
        }
        if (left[leftOffset + leftLen - 1] != right[rightOffset + rightLen - 1]) {
            return false;
        }
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(left, leftOffset, leftLen, right, rightOffset, rightLen) == 0;
    }

    public static boolean startsWith(byte[] bytes, byte[] prefix) {
        return bytes != null && prefix != null && bytes.length >= prefix.length && LexicographicalComparerHolder.BEST_COMPARER.compareTo(bytes, 0, prefix.length, prefix, 0, prefix.length) == 0;
    }

    public static int hashCode(byte[] b) {
        return Bytes.hashCode(b, b.length);
    }

    public static int hashCode(byte[] b, int length) {
        return WritableComparator.hashBytes((byte[])b, (int)length);
    }

    public static Integer mapKey(byte[] b) {
        return Bytes.hashCode(b);
    }

    public static Integer mapKey(byte[] b, int length) {
        return Bytes.hashCode(b, length);
    }

    public static byte[] add(byte[] a, byte[] b) {
        return Bytes.add(a, b, HConstants.EMPTY_BYTE_ARRAY);
    }

    public static byte[] add(byte[] a, byte[] b, byte[] c) {
        byte[] result = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        System.arraycopy(c, 0, result, a.length + b.length, c.length);
        return result;
    }

    public static byte[] head(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, 0, result, 0, length);
        return result;
    }

    public static byte[] tail(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, a.length - length, result, 0, length);
        return result;
    }

    public static byte[] padHead(byte[] a, int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return Bytes.add(padding, a);
    }

    public static byte[] padTail(byte[] a, int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return Bytes.add(a, padding);
    }

    public static byte[][] split(byte[] a, byte[] b, int num) {
        return Bytes.split(a, b, false, num);
    }

    public static byte[][] split(byte[] a, byte[] b, boolean inclusive, int num) {
        byte[][] ret = new byte[num + 2][];
        int i = 0;
        Iterable<byte[]> iter = Bytes.iterateOnSplits(a, b, inclusive, num);
        if (iter == null) {
            return null;
        }
        for (byte[] elem : iter) {
            ret[i++] = elem;
        }
        return ret;
    }

    public static Iterable<byte[]> iterateOnSplits(byte[] a, byte[] b, int num) {
        return Bytes.iterateOnSplits(a, b, false, num);
    }

    public static Iterable<byte[]> iterateOnSplits(final byte[] a, final byte[] b, boolean inclusive, final int num) {
        BigInteger intervalBI;
        BigInteger splitsBI;
        byte[] bPadded;
        byte[] aPadded;
        if (a.length < b.length) {
            aPadded = Bytes.padTail(a, b.length - a.length);
            bPadded = b;
        } else if (b.length < a.length) {
            aPadded = a;
            bPadded = Bytes.padTail(b, a.length - b.length);
        } else {
            aPadded = a;
            bPadded = b;
        }
        if (Bytes.compareTo(aPadded, bPadded) >= 0) {
            throw new IllegalArgumentException("b <= a");
        }
        if (num <= 0) {
            throw new IllegalArgumentException("num cannot be < 0");
        }
        byte[] prependHeader = new byte[]{1, 0};
        final BigInteger startBI = new BigInteger(Bytes.add(prependHeader, aPadded));
        BigInteger stopBI = new BigInteger(Bytes.add(prependHeader, bPadded));
        BigInteger diffBI = stopBI.subtract(startBI);
        if (inclusive) {
            diffBI = diffBI.add(BigInteger.ONE);
        }
        if (diffBI.compareTo(splitsBI = BigInteger.valueOf(num + 1)) < 0) {
            return null;
        }
        try {
            intervalBI = diffBI.divide(splitsBI);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught during division", (Throwable)e);
            return null;
        }
        final Iterator<byte[]> iterator = new Iterator<byte[]>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < num + 1;
            }

            @Override
            public byte[] next() {
                ++this.i;
                if (this.i == 0) {
                    return a;
                }
                if (this.i == num + 1) {
                    return b;
                }
                BigInteger curBI = startBI.add(intervalBI.multiply(BigInteger.valueOf(this.i)));
                byte[] padded = curBI.toByteArray();
                padded = padded[1] == 0 ? Bytes.tail(padded, padded.length - 2) : Bytes.tail(padded, padded.length - 1);
                return padded;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return iterator;
            }
        };
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static byte[][] toByteArrays(String[] t) {
        byte[][] result = new byte[t.length][];
        for (int i = 0; i < t.length; ++i) {
            result[i] = Bytes.toBytes(t[i]);
        }
        return result;
    }

    public static byte[][] toByteArrays(String column) {
        return Bytes.toByteArrays(Bytes.toBytes(column));
    }

    public static byte[][] toByteArrays(byte[] column) {
        byte[][] result = new byte[][]{column};
        return result;
    }

    public static int binarySearch(byte[][] arr, byte[] key, int offset, int length, RawComparator<byte[]> comparator) {
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = comparator.compare(key, offset, length, arr[mid], 0, arr[mid].length);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static byte[] incrementBytes(byte[] value, long amount) {
        byte[] val = value;
        if (val.length < 8) {
            byte[] newvalue = val[0] < 0 ? new byte[]{-1, -1, -1, -1, -1, -1, -1, -1} : new byte[8];
            System.arraycopy(val, 0, newvalue, newvalue.length - val.length, val.length);
            val = newvalue;
        } else if (val.length > 8) {
            throw new IllegalArgumentException("Increment Bytes - value too big: " + val.length);
        }
        if (amount == 0L) {
            return val;
        }
        if (val[0] < 0) {
            return Bytes.binaryIncrementNeg(val, amount);
        }
        return Bytes.binaryIncrementPos(val, amount);
    }

    private static byte[] binaryIncrementPos(byte[] value, long amount) {
        long amo = amount;
        int sign = 1;
        if (amount < 0L) {
            amo = -amount;
            sign = -1;
        }
        for (int i = 0; i < value.length; ++i) {
            int cur = (int)amo % 256 * sign;
            amo >>= 8;
            int val = value[value.length - i - 1] & 0xFF;
            int total = val + cur;
            if (total > 255) {
                amo += (long)sign;
                total %= 256;
            } else if (total < 0) {
                amo -= (long)sign;
            }
            value[value.length - i - 1] = (byte)total;
            if (amo != 0L) continue;
            return value;
        }
        return value;
    }

    private static byte[] binaryIncrementNeg(byte[] value, long amount) {
        long amo = amount;
        int sign = 1;
        if (amount < 0L) {
            amo = -amount;
            sign = -1;
        }
        for (int i = 0; i < value.length; ++i) {
            int cur = (int)amo % 256 * sign;
            amo >>= 8;
            int val = (~value[value.length - i - 1] & 0xFF) + 1;
            int total = cur - val;
            if (total >= 0) {
                amo += (long)sign;
            } else if (total < -256) {
                amo -= (long)sign;
                total %= 256;
            }
            value[value.length - i - 1] = (byte)total;
            if (amo != 0L) continue;
            return value;
        }
        return value;
    }

    public static void writeStringFixedSize(DataOutput out, String s, int size) throws IOException {
        byte[] b = Bytes.toBytes(s);
        if (b.length > size) {
            throw new IOException("Trying to write " + b.length + " bytes (" + Bytes.toStringBinary(b) + ") into a field of length " + size);
        }
        out.writeBytes(s);
        for (int i = 0; i < size - s.length(); ++i) {
            out.writeByte(0);
        }
    }

    public static String readStringFixedSize(DataInput in, int size) throws IOException {
        int n;
        byte[] b = new byte[size];
        in.readFully(b);
        for (n = b.length; n > 0 && b[n - 1] == 0; --n) {
        }
        return Bytes.toString(b, 0, n);
    }

    @VisibleForTesting
    static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)theClass.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable t) {
                return Bytes.lexicographicalComparerJavaImpl();
            }
        }

        @VisibleForTesting
        static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;
            static final boolean littleEndian;

            static boolean lessThanUnsigned(long x1, long x2) {
                return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
            }

            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                int i;
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int minLength = Math.min(length1, length2);
                int minWords = minLength / 8;
                int offset1Adj = offset1 + BYTE_ARRAY_BASE_OFFSET;
                int offset2Adj = offset2 + BYTE_ARRAY_BASE_OFFSET;
                for (i = 0; i < minWords * 8; i += 8) {
                    int y;
                    long rw;
                    long lw = theUnsafe.getLong(buffer1, (long)offset1Adj + (long)i);
                    long diff = lw ^ (rw = theUnsafe.getLong(buffer2, (long)offset2Adj + (long)i));
                    if (diff == 0L) continue;
                    if (!littleEndian) {
                        return UnsafeComparer.lessThanUnsigned(lw, rw) ? -1 : 1;
                    }
                    int n = 0;
                    int x = (int)diff;
                    if (x == 0) {
                        x = (int)(diff >>> 32);
                        n = 32;
                    }
                    if ((y = x << 16) == 0) {
                        n += 16;
                    } else {
                        x = y;
                    }
                    y = x << 8;
                    if (y == 0) {
                        n += 8;
                    }
                    return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
                }
                for (i = minWords * 8; i < minLength; ++i) {
                    int a = buffer1[offset1 + i] & 0xFF;
                    int b = buffer2[offset2 + i] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }

            static {
                theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field f = Unsafe.class.getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            return f.get(null);
                        }
                        catch (NoSuchFieldException e) {
                            throw new Error();
                        }
                        catch (IllegalAccessException e) {
                            throw new Error();
                        }
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
            }
        }

        static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
                if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                    return 0;
                }
                int end1 = offset1 + length1;
                int end2 = offset2 + length2;
                int i = offset1;
                for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                    int a = buffer1[i] & 0xFF;
                    int b = buffer2[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return length1 - length2;
            }
        }
    }

    static interface Comparer<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }

    public static class ByteArrayComparator
    implements RawComparator<byte[]> {
        public int compare(byte[] left, byte[] right) {
            return Bytes.compareTo(left, right);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return LexicographicalComparerHolder.BEST_COMPARER.compareTo(b1, s1, l1, b2, s2, l2);
        }
    }
}

