/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class ZKSplitLog {
    private static final Log LOG = LogFactory.getLog(ZKSplitLog.class);
    public static final int DEFAULT_TIMEOUT = 25000;
    public static final int DEFAULT_ZK_RETRIES = 3;
    public static final int DEFAULT_MAX_RESUBMIT = 3;
    public static final int DEFAULT_UNASSIGNED_TIMEOUT = 180000;

    public static String getEncodedNodeName(ZooKeeperWatcher zkw, String filename) {
        return ZKUtil.joinZNode(zkw.splitLogZNode, ZKSplitLog.encode(filename));
    }

    public static String getFileName(String node) {
        String basename = node.substring(node.lastIndexOf(47) + 1);
        return ZKSplitLog.decode(basename);
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLENCODER doesn't support UTF-8");
        }
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLDecoder doesn't support UTF-8");
        }
    }

    public static String getRescanNode(ZooKeeperWatcher zkw) {
        return ZKUtil.joinZNode(zkw.splitLogZNode, "RESCAN");
    }

    public static boolean isRescanNode(ZooKeeperWatcher zkw, String path) {
        String prefix = ZKSplitLog.getRescanNode(zkw);
        if (path.length() <= prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == path.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTaskPath(ZooKeeperWatcher zkw, String path) {
        String dirname = path.substring(0, path.lastIndexOf(47));
        return dirname.equals(zkw.splitLogZNode);
    }

    public static Path getSplitLogDir(Path rootdir, String tmpname) {
        return new Path(new Path(rootdir, "splitlog"), tmpname);
    }

    public static String getSplitLogDirTmpComponent(String worker, String file) {
        return worker + "_" + ZKSplitLog.encode(file);
    }

    public static void markCorrupted(Path rootdir, String logFileName, FileSystem fs) {
        Path file = new Path(ZKSplitLog.getSplitLogDir(rootdir, logFileName), "corrupt");
        try {
            fs.createNewFile(file);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not flag a log file as corrupted. Failed to create " + file), (Throwable)e);
        }
    }

    public static boolean isCorrupted(Path rootdir, String logFileName, FileSystem fs) throws IOException {
        Path file = new Path(ZKSplitLog.getSplitLogDir(rootdir, logFileName), "corrupt");
        boolean isCorrupt = fs.exists(file);
        return isCorrupt;
    }

    public static class Counters {
        public static AtomicLong tot_mgr_log_split_batch_start = new AtomicLong(0L);
        public static AtomicLong tot_mgr_log_split_batch_success = new AtomicLong(0L);
        public static AtomicLong tot_mgr_log_split_batch_err = new AtomicLong(0L);
        public static AtomicLong tot_mgr_new_unexpected_hlogs = new AtomicLong(0L);
        public static AtomicLong tot_mgr_log_split_start = new AtomicLong(0L);
        public static AtomicLong tot_mgr_log_split_success = new AtomicLong(0L);
        public static AtomicLong tot_mgr_log_split_err = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_create_queued = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_create_result = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_already_exists = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_create_err = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_create_retry = new AtomicLong(0L);
        public static AtomicLong tot_mgr_get_data_queued = new AtomicLong(0L);
        public static AtomicLong tot_mgr_get_data_result = new AtomicLong(0L);
        public static AtomicLong tot_mgr_get_data_nonode = new AtomicLong(0L);
        public static AtomicLong tot_mgr_get_data_err = new AtomicLong(0L);
        public static AtomicLong tot_mgr_get_data_retry = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_delete_queued = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_delete_result = new AtomicLong(0L);
        public static AtomicLong tot_mgr_node_delete_err = new AtomicLong(0L);
        public static AtomicLong tot_mgr_resubmit = new AtomicLong(0L);
        public static AtomicLong tot_mgr_resubmit_failed = new AtomicLong(0L);
        public static AtomicLong tot_mgr_null_data = new AtomicLong(0L);
        public static AtomicLong tot_mgr_orphan_task_acquired = new AtomicLong(0L);
        public static AtomicLong tot_mgr_wait_for_zk_delete = new AtomicLong(0L);
        public static AtomicLong tot_mgr_unacquired_orphan_done = new AtomicLong(0L);
        public static AtomicLong tot_mgr_resubmit_threshold_reached = new AtomicLong(0L);
        public static AtomicLong tot_mgr_missing_state_in_delete = new AtomicLong(0L);
        public static AtomicLong tot_mgr_heartbeat = new AtomicLong(0L);
        public static AtomicLong tot_mgr_rescan = new AtomicLong(0L);
        public static AtomicLong tot_mgr_rescan_deleted = new AtomicLong(0L);
        public static AtomicLong tot_mgr_task_deleted = new AtomicLong(0L);
        public static AtomicLong tot_mgr_resubmit_unassigned = new AtomicLong(0L);
        public static AtomicLong tot_mgr_relist_logdir = new AtomicLong(0L);
        public static AtomicLong tot_mgr_resubmit_dead_server_task = new AtomicLong(0L);
        public static AtomicLong tot_wkr_failed_to_grab_task_no_data = new AtomicLong(0L);
        public static AtomicLong tot_wkr_failed_to_grab_task_exception = new AtomicLong(0L);
        public static AtomicLong tot_wkr_failed_to_grab_task_owned = new AtomicLong(0L);
        public static AtomicLong tot_wkr_failed_to_grab_task_lost_race = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_acquired = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_resigned = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_done = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_err = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_heartbeat = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_acquired_rescan = new AtomicLong(0L);
        public static AtomicLong tot_wkr_get_data_queued = new AtomicLong(0L);
        public static AtomicLong tot_wkr_get_data_result = new AtomicLong(0L);
        public static AtomicLong tot_wkr_get_data_retry = new AtomicLong(0L);
        public static AtomicLong tot_wkr_preempt_task = new AtomicLong(0L);
        public static AtomicLong tot_wkr_task_heartbeat_failed = new AtomicLong(0L);
        public static AtomicLong tot_wkr_final_transistion_failed = new AtomicLong(0L);

        public static void resetCounters() throws Exception {
            Field[] flds;
            Class<?> cl = new Counters().getClass();
            for (Field fld : flds = cl.getDeclaredFields()) {
                ((AtomicLong)fld.get(null)).set(0L);
            }
        }
    }

    public static enum TaskState {
        TASK_UNASSIGNED("unassigned"),
        TASK_OWNED("owned"),
        TASK_RESIGNED("resigned"),
        TASK_DONE("done"),
        TASK_ERR("err");

        private final byte[] state;

        private TaskState(String s) {
            this.state = s.getBytes();
        }

        public byte[] get(String serverName) {
            return Bytes.add(this.state, " ".getBytes(), serverName.getBytes());
        }

        public String getWriterName(byte[] data) {
            String str = Bytes.toString(data);
            return str.substring(str.indexOf(32) + 1);
        }

        public boolean equals(byte[] s) {
            if (s.length < this.state.length) {
                return false;
            }
            for (int i = 0; i < this.state.length; ++i) {
                if (this.state[i] == s[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(byte[] s, String serverName) {
            return Arrays.equals(s, this.get(serverName));
        }

        public String toString() {
            return new String(this.state);
        }
    }
}

