/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.BigDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BigDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class LazyBinarySerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)LazyBinarySerDe.class.getName());
    List<String> columnNames;
    List<TypeInfo> columnTypes;
    TypeInfo rowTypeInfo;
    ObjectInspector cachedObjectInspector;
    LazyBinaryStruct cachedLazyBinaryStruct;
    private int serializedSize;
    private SerDeStats stats;
    private boolean lastOperationSerialize;
    private boolean lastOperationDeserialize;
    ByteArrayRef byteArrayRef;
    BytesWritable serializeBytesWritable = new BytesWritable();
    ByteStream.Output serializeByteStream = new ByteStream.Output();
    boolean nullMapKey = false;

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.rowTypeInfo = TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.cachedObjectInspector = LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo(this.rowTypeInfo);
        this.cachedLazyBinaryStruct = (LazyBinaryStruct)LazyBinaryFactory.createLazyBinaryObject(this.cachedObjectInspector);
        LOG.debug((Object)("LazyBinarySerDe initialized with: columnNames=" + this.columnNames + " columnTypes=" + this.columnTypes));
        this.serializedSize = 0;
        this.stats = new SerDeStats();
        this.lastOperationSerialize = false;
        this.lastOperationDeserialize = false;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }

    @Override
    public Object deserialize(Writable field) throws SerDeException {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
        if (field instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)field;
            if (b.getLength() == 0) {
                return null;
            }
            this.byteArrayRef.setData(b.getBytes());
            this.cachedLazyBinaryStruct.init(this.byteArrayRef, 0, b.getLength());
        } else if (field instanceof Text) {
            Text t = (Text)field;
            if (t.getLength() == 0) {
                return null;
            }
            this.byteArrayRef.setData(t.getBytes());
            this.cachedLazyBinaryStruct.init(this.byteArrayRef, 0, t.getLength());
        } else {
            throw new SerDeException(this.getClass().toString() + ": expects either BytesWritable or Text object!");
        }
        this.lastOperationSerialize = false;
        this.lastOperationDeserialize = true;
        return this.cachedLazyBinaryStruct;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        this.serializeByteStream.reset();
        this.nullMapKey = LazyBinarySerDe.serializeStruct(this.serializeByteStream, obj, (StructObjectInspector)objInspector, this.nullMapKey);
        this.serializeBytesWritable.set(this.serializeByteStream.getData(), 0, this.serializeByteStream.getCount());
        this.serializedSize = this.serializeByteStream.getCount();
        this.lastOperationSerialize = true;
        this.lastOperationDeserialize = false;
        return this.serializeBytesWritable;
    }

    private static boolean serializeStruct(ByteStream.Output byteStream, Object obj, StructObjectInspector soi, boolean warnedOnceNullMapKey) {
        if (null == obj) {
            return warnedOnceNullMapKey;
        }
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        int size = fields.size();
        int lasti = 0;
        int nullByte = 0;
        for (int i = 0; i < size; ++i) {
            if (null != soi.getStructFieldData(obj, fields.get(i))) {
                nullByte = (byte)(nullByte | 1 << i % 8);
            }
            if (7 != i % 8 && i != size - 1) continue;
            byteStream.write(nullByte);
            for (int j = lasti; j <= i; ++j) {
                warnedOnceNullMapKey = LazyBinarySerDe.serialize(byteStream, soi.getStructFieldData(obj, fields.get(j)), fields.get(j).getFieldObjectInspector(), false, warnedOnceNullMapKey);
            }
            lasti = i + 1;
            nullByte = 0;
        }
        return warnedOnceNullMapKey;
    }

    public static boolean serialize(ByteStream.Output byteStream, Object obj, ObjectInspector objInspector, boolean skipLengthPrefix, boolean warnedOnceNullMapKey) {
        if (null == obj) {
            return warnedOnceNullMapKey;
        }
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objInspector;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        return warnedOnceNullMapKey;
                    }
                    case BOOLEAN: {
                        boolean v = ((BooleanObjectInspector)poi).get(obj);
                        byteStream.write((byte)(v ? 1 : 0));
                        return warnedOnceNullMapKey;
                    }
                    case BYTE: {
                        ByteObjectInspector boi = (ByteObjectInspector)poi;
                        byte v = boi.get(obj);
                        byteStream.write(v);
                        return warnedOnceNullMapKey;
                    }
                    case SHORT: {
                        ShortObjectInspector spoi = (ShortObjectInspector)poi;
                        short v = spoi.get(obj);
                        byteStream.write((byte)(v >> 8));
                        byteStream.write((byte)v);
                        return warnedOnceNullMapKey;
                    }
                    case INT: {
                        IntObjectInspector ioi = (IntObjectInspector)poi;
                        int v = ioi.get(obj);
                        LazyBinaryUtils.writeVInt(byteStream, v);
                        return warnedOnceNullMapKey;
                    }
                    case LONG: {
                        LongObjectInspector loi = (LongObjectInspector)poi;
                        long v = loi.get(obj);
                        LazyBinaryUtils.writeVLong(byteStream, v);
                        return warnedOnceNullMapKey;
                    }
                    case FLOAT: {
                        FloatObjectInspector foi = (FloatObjectInspector)poi;
                        int v = Float.floatToIntBits(foi.get(obj));
                        byteStream.write((byte)(v >> 24));
                        byteStream.write((byte)(v >> 16));
                        byteStream.write((byte)(v >> 8));
                        byteStream.write((byte)v);
                        return warnedOnceNullMapKey;
                    }
                    case DOUBLE: {
                        DoubleObjectInspector doi = (DoubleObjectInspector)poi;
                        long v = Double.doubleToLongBits(doi.get(obj));
                        byteStream.write((byte)(v >> 56));
                        byteStream.write((byte)(v >> 48));
                        byteStream.write((byte)(v >> 40));
                        byteStream.write((byte)(v >> 32));
                        byteStream.write((byte)(v >> 24));
                        byteStream.write((byte)(v >> 16));
                        byteStream.write((byte)(v >> 8));
                        byteStream.write((byte)v);
                        return warnedOnceNullMapKey;
                    }
                    case STRING: {
                        StringObjectInspector soi = (StringObjectInspector)poi;
                        Text t = soi.getPrimitiveWritableObject(obj);
                        int length = t.getLength();
                        if (!skipLengthPrefix) {
                            LazyBinaryUtils.writeVInt(byteStream, length);
                        }
                        byte[] data = t.getBytes();
                        byteStream.write(data, 0, length);
                        return warnedOnceNullMapKey;
                    }
                    case BINARY: {
                        BinaryObjectInspector baoi = (BinaryObjectInspector)poi;
                        BytesWritable bw = baoi.getPrimitiveWritableObject(obj);
                        int length = bw.getLength();
                        if (!skipLengthPrefix) {
                            LazyBinaryUtils.writeVInt(byteStream, length);
                        } else if (length == 0) {
                            throw new RuntimeException("LazyBinaryColumnarSerde cannot serialize a non-null zero length binary field. Consider using either LazyBinarySerde or ColumnarSerde.");
                        }
                        byteStream.write(bw.getBytes(), 0, length);
                        return warnedOnceNullMapKey;
                    }
                    case TIMESTAMP: {
                        TimestampObjectInspector toi = (TimestampObjectInspector)poi;
                        TimestampWritable t = toi.getPrimitiveWritableObject(obj);
                        t.writeToByteStream(byteStream);
                        return warnedOnceNullMapKey;
                    }
                    case DECIMAL: {
                        BigDecimalObjectInspector bdoi = (BigDecimalObjectInspector)poi;
                        BigDecimalWritable t = bdoi.getPrimitiveWritableObject(obj);
                        t.writeToByteStream(byteStream);
                        return warnedOnceNullMapKey;
                    }
                }
                throw new RuntimeException("Unrecognized type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
            case LIST: {
                int eid;
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                ObjectInspector eoi = loi.getListElementObjectInspector();
                int byteSizeStart = 0;
                int listStart = 0;
                if (!skipLengthPrefix) {
                    byteSizeStart = byteStream.getCount();
                    byteStream.write(0);
                    byteStream.write(0);
                    byteStream.write(0);
                    byteStream.write(0);
                    listStart = byteStream.getCount();
                }
                int size = loi.getListLength(obj);
                LazyBinaryUtils.writeVInt(byteStream, size);
                int nullByte = 0;
                for (eid = 0; eid < size; ++eid) {
                    if (null != loi.getListElement(obj, eid)) {
                        nullByte = (byte)(nullByte | 1 << eid % 8);
                    }
                    if (7 != eid % 8 && eid != size - 1) continue;
                    byteStream.write(nullByte);
                    nullByte = 0;
                }
                for (eid = 0; eid < size; ++eid) {
                    warnedOnceNullMapKey = LazyBinarySerDe.serialize(byteStream, loi.getListElement(obj, eid), eoi, false, warnedOnceNullMapKey);
                }
                if (!skipLengthPrefix) {
                    int listEnd = byteStream.getCount();
                    int listSize = listEnd - listStart;
                    byte[] bytes = byteStream.getData();
                    bytes[byteSizeStart] = (byte)(listSize >> 24);
                    bytes[byteSizeStart + 1] = (byte)(listSize >> 16);
                    bytes[byteSizeStart + 2] = (byte)(listSize >> 8);
                    bytes[byteSizeStart + 3] = (byte)listSize;
                }
                return warnedOnceNullMapKey;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(obj);
                int byteSizeStart = 0;
                int mapStart = 0;
                if (!skipLengthPrefix) {
                    byteSizeStart = byteStream.getCount();
                    byteStream.write(0);
                    byteStream.write(0);
                    byteStream.write(0);
                    byteStream.write(0);
                    mapStart = byteStream.getCount();
                }
                int size = map.size();
                LazyBinaryUtils.writeVInt(byteStream, size);
                int b = 0;
                int nullByte = 0;
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    if (null != entry.getKey()) {
                        nullByte = (byte)(nullByte | 1 << b % 8);
                    } else if (!warnedOnceNullMapKey) {
                        warnedOnceNullMapKey = true;
                        LOG.warn((Object)"Null map key encountered! Ignoring similar problems.");
                    }
                    ++b;
                    if (null != entry.getValue()) {
                        nullByte = (byte)(nullByte | 1 << b % 8);
                    }
                    if (0 != ++b % 8 && b != size * 2) continue;
                    byteStream.write(nullByte);
                    nullByte = 0;
                }
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    warnedOnceNullMapKey = LazyBinarySerDe.serialize(byteStream, entry.getKey(), koi, false, warnedOnceNullMapKey);
                    warnedOnceNullMapKey = LazyBinarySerDe.serialize(byteStream, entry.getValue(), voi, false, warnedOnceNullMapKey);
                }
                if (!skipLengthPrefix) {
                    int mapEnd = byteStream.getCount();
                    int mapSize = mapEnd - mapStart;
                    byte[] bytes = byteStream.getData();
                    bytes[byteSizeStart] = (byte)(mapSize >> 24);
                    bytes[byteSizeStart + 1] = (byte)(mapSize >> 16);
                    bytes[byteSizeStart + 2] = (byte)(mapSize >> 8);
                    bytes[byteSizeStart + 3] = (byte)mapSize;
                }
                return warnedOnceNullMapKey;
            }
            case STRUCT: {
                int byteSizeStart = 0;
                int structStart = 0;
                if (!skipLengthPrefix) {
                    byteSizeStart = byteStream.getCount();
                    byteStream.write(0);
                    byteStream.write(0);
                    byteStream.write(0);
                    byteStream.write(0);
                    structStart = byteStream.getCount();
                }
                warnedOnceNullMapKey = LazyBinarySerDe.serializeStruct(byteStream, obj, (StructObjectInspector)objInspector, warnedOnceNullMapKey);
                if (!skipLengthPrefix) {
                    int structEnd = byteStream.getCount();
                    int structSize = structEnd - structStart;
                    byte[] bytes = byteStream.getData();
                    bytes[byteSizeStart] = (byte)(structSize >> 24);
                    bytes[byteSizeStart + 1] = (byte)(structSize >> 16);
                    bytes[byteSizeStart + 2] = (byte)(structSize >> 8);
                    bytes[byteSizeStart + 3] = (byte)structSize;
                }
                return warnedOnceNullMapKey;
            }
        }
        throw new RuntimeException("Unrecognized type: " + (Object)((Object)objInspector.getCategory()));
    }

    @Override
    public SerDeStats getSerDeStats() {
        assert (this.lastOperationSerialize != this.lastOperationDeserialize);
        if (this.lastOperationSerialize) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.cachedLazyBinaryStruct.getRawDataSerializedSize());
        }
        return this.stats;
    }
}

