/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBigDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;

public final class ObjectInspectorConverters {
    public static Converter getConverter(ObjectInspector inputOI, ObjectInspector outputOI) {
        if (inputOI == outputOI) {
            return new IdentityConverter();
        }
        switch (outputOI.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)outputOI).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return new PrimitiveObjectInspectorConverter.BooleanConverter((PrimitiveObjectInspector)inputOI, (SettableBooleanObjectInspector)outputOI);
                    }
                    case BYTE: {
                        return new PrimitiveObjectInspectorConverter.ByteConverter((PrimitiveObjectInspector)inputOI, (SettableByteObjectInspector)outputOI);
                    }
                    case SHORT: {
                        return new PrimitiveObjectInspectorConverter.ShortConverter((PrimitiveObjectInspector)inputOI, (SettableShortObjectInspector)outputOI);
                    }
                    case INT: {
                        return new PrimitiveObjectInspectorConverter.IntConverter((PrimitiveObjectInspector)inputOI, (SettableIntObjectInspector)outputOI);
                    }
                    case LONG: {
                        return new PrimitiveObjectInspectorConverter.LongConverter((PrimitiveObjectInspector)inputOI, (SettableLongObjectInspector)outputOI);
                    }
                    case FLOAT: {
                        return new PrimitiveObjectInspectorConverter.FloatConverter((PrimitiveObjectInspector)inputOI, (SettableFloatObjectInspector)outputOI);
                    }
                    case DOUBLE: {
                        return new PrimitiveObjectInspectorConverter.DoubleConverter((PrimitiveObjectInspector)inputOI, (SettableDoubleObjectInspector)outputOI);
                    }
                    case STRING: {
                        if (outputOI instanceof WritableStringObjectInspector) {
                            return new PrimitiveObjectInspectorConverter.TextConverter((PrimitiveObjectInspector)inputOI);
                        }
                        if (outputOI instanceof JavaStringObjectInspector) {
                            return new PrimitiveObjectInspectorConverter.StringConverter((PrimitiveObjectInspector)inputOI);
                        }
                    }
                    case TIMESTAMP: {
                        return new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)inputOI, (SettableTimestampObjectInspector)outputOI);
                    }
                    case BINARY: {
                        return new PrimitiveObjectInspectorConverter.BinaryConverter((PrimitiveObjectInspector)inputOI, (SettableBinaryObjectInspector)outputOI);
                    }
                    case DECIMAL: {
                        return new PrimitiveObjectInspectorConverter.BigDecimalConverter((PrimitiveObjectInspector)inputOI, (SettableBigDecimalObjectInspector)outputOI);
                    }
                }
                throw new RuntimeException("Hive internal error: conversion of " + inputOI.getTypeName() + " to " + outputOI.getTypeName() + " not supported yet.");
            }
            case STRUCT: {
                return new StructConverter((StructObjectInspector)inputOI, (SettableStructObjectInspector)outputOI);
            }
            case LIST: {
                return new ListConverter((ListObjectInspector)inputOI, (SettableListObjectInspector)outputOI);
            }
            case MAP: {
                return new MapConverter((MapObjectInspector)inputOI, (SettableMapObjectInspector)outputOI);
            }
        }
        throw new RuntimeException("Hive internal error: conversion of " + inputOI.getTypeName() + " to " + outputOI.getTypeName() + " not supported yet.");
    }

    private ObjectInspectorConverters() {
    }

    public static class MapConverter
    implements Converter {
        MapObjectInspector inputOI;
        SettableMapObjectInspector outputOI;
        ObjectInspector inputKeyOI;
        ObjectInspector outputKeyOI;
        ObjectInspector inputValueOI;
        ObjectInspector outputValueOI;
        ArrayList<Converter> keyConverters;
        ArrayList<Converter> valueConverters;
        Object output;

        public MapConverter(MapObjectInspector inputOI, SettableMapObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.inputKeyOI = inputOI.getMapKeyObjectInspector();
            this.outputKeyOI = outputOI.getMapKeyObjectInspector();
            this.inputValueOI = inputOI.getMapValueObjectInspector();
            this.outputValueOI = outputOI.getMapValueObjectInspector();
            this.keyConverters = new ArrayList();
            this.valueConverters = new ArrayList();
            this.output = outputOI.create();
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            Map<?, ?> map = this.inputOI.getMap(input);
            int size = map.size();
            while (this.keyConverters.size() < size) {
                this.keyConverters.add(ObjectInspectorConverters.getConverter(this.inputKeyOI, this.outputKeyOI));
                this.valueConverters.add(ObjectInspectorConverters.getConverter(this.inputValueOI, this.outputValueOI));
            }
            this.outputOI.clear(this.output);
            int entryID = 0;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object inputKey = entry.getKey();
                Object inputValue = entry.getValue();
                Object outputKey = this.keyConverters.get(entryID).convert(inputKey);
                Object outputValue = this.valueConverters.get(entryID).convert(inputValue);
                ++entryID;
                this.outputOI.put(this.output, outputKey, outputValue);
            }
            return this.output;
        }
    }

    public static class StructConverter
    implements Converter {
        StructObjectInspector inputOI;
        SettableStructObjectInspector outputOI;
        List<? extends StructField> inputFields;
        List<? extends StructField> outputFields;
        ArrayList<Converter> fieldConverters;
        Object output;

        public StructConverter(StructObjectInspector inputOI, SettableStructObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.inputFields = inputOI.getAllStructFieldRefs();
            this.outputFields = outputOI.getAllStructFieldRefs();
            assert (this.inputFields.size() == this.outputFields.size());
            this.fieldConverters = new ArrayList(this.inputFields.size());
            for (int f = 0; f < this.inputFields.size(); ++f) {
                this.fieldConverters.add(ObjectInspectorConverters.getConverter(this.inputFields.get(f).getFieldObjectInspector(), this.outputFields.get(f).getFieldObjectInspector()));
            }
            this.output = outputOI.create();
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            for (int f = 0; f < this.inputFields.size(); ++f) {
                Object inputFieldValue = this.inputOI.getStructFieldData(input, this.inputFields.get(f));
                Object outputFieldValue = this.fieldConverters.get(f).convert(inputFieldValue);
                this.outputOI.setStructFieldData(this.output, this.outputFields.get(f), outputFieldValue);
            }
            return this.output;
        }
    }

    public static class ListConverter
    implements Converter {
        ListObjectInspector inputOI;
        SettableListObjectInspector outputOI;
        ObjectInspector inputElementOI;
        ObjectInspector outputElementOI;
        ArrayList<Converter> elementConverters;
        Object output;

        public ListConverter(ListObjectInspector inputOI, SettableListObjectInspector outputOI) {
            this.inputOI = inputOI;
            this.outputOI = outputOI;
            this.inputElementOI = inputOI.getListElementObjectInspector();
            this.outputElementOI = outputOI.getListElementObjectInspector();
            this.output = outputOI.create(0);
            this.elementConverters = new ArrayList();
        }

        @Override
        public Object convert(Object input) {
            if (input == null) {
                return null;
            }
            int size = this.inputOI.getListLength(input);
            while (this.elementConverters.size() < size) {
                this.elementConverters.add(ObjectInspectorConverters.getConverter(this.inputElementOI, this.outputElementOI));
            }
            this.outputOI.resize(this.output, size);
            for (int index = 0; index < size; ++index) {
                Object inputElement = this.inputOI.getListElement(input, index);
                Object outputElement = this.elementConverters.get(index).convert(inputElement);
                this.outputOI.set(this.output, index, outputElement);
            }
            return this.output;
        }
    }

    public static class IdentityConverter
    implements Converter {
        @Override
        public Object convert(Object input) {
            return input;
        }
    }

    public static interface Converter {
        public Object convert(Object var1);
    }
}

