/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.versionchecker;

import java.util.Map;
import org.pentaho.versionchecker.IVersionCheckDataProvider;
import org.pentaho.versionchecker.util.VersionHelper;
import org.pentaho.versionchecker.util.VersionInfo;

public class BasicVersionCheckerProvider
implements IVersionCheckDataProvider {
    private volatile VersionInfo versionInfo;
    protected int versionRequestFlags = 40;

    public BasicVersionCheckerProvider(Class clazz) {
        this.versionInfo = VersionHelper.getVersionInfo(clazz);
    }

    public void setVersionRequestFlags(int flags) {
        this.versionRequestFlags = flags;
    }

    public String getApplicationID() {
        return this.versionInfo == null ? null : this.versionInfo.getProductID();
    }

    public String getApplicationVersion() {
        return this.versionInfo == null ? null : this.versionInfo.getVersionNumber();
    }

    public void reinit(VersionInfo info) {
        this.versionInfo = info;
    }

    public String getBaseURL() {
        return null;
    }

    public Map getExtraInformation() {
        return null;
    }

    protected int computeOSMask() {
        try {
            String os = System.getProperty("os.name");
            if (os != null) {
                if ((os = os.toLowerCase()).indexOf("windows") >= 0) {
                    return 128;
                }
                if (os.indexOf("mac") >= 0) {
                    return 256;
                }
                if (os.indexOf("linux") >= 0) {
                    return 512;
                }
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public int getDepth() {
        int depth = this.versionRequestFlags + this.computeOSMask();
        return depth;
    }
}

